/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.api.client.graphics.opengl.program;

import corgitaco.betterweather.api.client.graphics.opengl.program.ShaderProgram;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.function.Consumer;
import net.minecraft.resources.IResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public final class ShaderProgramBuilder {
    private final Queue<Integer> queue = new LinkedTransferQueue<Integer>();

    public static ShaderProgramBuilder create() {
        return new ShaderProgramBuilder();
    }

    private ShaderProgramBuilder() {
    }

    @Contract(value="_, _ -> this")
    public ShaderProgramBuilder compile(int type, IResource resource) throws IOException {
        try (InputStream stream = resource.func_199027_b();
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8.newDecoder()));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            int shader = GL20.glCreateShader((int)type);
            GL20.glShaderSource((int)shader, (CharSequence)builder.toString());
            GL20.glCompileShader((int)shader);
            if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
                String infoLog = GL20.glGetShaderInfoLog((int)shader);
                GL20.glDeleteShader((int)shader);
                throw new RuntimeException(infoLog);
            }
            this.queue.offer(shader);
        }
        return this;
    }

    @Contract(value="-> new")
    public ShaderProgram build() {
        return new ShaderProgram(this);
    }

    public void forEach(Consumer<Integer> consumer) {
        this.queue.forEach(consumer);
    }

    public void clean() {
        Integer shader;
        while ((shader = this.queue.poll()) != null) {
            GL20.glDeleteShader((int)shader);
        }
    }
}

