/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.api.season;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import corgitaco.betterweather.api.Climate;
import corgitaco.betterweather.api.season.SubseasonSettings;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public interface Season {
    @Nullable
    public static Season getSeason(World world) {
        return ((Climate)world).getSeason();
    }

    public int getYearLength();

    public int getCurrentYearTime();

    public Key getKey();

    public Phase getPhase();

    public SubseasonSettings getSettings();

    public IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> getCropFavoriteBiomeBonuses();

    default public int getSeasonStartTime() {
        return Season.getSeasonStartTime(this.getKey(), this.getYearLength());
    }

    default public int getSeasonAndPhaseStartTime() {
        return Season.getSeasonAndPhaseStartTime(this.getKey(), this.getPhase(), this.getYearLength());
    }

    public static int getPhaseLength(int seasonLength) {
        return seasonLength / Phase.values().length;
    }

    public static int getSeasonLength(int yearLength) {
        return yearLength / Key.values().length;
    }

    public static int getSeasonStartTime(Key seasonKey, int yearLength) {
        int perSubSeasonLength = Season.getSeasonLength(yearLength);
        return perSubSeasonLength * seasonKey.ordinal();
    }

    public static int getSeasonAndPhaseStartTime(Key seasonKey, Phase phase, int yearLength) {
        int timeInCycleForSeason = Season.getSeasonStartTime(seasonKey, yearLength);
        int phaseTime = Season.getSeasonLength(yearLength) / Phase.values().length;
        return timeInCycleForSeason + phaseTime * phase.ordinal();
    }

    public static Key getSeasonFromTime(int currentYearTime, int yearLength) {
        int seasonLength = yearLength / Key.values().length;
        if (currentYearTime < seasonLength) {
            return Key.SPRING;
        }
        if (currentYearTime < seasonLength * 2) {
            return Key.SUMMER;
        }
        if (currentYearTime < seasonLength * 3) {
            return Key.AUTUMN;
        }
        return Key.WINTER;
    }

    public static enum Phase implements IStringSerializable
    {
        START,
        MID,
        END;

        public static final Codec<Phase> CODEC;
        private static final Map<String, Phase> BY_ID;
        private final TranslationTextComponent translationTextComponent = new TranslationTextComponent("bwseason.season.phase." + this.name().toLowerCase());

        @Nullable
        public static Phase getTypeFromId(String idIn) {
            return BY_ID.get(idIn);
        }

        public static boolean hasType(String value) {
            return BY_ID.containsKey(value);
        }

        public String func_176610_l() {
            return this.name();
        }

        public final TranslationTextComponent translationTextComponent() {
            return this.translationTextComponent;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(Phase::values, Phase::getTypeFromId);
            BY_ID = (Map)Util.func_200696_a((Object)Maps.newHashMap(), nameToTypeMap -> {
                for (Phase phase : Phase.values()) {
                    nameToTypeMap.put(phase.name(), phase);
                }
            });
        }
    }

    public static enum Key implements IStringSerializable
    {
        SPRING,
        SUMMER,
        AUTUMN,
        WINTER;

        public static final Codec<Key> CODEC;
        private static final Map<String, Key> BY_ID;
        private final TranslationTextComponent translationTextComponent = new TranslationTextComponent("bwseason.season.key." + this.name().toLowerCase());

        @Nullable
        public static Key getTypeFromId(String idIn) {
            return BY_ID.get(idIn);
        }

        public static boolean hasType(String value) {
            return BY_ID.containsKey(value);
        }

        public String func_176610_l() {
            return this.name();
        }

        public final TranslationTextComponent translationTextComponent() {
            return this.translationTextComponent;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(Key::values, Key::getTypeFromId);
            BY_ID = (Map)Util.func_200696_a((Object)Maps.newHashMap(), nameToTypeMap -> {
                for (Key key : Key.values()) {
                    nameToTypeMap.put(key.name(), key);
                }
            });
        }
    }
}

