/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.api.weather;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import corgitaco.betterweather.api.BetterWeatherRegistry;
import corgitaco.betterweather.api.client.WeatherEventClient;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.api.weather.WeatherEventClientSettings;
import corgitaco.betterweather.api.weather.WeatherEventSettings;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WeatherEvent
implements WeatherEventSettings {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean MODIFY_TEMPERATURE = false;
    public static final Codec<WeatherEvent> CODEC = BetterWeatherRegistry.WEATHER_EVENT.dispatchStable(WeatherEvent::codec, Function.identity());
    public static final Map<Season.Key, Map<Season.Phase, Double>> NO_SEASON_CHANCES = (Map)Util.func_200696_a(new IdentityHashMap(), map -> {
        for (Season.Key value : Season.Key.values()) {
            IdentityHashMap<Season.Phase, Double> phaseDoubleMap = new IdentityHashMap<Season.Phase, Double>();
            for (Season.Phase phase : Season.Phase.values()) {
                phaseDoubleMap.put(phase, 0.0);
            }
            map.put(value, phaseDoubleMap);
        }
    });
    public static final Map<String, String> VALUE_COMMENTS = (Map)Util.func_200696_a(new HashMap<String, String>(WeatherEventClientSettings.VALUE_COMMENTS), map -> {
        map.put("defaultChance", "What is the default chance for this weather event to occur? This value is only used when Seasons are NOT present in the given dimension.");
        map.put("temperatureOffset", "What is the temperature offset for valid biomes?");
        map.put("humidityOffset", "What is the temperature offset for valid biomes?");
        map.put("isThundering", "Determines whether or not this weather event may spawn lightning and sets world info internally for MC and mods to use.");
        map.put("lightningChance", "How often does lightning spawn? Requires \"isThundering\" to be true.");
        map.put("type", "Target Weather Event's Registry ID to configure settings for in this config.");
        map.put("seasonChances", "What is the chance for this weather event to occur for the given season (phase)?");
        map.put("biomeCondition", "Better Weather uses a prefix system for what biomes weather is allowed to function in.\n Prefix Guide:\n \"#\" - Biome category representable.\n \"$\" - Biome dictionary representable.\n \",\" - Creates a new condition, separate from the previous.\n \"ALL\" - Spawn in all biomes(no condition).\n \"!\" - Negates/flips/does the reverse of the condition.\n \"\" - No prefix serves as a biome ID OR Mod ID representable.\n\n Here are a few examples:\n1. \"byg#THE_END, $OCEAN\" would mean that the ore may spawn in biomes with the name space \"byg\" AND in the \"END\" biome category, OR all biomes in the \"OCEAN\" dictionary.\n2. \"byg:guiana_shield, #MESA\" would mean that the ore may spawn in the \"byg:guiana_shield\" OR all biomes in the \"MESA\" category.\n3. \"byg#ICY$MOUNTAIN\" would mean that the ore may only spawn in biomes from byg in the \"ICY\" category and \"MOUNTAIN\" dictionary type.\n4. \"!byg#DESERT\" would mean that the ore may only spawn in biomes that are NOT from byg and NOT in the \"DESERT\" category.\n5. \"ALL\", spawn everywhere. \n6. \"\" Don't spawn anywhere.");
    });
    private final String biomeCondition;
    private final double defaultChance;
    private final double temperatureOffsetRaw;
    private final double humidityOffsetRaw;
    private final boolean isThundering;
    private final int lightningFrequency;
    private final Map<Season.Key, Map<Season.Phase, Double>> seasonChances;
    private final ReferenceArraySet<Biome> validBiomes = new ReferenceArraySet();
    private WeatherEventClientSettings clientSettings;
    private WeatherEventClient<?> client;
    private String name;

    public WeatherEvent(WeatherEventClientSettings clientSettings, String biomeCondition, double defaultChance, double temperatureOffsetRaw, double humidityOffsetRaw, boolean isThundering, int lightningFrequency, Map<Season.Key, Map<Season.Phase, Double>> seasonChance) {
        this.clientSettings = clientSettings;
        this.biomeCondition = biomeCondition;
        this.defaultChance = defaultChance;
        this.temperatureOffsetRaw = temperatureOffsetRaw;
        this.humidityOffsetRaw = humidityOffsetRaw;
        this.isThundering = isThundering;
        this.lightningFrequency = lightningFrequency;
        this.seasonChances = seasonChance;
    }

    public final double getDefaultChance() {
        return this.defaultChance;
    }

    public final Map<Season.Key, Map<Season.Phase, Double>> getSeasonChances() {
        return this.seasonChances;
    }

    public abstract void worldTick(ServerWorld var1, int var2, long var3);

    public abstract Codec<? extends WeatherEvent> codec();

    public abstract DynamicOps<?> configOps();

    public void livingEntityUpdate(LivingEntity entity) {
    }

    public void chunkTick(Chunk chunk, ServerWorld world) {
    }

    public final void doChunkTick(Chunk chunk, ServerWorld world) {
        this.chunkTick(chunk, world);
    }

    public void onChunkLoad(Chunk chunk, ServerWorld world) {
    }

    public final void doChunkLoad(Chunk chunk, ServerWorld world) {
        this.onChunkLoad(chunk, world);
    }

    public boolean fillBlocksWithWater() {
        return false;
    }

    public boolean spawnSnowInFreezingClimates() {
        return true;
    }

    public final TranslationTextComponent successTranslationTextComponent(String key) {
        return new TranslationTextComponent("commands.bw.setweather.success", new Object[]{new TranslationTextComponent("bw.weather." + key)});
    }

    public WeatherEvent setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void fillBiomes(Registry<Biome> biomeRegistry) {
        Set entries = biomeRegistry.func_239659_c_();
        for (Map.Entry entry : entries) {
            Biome biome = (Biome)entry.getValue();
            RegistryKey key = (RegistryKey)entry.getKey();
            if (!WeatherEvent.conditionPasses(this.biomeCondition, (RegistryKey<Biome>)key, biome)) continue;
            this.validBiomes.add((Object)biome);
        }
    }

    public WeatherEventClientSettings getClientSettings() {
        return this.clientSettings;
    }

    @OnlyIn(value=Dist.CLIENT)
    public WeatherEvent setClientSettings(WeatherEventClientSettings clientSettings) {
        this.clientSettings = clientSettings;
        return this;
    }

    public String getBiomeCondition() {
        return this.biomeCondition;
    }

    public boolean isValidBiome(Biome biome) {
        return this.validBiomes.contains((Object)biome);
    }

    public static boolean conditionPasses(String conditionString, RegistryKey<Biome> biomeKey, Biome biome) {
        if (conditionString.isEmpty()) {
            return false;
        }
        if (conditionString.equalsIgnoreCase("all")) {
            return true;
        }
        String[] conditions = conditionString.trim().split("\\s*,\\s*");
        String biomeNamespace = biomeKey.func_240901_a_().func_110624_b();
        String biomeLocation = biomeKey.func_240901_a_().toString();
        for (String condition : conditions) {
            String[] split = condition.split("(?=[\\$#])");
            boolean categoryExists = true;
            for (String result : split) {
                if (result.equals("!") || !result.startsWith("#")) continue;
                String categoryString = result.substring(1);
                categoryExists = Arrays.stream(Biome.Category.values()).anyMatch(bc -> bc.toString().equalsIgnoreCase(categoryString));
                if (categoryExists) continue;
                LOGGER.error("\"" + categoryString + "\" is not a valid biome category!");
            }
            if (!categoryExists) continue;
            int passes = 0;
            for (String result : split) {
                if (result.equals("!")) continue;
                if (result.startsWith("!")) {
                    result = result.substring(1);
                }
                if (result.startsWith("$")) {
                    if (!BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.getType((String)result.substring(1).toUpperCase(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]))) continue;
                    ++passes;
                    continue;
                }
                if (result.startsWith("#")) {
                    String categoryString = result.substring(1);
                    if (!biome.func_201856_r().func_222352_a().equalsIgnoreCase(categoryString)) continue;
                    ++passes;
                    continue;
                }
                if (!biomeLocation.equalsIgnoreCase(result) || !result.equalsIgnoreCase(biomeNamespace)) continue;
                ++passes;
            }
            boolean isFlipped = condition.startsWith("!");
            if (passes == 0 && isFlipped) {
                return true;
            }
            if (passes <= 0 || isFlipped) continue;
            return true;
        }
        return false;
    }

    public double getTemperatureOffsetRaw() {
        return this.temperatureOffsetRaw;
    }

    public double getHumidityOffsetRaw() {
        return this.humidityOffsetRaw;
    }

    public boolean isThundering() {
        return this.isThundering;
    }

    public int getLightningChance() {
        return this.lightningFrequency;
    }

    @OnlyIn(value=Dist.CLIENT)
    public WeatherEventClient<?> getClient() {
        return this.client;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClient(WeatherEventClient<?> client) {
        this.client = client;
    }
}

