/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.client.audio;

import corgitaco.betterweather.api.weather.WeatherEvent;
import corgitaco.betterweather.api.weather.WeatherEventAudio;
import corgitaco.betterweather.api.weather.WeatherEventClientSettings;
import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.weather.BWWeatherEventContext;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.IAmbientSoundHandler;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WeatherSoundHandler
implements IAmbientSoundHandler {
    private final ClientPlayerEntity player;
    private final SoundHandler soundHandler;
    private final BiomeManager biomeManager;
    private final ClientWorld world;
    private Sound currentSound;

    public WeatherSoundHandler(ClientPlayerEntity player, SoundHandler soundHandler, BiomeManager biomeManager) {
        this.player = player;
        this.soundHandler = soundHandler;
        this.biomeManager = biomeManager;
        this.world = player.field_213837_d;
    }

    public void func_204253_a() {
        BWWeatherEventContext weatherEventContext = ((BetterWeatherWorldData)this.player.field_213837_d).getWeatherEventContext();
        if (weatherEventContext == null) {
            return;
        }
        WeatherEvent currentEvent = weatherEventContext.getCurrentEvent();
        WeatherEventClientSettings clientSettings = currentEvent.getClientSettings();
        if (clientSettings instanceof WeatherEventAudio) {
            Biome currentBiome = this.biomeManager.func_226836_a_(this.player.func_233580_cy_());
            if (currentEvent.isValidBiome(currentBiome)) {
                if (this.currentSound == null) {
                    this.currentSound = new Sound(((WeatherEventAudio)((Object)clientSettings)).getSound(), this.world, ((WeatherEventAudio)((Object)clientSettings)).getVolume(), ((WeatherEventAudio)((Object)clientSettings)).getPitch());
                    this.soundHandler.func_147682_a((ISound)this.currentSound);
                }
                if ((double)this.world.field_73004_o == 1.0) {
                    this.currentSound.fadeInSound();
                }
            } else {
                this.endAudio();
            }
        } else {
            this.endAudio();
        }
    }

    private void endAudio() {
        if (this.currentSound != null) {
            this.currentSound.fadeOutSound();
            if (this.currentSound.func_147667_k()) {
                this.currentSound = null;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Sound
    extends TickableSound {
        private static final Vector3d[] vector3ds = Sound.vectorDistribution(1000);
        private final ClientWorld world;
        private final float maxVolume;
        private int fadeSpeed;
        private int fadeInTicks;
        private boolean overrideRainStrength = false;
        private float decreasedVolume;
        private int fadeLimit = 40;

        public Sound(SoundEvent sound, ClientWorld world, float volume, float pitch) {
            super(sound, SoundCategory.WEATHER);
            this.world = world;
            this.field_147659_g = true;
            this.field_147665_h = 0;
            this.field_147662_b = volume;
            this.field_147663_c = pitch;
            this.maxVolume = volume;
        }

        private static Vector3d[] vectorDistribution(int samples) {
            ArrayList<Vector3d> points = new ArrayList<Vector3d>();
            double phi = Math.PI * (3.0 - Math.sqrt(5.0));
            for (int i = samples / 4; i < samples; ++i) {
                double y = 1.0f - (float)i / (float)(samples - 1) * 2.0f;
                double radius = Math.sqrt(1.0 - y * y);
                double theta = phi * (double)i;
                double x = Math.cos(theta) * radius;
                double z = Math.sin(theta) * radius;
                points.add(new Vector3d(x, -y, z));
            }
            return points.toArray(new Vector3d[0]);
        }

        public void func_73660_a() {
            if (this.field_147662_b == 0.0f) {
                this.func_239509_o_();
            }
            Vector3d startPos = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            byte brightness = (byte)this.world.func_226658_a_(LightType.SKY, new BlockPos(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c));
            int vectorDistance = 35;
            double maxDistanceNormalised = 0.0;
            int vector3dsLength = vector3ds.length;
            for (int i = 0; i < vector3dsLength; ++i) {
                Vector3d endPos = startPos.func_178787_e(vector3ds[i].func_186678_a((double)vectorDistance));
                BlockRayTraceResult result = this.world.func_217299_a(new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
                if (result.func_216346_c() == RayTraceResult.Type.MISS) {
                    maxDistanceNormalised += (double)this.maxVolume;
                }
                Vector3d hitVec = result.func_216347_e();
                Vector3d dif = startPos.func_178788_d(hitVec);
                float distance = (float)dif.func_72433_c() / (float)vectorDistance;
                maxDistanceNormalised += MathHelper.func_219803_d((double)((float)brightness / 15.0f), (double)(startPos.field_72448_b < (double)this.world.func_181545_F() ? 1.0E-13 : (double)distance), (double)Math.pow(distance, 0.25));
            }
            this.decreasedVolume = (float)(maxDistanceNormalised / (double)vector3ds.length) * (player.func_208600_a((ITag)FluidTags.field_206959_a) || player.func_208600_a((ITag)FluidTags.field_206960_b) ? 0.2f : 1.0f);
            this.fadeInTicks += this.fadeSpeed;
            this.field_147662_b = MathHelper.func_76131_a((float)this.world.func_72867_j(Minecraft.func_71410_x().func_184121_ak()), (float)0.0f, (float)this.decreasedVolume);
        }

        public void fadeOutSound() {
            this.fadeInTicks = Math.min(this.fadeInTicks, this.fadeLimit);
            this.fadeSpeed = -1;
        }

        public void fadeInSound() {
            this.fadeInTicks = Math.max(0, this.fadeInTicks);
            this.fadeSpeed = 1;
        }
    }
}

