/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.data.network.packet.season;

import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.helpers.BiomeUpdate;
import corgitaco.betterweather.season.SeasonContext;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.network.NetworkEvent;

public class SeasonContextConstructingPacket {
    private final SeasonContext seasonContext;

    public SeasonContextConstructingPacket(SeasonContext seasonContext) {
        this.seasonContext = seasonContext;
    }

    public static void writeToPacket(SeasonContextConstructingPacket packet, PacketBuffer buf) {
        try {
            buf.func_240629_a_(SeasonContext.PACKET_CODEC, (Object)packet.seasonContext);
        }
        catch (IOException e) {
            throw new IllegalStateException("Season packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static SeasonContextConstructingPacket readFromPacket(PacketBuffer buf) {
        try {
            return new SeasonContextConstructingPacket((SeasonContext)buf.func_240628_a_(SeasonContext.PACKET_CODEC));
        }
        catch (IOException e) {
            throw new IllegalStateException("Season packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static void handle(SeasonContextConstructingPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Minecraft minecraft = Minecraft.func_71410_x();
                ClientWorld world = minecraft.field_71441_e;
                if (world != null && minecraft.field_71439_g != null) {
                    SeasonContext seasonContext = ((BetterWeatherWorldData)world).getSeasonContext();
                    if (seasonContext == null) {
                        seasonContext = ((BetterWeatherWorldData)world).setSeasonContext(new SeasonContext(message.seasonContext.getCurrentYearTime(), message.seasonContext.getYearLength(), world.func_234923_W_().func_240901_a_(), message.seasonContext.getCropFavoriteBiomeBonuses(), (Registry<Biome>)world.func_241828_r().func_243612_b(Registry.field_239720_u_), message.seasonContext.getSeasons()));
                        ((BiomeUpdate)world).updateBiomeData();
                    }
                    seasonContext.setCurrentYearTime(message.seasonContext.getCurrentYearTime());
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

