/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.data.network.packet.season;

import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.season.SeasonContext;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SeasonTimePacket {
    private final int currentSeasonYearTime;

    public SeasonTimePacket(int currentSeasonYearTime) {
        this.currentSeasonYearTime = currentSeasonYearTime;
    }

    public static void writeToPacket(SeasonTimePacket packet, PacketBuffer buf) {
        buf.writeInt(packet.currentSeasonYearTime);
    }

    public static SeasonTimePacket readFromPacket(PacketBuffer buf) {
        return new SeasonTimePacket(buf.readInt());
    }

    public static void handle(SeasonTimePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Minecraft minecraft = Minecraft.func_71410_x();
                ClientWorld world = minecraft.field_71441_e;
                if (world != null && minecraft.field_71439_g != null) {
                    SeasonContext seasonContext = ((BetterWeatherWorldData)world).getSeasonContext();
                    seasonContext.setCurrentYearTime(message.currentSeasonYearTime);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

