/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.data.network.packet.weather;

import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.helpers.BiomeUpdate;
import corgitaco.betterweather.weather.BWWeatherEventContext;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.network.NetworkEvent;

public class WeatherContextConstructingPacket {
    private final BWWeatherEventContext bwWeatherEventContext;

    public WeatherContextConstructingPacket(BWWeatherEventContext bwWeatherEventContext) {
        this.bwWeatherEventContext = bwWeatherEventContext;
    }

    public static void writeToPacket(WeatherContextConstructingPacket packet, PacketBuffer buf) {
        try {
            buf.func_240629_a_(BWWeatherEventContext.PACKET_CODEC, (Object)packet.bwWeatherEventContext);
        }
        catch (IOException e) {
            throw new IllegalStateException("Weather packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static WeatherContextConstructingPacket readFromPacket(PacketBuffer buf) {
        try {
            return new WeatherContextConstructingPacket((BWWeatherEventContext)buf.func_240628_a_(BWWeatherEventContext.PACKET_CODEC));
        }
        catch (IOException e) {
            throw new IllegalStateException("Weather packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static void handle(WeatherContextConstructingPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                BWWeatherEventContext weatherEventContext;
                Minecraft minecraft = Minecraft.func_71410_x();
                ClientWorld world = minecraft.field_71441_e;
                if (world != null && minecraft.field_71439_g != null && (weatherEventContext = ((BetterWeatherWorldData)world).getWeatherEventContext()) == null) {
                    weatherEventContext = ((BetterWeatherWorldData)world).setWeatherEventContext(new BWWeatherEventContext(message.bwWeatherEventContext.getCurrentWeatherEventKey(), message.bwWeatherEventContext.isWeatherForced(), world.func_234923_W_().func_240901_a_(), (Registry<Biome>)world.func_241828_r().func_243612_b(Registry.field_239720_u_), message.bwWeatherEventContext.getWeatherEvents()));
                    weatherEventContext.setCurrentEvent(message.bwWeatherEventContext.getCurrentEvent());
                    ((BiomeUpdate)world).updateBiomeData();
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

