/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.data.storage;

import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class SeasonSavedData
extends WorldSavedData {
    private static final String DATA_NAME = new ResourceLocation("betterweather", "season_data").toString();
    private static final String CURRENT_YEAR_TIME_KEY = "seasontime";
    private static final String YEAR_LENGTH_KEY = "seasoncyclelength";
    private int currentYearTime;
    private int yearLength;
    private static SeasonSavedData clientCache = new SeasonSavedData();
    private static ClientWorld worldCache = null;

    public SeasonSavedData() {
        super(DATA_NAME);
    }

    public SeasonSavedData(String s) {
        super(s);
    }

    public static SeasonSavedData get(IWorld world) {
        if (!(world instanceof ServerWorld)) {
            if (worldCache != world) {
                worldCache = (ClientWorld)world;
                clientCache = new SeasonSavedData();
            }
            return clientCache;
        }
        DimensionSavedDataManager data = ((ServerWorld)world).func_217481_x();
        SeasonSavedData weatherData = (SeasonSavedData)data.func_215752_a(SeasonSavedData::new, DATA_NAME);
        if (weatherData == null) {
            weatherData = new SeasonSavedData();
            data.func_215757_a((WorldSavedData)weatherData);
        }
        return weatherData;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.setCurrentYearTime(nbt.func_74762_e(CURRENT_YEAR_TIME_KEY));
        this.setYearLength(nbt.func_74762_e(YEAR_LENGTH_KEY));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a(CURRENT_YEAR_TIME_KEY, this.currentYearTime);
        compound.func_74768_a(YEAR_LENGTH_KEY, this.yearLength);
        return compound;
    }

    public int getCurrentYearTime() {
        return this.currentYearTime;
    }

    public void setCurrentYearTime(int currentYearTime) {
        this.currentYearTime = currentYearTime;
        this.func_76185_a();
    }

    public int getYearLength() {
        return this.yearLength;
    }

    public void setYearLength(int yearLength) {
        this.yearLength = yearLength;
    }
}

