/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.data.storage;

import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class WeatherEventSavedData
extends WorldSavedData {
    public static String DATA_NAME = new ResourceLocation("betterweather", "weather_event_data").toString();
    private boolean isWeatherForced;
    private boolean modified;
    private String event;
    private static WeatherEventSavedData clientCache = new WeatherEventSavedData();
    private static ClientWorld worldCache = null;

    public WeatherEventSavedData() {
        super(DATA_NAME);
    }

    public WeatherEventSavedData(String s) {
        super(s);
    }

    public static WeatherEventSavedData get(IWorld world) {
        if (!(world instanceof ServerWorld)) {
            if (worldCache != world) {
                worldCache = (ClientWorld)world;
                clientCache = new WeatherEventSavedData();
            }
            return clientCache;
        }
        DimensionSavedDataManager data = ((ServerWorld)world).func_217481_x();
        WeatherEventSavedData weatherData = (WeatherEventSavedData)data.func_215752_a(WeatherEventSavedData::new, DATA_NAME);
        if (weatherData == null) {
            weatherData = new WeatherEventSavedData();
            data.func_215757_a((WorldSavedData)weatherData);
        }
        return weatherData;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.setEvent(nbt.func_74779_i("Event"));
        this.setWeatherForced(nbt.func_74767_n("Forced"));
        this.setModified(nbt.func_74767_n("Modified"));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74778_a("Event", this.event);
        compound.func_74757_a("Forced", this.isWeatherForced);
        compound.func_74757_a("Modified", this.modified);
        return compound;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
        this.func_76185_a();
    }

    public boolean isWeatherForced() {
        return this.isWeatherForced;
    }

    public void setWeatherForced(boolean weatherForced) {
        this.isWeatherForced = weatherForced;
        this.func_76185_a();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.func_76185_a();
    }
}

