/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.mixin.biome;

import corgitaco.betterweather.api.BiomeClimate;
import corgitaco.betterweather.helpers.BiomeModifier;
import java.util.function.Supplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={Biome.Climate.class})
public abstract class MixinBiomeClimate
implements BiomeModifier,
BiomeClimate {
    private Supplier<Float> seasonTempModifier = () -> Float.valueOf(0.0f);
    private Supplier<Float> seasonHumidityModifier = () -> Float.valueOf(0.0f);
    private Supplier<Float> weatherTempModifier = () -> Float.valueOf(0.0f);
    private Supplier<Float> weatherHumidityModifier = () -> Float.valueOf(0.0f);

    @Override
    public double getTemperatureModifier() {
        return this.seasonTempModifier.get().floatValue() + this.weatherTempModifier.get().floatValue();
    }

    @Override
    public double getSeasonTemperatureModifier() {
        return this.seasonTempModifier.get().floatValue();
    }

    @Override
    public double getWeatherTemperatureModifier(BlockPos pos) {
        return this.weatherTempModifier.get().floatValue();
    }

    @Override
    public double getHumidityModifier() {
        return this.seasonHumidityModifier.get().floatValue() + this.weatherHumidityModifier.get().floatValue();
    }

    @Override
    public double getSeasonHumidityModifier() {
        return this.seasonHumidityModifier.get().floatValue();
    }

    @Override
    public double getWeatherHumidityModifier(BlockPos pos) {
        return this.weatherHumidityModifier.get().floatValue();
    }

    @Override
    public void setSeasonTempModifier(float tempModifier) {
        this.seasonTempModifier = () -> Float.valueOf(tempModifier);
    }

    @Override
    public void setSeasonHumidityModifier(float humidityModifier) {
        this.seasonHumidityModifier = () -> Float.valueOf(humidityModifier);
    }

    @Override
    public void setWeatherTempModifier(float tempModifier) {
        this.weatherTempModifier = () -> Float.valueOf(tempModifier);
    }

    @Override
    public void setWeatherHumidityModifier(float humidityModifier) {
        this.weatherHumidityModifier = () -> Float.valueOf(humidityModifier);
    }
}

