/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.mixin.client;

import corgitaco.betterweather.api.Climate;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.helpers.BiomeModifier;
import corgitaco.betterweather.helpers.BiomeUpdate;
import corgitaco.betterweather.season.SeasonContext;
import corgitaco.betterweather.weather.BWWeatherEventContext;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientWorld.class})
public abstract class MixinClientWorld
implements BetterWeatherWorldData,
Climate,
BiomeUpdate {
    @Nullable
    SeasonContext seasonContext;
    @Nullable
    private BWWeatherEventContext weatherContext;

    @Shadow
    public abstract DynamicRegistries func_241828_r();

    @Override
    @Nullable
    public SeasonContext getSeasonContext() {
        return this.seasonContext;
    }

    @Override
    @Nullable
    public SeasonContext setSeasonContext(SeasonContext seasonContext) {
        this.seasonContext = seasonContext;
        return this.seasonContext;
    }

    @Override
    @Nullable
    public BWWeatherEventContext getWeatherEventContext() {
        return this.weatherContext;
    }

    @Override
    @Nullable
    public BWWeatherEventContext setWeatherEventContext(BWWeatherEventContext weatherEventContext) {
        this.weatherContext = weatherEventContext;
        return this.weatherContext;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(BooleanSupplier hasTicksLeft, CallbackInfo ci) {
        if (this.seasonContext != null) {
            this.seasonContext.tick((World)((ClientWorld)this));
        }
        if (this.weatherContext != null) {
            this.weatherContext.tick((World)((ClientWorld)this));
        }
    }

    @Override
    public Season getSeason() {
        return this.seasonContext;
    }

    @Override
    public void updateBiomeData() {
        for (Map.Entry entry : this.func_241828_r().func_243612_b(Registry.field_239720_u_).func_239659_c_()) {
            Biome biome = (Biome)entry.getValue();
            RegistryKey biomeKey = (RegistryKey)entry.getKey();
            float seasonHumidityModifier = this.seasonContext == null ? 0.0f : (float)this.seasonContext.getCurrentSubSeasonSettings().getHumidityModifier((RegistryKey<Biome>)biomeKey);
            float seasonTemperatureModifier = this.seasonContext == null ? 0.0f : (float)this.seasonContext.getCurrentSubSeasonSettings().getTemperatureModifier((RegistryKey<Biome>)biomeKey);
            float weatherHumidityModifier = this.weatherContext == null ? 0.0f : (float)this.weatherContext.getCurrentWeatherEventSettings().getHumidityModifierAtPosition(null);
            float weatherTemperatureModifier = this.weatherContext == null ? 0.0f : (float)this.weatherContext.getCurrentWeatherEventSettings().getTemperatureModifierAtPosition(null);
            ((BiomeModifier)biome).setSeasonTempModifier(seasonTemperatureModifier);
            ((BiomeModifier)biome).setSeasonHumidityModifier(seasonHumidityModifier);
            ((BiomeModifier)biome).setWeatherTempModifier(weatherTemperatureModifier);
            ((BiomeModifier)biome).setWeatherHumidityModifier(weatherHumidityModifier);
        }
    }

    @Redirect(method={"getSkyColor"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainStrength(F)F"))
    private float doNotDarkenSkyWithRainStrength(ClientWorld world, float delta) {
        return this.weatherContext != null ? 0.0f : world.func_72867_j(delta);
    }

    @Redirect(method={"getCloudColor"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainStrength(F)F"))
    private float doNotDarkenCloudsWithRainStrength(ClientWorld world, float delta) {
        return this.weatherContext != null ? 0.0f : world.func_72867_j(delta);
    }

    @Redirect(method={"getSunBrightness"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainStrength(F)F"))
    private float sunBrightness(ClientWorld world, float delta) {
        float rainStrength = ((ClientWorld)this).func_72867_j(delta);
        BWWeatherEventContext weatherContext = this.weatherContext;
        return weatherContext != null ? rainStrength * weatherContext.getCurrentEvent().getClientSettings().dayLightDarkness() : rainStrength;
    }
}

