/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.mixin.client;

import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.season.BWSeason;
import corgitaco.betterweather.season.BWSubseasonSettings;
import corgitaco.betterweather.season.SeasonContext;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class MixinItemStack {
    private static final double ONE_THIRDS = 0.3333333333333333;
    private static final double TWO_THIRDS = 0.6666666666666666;

    @Shadow
    public abstract Item func_77973_b();

    @Inject(method={"getTooltip"}, at={@At(value="RETURN")})
    private void addCropFertility(PlayerEntity playerIn, ITooltipFlag advanced, CallbackInfoReturnable<List<ITextComponent>> cir) {
        if (playerIn == null) {
            return;
        }
        World world = playerIn.func_130014_f_();
        SeasonContext seasonContext = ((BetterWeatherWorldData)world).getSeasonContext();
        if (seasonContext == null) {
            return;
        }
        Item item = this.func_77973_b();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).func_179223_d();
            BWSubseasonSettings currentSubSeasonSettings = seasonContext.getCurrentSubSeasonSettings();
            MutableRegistry biomeRegistry = world.func_241828_r().func_243612_b(Registry.field_239720_u_);
            RegistryKey currentBiomeKey = (RegistryKey)biomeRegistry.func_230519_c_((Object)world.func_226691_t_(playerIn.func_233580_cy_())).get();
            double currentSeasonBiomeCropGrowthMultiplier = currentSubSeasonSettings.getCropGrowthMultiplier((RegistryKey<Biome>)currentBiomeKey, block);
            if (currentSubSeasonSettings.getEnhancedCrops().contains((Object)block)) {
                Minecraft mc = Minecraft.func_71410_x();
                List toolTips = (List)cir.getReturnValue();
                if (InputMappings.func_216506_a((long)mc.func_228018_at_().func_198092_i(), (int)mc.field_71474_y.field_228046_af_.getKey().func_197937_c())) {
                    Object2DoubleArrayMap<RegistryKey<Biome>> favoriteBiomes;
                    if (seasonContext.getCropFavoriteBiomeBonuses().containsKey(block) && !(favoriteBiomes = seasonContext.getCropFavoriteBiomeBonuses().get(block)).isEmpty()) {
                        StringTextComponent favBiomes = new StringTextComponent(Arrays.toString(favoriteBiomes.keySet().stream().map(RegistryKey::func_240901_a_).map(location -> new TranslationTextComponent(Util.func_200697_a((String)"biome", (ResourceLocation)location)).getString()).toArray()));
                        toolTips.add(new TranslationTextComponent("bwseason.cropfertility.tooltip.favoritebiomes", new Object[]{favBiomes.func_240699_a_(TextFormatting.AQUA)}));
                    }
                    toolTips.add(new TranslationTextComponent("bwseason.cropfertility.tooltip.season", new Object[]{MixinItemStack.getFertilityString(currentSeasonBiomeCropGrowthMultiplier)}));
                } else {
                    toolTips.add(new TranslationTextComponent("bwseason.cropfertility.tooltip.hint.favbiomes", new Object[]{new TranslationTextComponent(mc.field_71474_y.field_228046_af_.func_197982_m())}).func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC}));
                }
                if (InputMappings.func_216506_a((long)mc.func_228018_at_().func_198092_i(), (int)mc.field_71474_y.field_151444_V.getKey().func_197937_c())) {
                    IFormattableTextComponent favoriteSeason = null;
                    IFormattableTextComponent favoritePhase = null;
                    double bestMultiplier = Double.MIN_VALUE;
                    ArrayList<TranslationTextComponent> seasonFertilityTips = new ArrayList<TranslationTextComponent>();
                    for (Season.Key key : Season.Key.values()) {
                        TranslationTextComponent keyTranslationTextComponent = key.translationTextComponent();
                        for (Season.Phase phase : Season.Phase.values()) {
                            TranslationTextComponent phaseTranslationTextComponent = phase.translationTextComponent();
                            BWSeason currentSeason = seasonContext.getSeasons().get((Object)key);
                            BWSubseasonSettings bwSubseasonSettings = currentSeason.getPhaseSettings().get((Object)phase);
                            double cropGrowthMultiplier = bwSubseasonSettings.getCropGrowthMultiplier(null, block);
                            if (cropGrowthMultiplier > bestMultiplier) {
                                bestMultiplier = cropGrowthMultiplier;
                                favoriteSeason = new TranslationTextComponent(keyTranslationTextComponent.func_150268_i()).func_240699_a_(TextFormatting.GREEN);
                                favoritePhase = new TranslationTextComponent(phaseTranslationTextComponent.func_150268_i()).func_240699_a_(TextFormatting.GREEN);
                            }
                            seasonFertilityTips.add(new TranslationTextComponent("bwseason.cropfertility.tooltip.seasons", new Object[]{keyTranslationTextComponent.func_240699_a_(TextFormatting.AQUA), phaseTranslationTextComponent.func_240699_a_(TextFormatting.AQUA), MixinItemStack.getFertilityString(cropGrowthMultiplier)}));
                        }
                    }
                    if (favoriteSeason != null && favoritePhase != null) {
                        toolTips.add(new TranslationTextComponent("bwseason.cropfertility.tooltip.favoriteseason", new Object[]{favoriteSeason, favoritePhase}));
                    }
                    toolTips.addAll(seasonFertilityTips);
                } else {
                    toolTips.add(new TranslationTextComponent("bwseason.cropfertility.tooltip.hint.seasonfertilities", new Object[]{new TranslationTextComponent(mc.field_71474_y.field_151444_V.func_197982_m())}).func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC}));
                }
            }
        }
    }

    private static IFormattableTextComponent getFertilityString(double cropMultiplier) {
        if (cropMultiplier == 1.0) {
            return new TranslationTextComponent("bwseason.cropfertility.tooltip.fertility.normal");
        }
        if (cropMultiplier < 0.0) {
            return new TranslationTextComponent("bwseason.cropfertility.tooltip.fertility.impossible").func_240699_a_(TextFormatting.RED);
        }
        if (cropMultiplier > 2.0) {
            return new TranslationTextComponent("bwseason.cropfertility.tooltip.fertility.excellent").func_240699_a_(TextFormatting.GREEN);
        }
        if (cropMultiplier > 1.5) {
            return new TranslationTextComponent("bwseason.cropfertility.tooltip.fertility.verygood").func_240699_a_(TextFormatting.GREEN);
        }
        if (cropMultiplier > 1.0) {
            return new TranslationTextComponent("bwseason.cropfertility.tooltip.fertility.good").func_240699_a_(TextFormatting.GREEN);
        }
        if (cropMultiplier > 0.6666666666666666) {
            return new TranslationTextComponent("bwseason.cropfertility.tooltip.fertility.notgood").func_240699_a_(TextFormatting.YELLOW);
        }
        if (cropMultiplier > 0.3333333333333333) {
            return new TranslationTextComponent("bwseason.cropfertility.tooltip.fertility.bad").func_240699_a_(TextFormatting.RED);
        }
        return new TranslationTextComponent("bwseason.cropfertility.tooltip.fertility.undetermined").func_240699_a_(TextFormatting.RED);
    }
}

