/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.mixin.client;

import corgitaco.betterweather.api.client.ColorSettings;
import corgitaco.betterweather.api.client.graphics.Graphics;
import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.mixin.access.Vector3dAccess;
import corgitaco.betterweather.weather.BWWeatherEventContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public abstract class MixinWorldRenderer
implements Graphics {
    @Shadow
    private int field_72773_u;
    @Shadow
    @Final
    private Minecraft field_72777_q;
    @Shadow
    private ClientWorld field_72769_h;

    @Inject(at={@At(value="HEAD")}, method={"renderRainSnow(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, cancellable=true)
    private void renderWeather(LightTexture lightmapIn, float partialTicks, double x, double y, double z, CallbackInfo ci) {
        BWWeatherEventContext weatherEventContext = ((BetterWeatherWorldData)this.field_72769_h).getWeatherEventContext();
        if (weatherEventContext != null) {
            if (weatherEventContext.getCurrentClientEvent().renderWeather((Graphics)((WorldRenderer)this), this.field_72777_q, this.field_72769_h, lightmapIn, this.field_72773_u, partialTicks, x, y, z, weatherEventContext.getCurrentEvent()::isValidBiome)) {
                ci.cancel();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addRainParticles(Lnet/minecraft/client/renderer/ActiveRenderInfo;)V"}, cancellable=true)
    private void stopRainParticles(ActiveRenderInfo activeRenderInfoIn, CallbackInfo ci) {
        BWWeatherEventContext weatherEventContext = ((BetterWeatherWorldData)this.field_72769_h).getWeatherEventContext();
        if (this.field_72777_q.field_71441_e != null && weatherEventContext != null) {
            if (weatherEventContext.getCurrentClientEvent().weatherParticlesAndSound(activeRenderInfoIn, this.field_72777_q, this.field_72773_u, weatherEventContext.getCurrentEvent()::isValidBiome)) {
                ci.cancel();
            }
        }
    }

    @Redirect(method={"renderSky(Lcom/mojang/blaze3d/matrix/MatrixStack;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainStrength(F)F"))
    public float sunRemoval(ClientWorld clientWorld, float delta) {
        float rainStrength = this.field_72769_h.func_72867_j(delta);
        BWWeatherEventContext weatherEventContext = ((BetterWeatherWorldData)this.field_72769_h).getWeatherEventContext();
        return weatherEventContext != null ? rainStrength * weatherEventContext.getCurrentClientEvent().skyOpacity(clientWorld, this.field_72777_q.field_71439_g.func_233580_cy_(), weatherEventContext.getCurrentEvent()::isValidBiome) : rainStrength;
    }

    @Inject(method={"drawClouds"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyCloudColor(BufferBuilder bufferIn, double cloudsX, double cloudsY, double cloudsZ, Vector3d cloudsColor, CallbackInfo ci) {
        BWWeatherEventContext weatherEventContext = ((BetterWeatherWorldData)this.field_72769_h).getWeatherEventContext();
        if (weatherEventContext != null) {
            ColorSettings colorSettings = weatherEventContext.getCurrentEvent().getClientSettings().getColorSettings();
            double cloudColorBlendStrength = colorSettings.getCloudColorBlendStrength();
            if (cloudColorBlendStrength <= 0.0) {
                return;
            }
            int targetCloudHexColor = colorSettings.getTargetCloudHexColor();
            float r = (float)(targetCloudHexColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(targetCloudHexColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(targetCloudHexColor & 0xFF) / 255.0f;
            float blendStrengthAtLocation = weatherEventContext.getCurrentClientEvent().cloudBlendStrength(this.field_72769_h, new BlockPos(cloudsX, cloudsY, cloudsZ), weatherEventContext.getCurrentEvent()::isValidBiome);
            float rainStrength = this.field_72769_h.func_72867_j(Minecraft.func_71410_x().func_184121_ak());
            float blend = (float)Math.min(cloudColorBlendStrength, (double)(rainStrength * blendStrengthAtLocation));
            ((Vector3dAccess)cloudsColor).setX(MathHelper.func_219803_d((double)blend, (double)cloudsColor.field_72450_a, (double)r));
            ((Vector3dAccess)cloudsColor).setY(MathHelper.func_219803_d((double)blend, (double)cloudsColor.field_72448_b, (double)g));
            ((Vector3dAccess)cloudsColor).setZ(MathHelper.func_219803_d((double)blend, (double)cloudsColor.field_72449_c, (double)b));
        }
    }
}

