/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.mixin.server.world;

import com.mojang.serialization.DynamicOps;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.Climate;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.api.weather.WeatherEvent;
import corgitaco.betterweather.config.BetterWeatherConfig;
import corgitaco.betterweather.data.storage.SeasonSavedData;
import corgitaco.betterweather.data.storage.WeatherEventSavedData;
import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.helpers.BiomeModifier;
import corgitaco.betterweather.helpers.BiomeUpdate;
import corgitaco.betterweather.mixin.access.ChunkManagerAccess;
import corgitaco.betterweather.mixin.access.ServerChunkProviderAccess;
import corgitaco.betterweather.mixin.access.ServerWorldAccess;
import corgitaco.betterweather.season.SeasonContext;
import corgitaco.betterweather.util.WorldDynamicRegistry;
import corgitaco.betterweather.weather.BWWeatherEventContext;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerWorld.class})
public abstract class MixinServerWorld
implements BiomeUpdate,
BetterWeatherWorldData,
Climate {
    @Shadow
    @Final
    private ServerChunkProvider field_241102_C_;
    private DynamicRegistries registry;
    @Nullable
    private SeasonContext seasonContext;
    @Nullable
    private BWWeatherEventContext weatherContext;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void storeUpgradablePerWorldRegistry(MinecraftServer server, Executor executor, SaveFormat.LevelSave save, IServerWorldInfo worldInfo, RegistryKey<World> key, DimensionType dimensionType, IChunkStatusListener statusListener, ChunkGenerator generator, boolean b, long seed, List<ISpecialSpawner> specialSpawners, boolean b1, CallbackInfo ci) {
        ResourceLocation worldKeyLocation = key.func_240901_a_();
        boolean hasPerWorldRegistry = Stream.concat(BetterWeatherConfig.WEATHER_EVENT_DIMENSIONS.stream(), BetterWeatherConfig.SEASON_DIMENSIONS.stream()).collect(Collectors.toSet()).size() > 1;
        boolean isValidWeatherEventDimension = BetterWeatherConfig.WEATHER_EVENT_DIMENSIONS.contains(worldKeyLocation.toString());
        boolean isValidSeasonDimension = BetterWeatherConfig.SEASON_DIMENSIONS.contains(worldKeyLocation.toString());
        if (hasPerWorldRegistry && (isValidWeatherEventDimension || isValidSeasonDimension)) {
            this.registry = new WorldDynamicRegistry((DynamicRegistries.Impl)server.func_244267_aX());
            BetterWeather.LOGGER.warn("Swapping server world gen datapack registry for \"" + key.func_240901_a_().toString() + "\" to a per world registry... This may have unintended side effects like mod incompatibilities in this world...");
            WorldSettingsImport worldSettingsImport = WorldSettingsImport.func_244335_a((DynamicOps)NBTDynamicOps.field_210820_a, (IResourceManager)server.getDataPackRegistries().func_240970_h_(), (DynamicRegistries.Impl)((DynamicRegistries.Impl)this.registry));
            ChunkGenerator dimensionChunkGenerator = ((Dimension)save.func_237284_a_((DynamicOps)worldSettingsImport, server.func_240793_aU_().func_230403_C_()).func_230418_z_().func_236224_e_().func_241873_b(worldKeyLocation).get()).func_236064_c_();
            BetterWeather.LOGGER.warn("Swapping chunk generator for \"" + key.func_240901_a_().toString() + "\" to use the per world registry... This may have unintended side effects like mod incompatibilities in this world...");
            ((ServerChunkProviderAccess)this.field_241102_C_).setGenerator(dimensionChunkGenerator);
            ((ChunkManagerAccess)this.field_241102_C_.field_217237_a).setGenerator(dimensionChunkGenerator);
            BetterWeather.LOGGER.info("Swapped the chunk generator for \"" + key.func_240901_a_().toString() + "\" to use the per world registry!");
            BetterWeather.LOGGER.info("Swapped world gen datapack registry for \"" + key.func_240901_a_().toString() + "\" to the per world registry!");
        } else {
            this.registry = server.func_244267_aX();
        }
        if (isValidWeatherEventDimension) {
            this.weatherContext = new BWWeatherEventContext(WeatherEventSavedData.get((IWorld)((ServerWorld)this)), key, (Registry<Biome>)this.registry.func_243612_b(Registry.field_239720_u_));
        }
        if (isValidSeasonDimension) {
            this.seasonContext = new SeasonContext(SeasonSavedData.get((IWorld)((ServerWorld)this)), key, (Registry<Biome>)this.registry.func_243612_b(Registry.field_239720_u_));
        }
        this.updateBiomeData();
    }

    @Override
    public void updateBiomeData() {
        List validBiomes = this.field_241102_C_.func_201711_g().func_202090_b().func_235203_c_();
        for (Map.Entry entry : this.registry.func_243612_b(Registry.field_239720_u_).func_239659_c_()) {
            Biome biome = (Biome)entry.getValue();
            RegistryKey biomeKey = (RegistryKey)entry.getKey();
            if (this.seasonContext != null && validBiomes.contains(biome)) {
                float seasonHumidityModifier = (float)this.seasonContext.getCurrentSubSeasonSettings().getHumidityModifier((RegistryKey<Biome>)biomeKey);
                float seasonTemperatureModifier = (float)this.seasonContext.getCurrentSubSeasonSettings().getTemperatureModifier((RegistryKey<Biome>)biomeKey);
                ((BiomeModifier)biome).setSeasonTempModifier(seasonTemperatureModifier);
                ((BiomeModifier)biome).setSeasonHumidityModifier(seasonHumidityModifier);
            }
            if (this.weatherContext == null || !validBiomes.contains(biome) || !this.weatherContext.getCurrentEvent().isValidBiome(biome)) continue;
            float weatherHumidityModifier = (float)this.weatherContext.getCurrentEvent().getHumidityModifierAtPosition(null);
            float weatherTemperatureModifier = (float)this.weatherContext.getCurrentWeatherEventSettings().getTemperatureModifierAtPosition(null);
            ((BiomeModifier)biome).setWeatherTempModifier(weatherTemperatureModifier);
            ((BiomeModifier)biome).setWeatherHumidityModifier(weatherHumidityModifier);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/DimensionType;hasSkyLight()Z")})
    private void tick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        if (this.seasonContext != null) {
            this.seasonContext.tick((World)((ServerWorld)this));
        }
        if (this.weatherContext != null) {
            this.weatherContext.tick((World)((ServerWorld)this));
        }
    }

    @Inject(method={"func_241828_r"}, at={@At(value="HEAD")}, cancellable=true)
    private void dynamicRegistryWrapper(CallbackInfoReturnable<DynamicRegistries> cir) {
        cir.setReturnValue((Object)this.registry);
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=168000), @Constant(intValue=12000, ordinal=1), @Constant(intValue=12000, ordinal=4)})
    private int modifyWeatherTime(int arg0) {
        SeasonContext seasonContext = this.seasonContext;
        return seasonContext != null ? (int)((double)arg0 * (1.0 / seasonContext.getCurrentSeason().getCurrentSettings().getWeatherEventChanceMultiplier())) : arg0;
    }

    @Inject(method={"setWeather"}, at={@At(value="HEAD")})
    private void setWeatherForced(int clearWeatherTime, int weatherTime, boolean rain, boolean thunder, CallbackInfo ci) {
        if (this.weatherContext != null) {
            this.weatherContext.setWeatherForced(true);
        }
    }

    @Inject(method={"tickEnvironment"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickLiveChunks(Chunk chunkIn, int randomTickSpeed, CallbackInfo ci) {
        if (this.weatherContext != null) {
            this.weatherContext.getCurrentEvent().doChunkTick(chunkIn, (ServerWorld)this);
            this.doLightning((ServerWorld)this, chunkIn.func_76632_l());
        }
    }

    private void doLightning(ServerWorld world, ChunkPos chunkpos) {
        BlockPos blockpos;
        Biome biome;
        if (this.weatherContext == null) {
            return;
        }
        int xStart = chunkpos.func_180334_c();
        int zStart = chunkpos.func_180333_d();
        WeatherEvent currentEvent = this.weatherContext.getCurrentEvent();
        if (currentEvent.isThundering() && world.field_73012_v.nextInt(currentEvent.getLightningChance()) == 0 && currentEvent.isValidBiome(biome = world.func_226691_t_(blockpos = ((ServerWorldAccess)world).invokeAdjustPosToNearbyEntity(world.func_217383_a(xStart, 0, zStart, 15))))) {
            boolean flag1;
            DifficultyInstance difficultyinstance = world.func_175649_E(blockpos);
            boolean bl = flag1 = world.func_82736_K().func_223586_b(GameRules.field_223601_d) && world.field_73012_v.nextDouble() < (double)difficultyinstance.func_180168_b() * 0.01;
            if (flag1) {
                SkeletonHorseEntity skeletonhorseentity = (SkeletonHorseEntity)EntityType.field_200742_ah.func_200721_a((World)world);
                skeletonhorseentity.func_190691_p(true);
                skeletonhorseentity.func_70873_a(0);
                skeletonhorseentity.func_70107_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
                world.func_217376_c((Entity)skeletonhorseentity);
            }
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)world);
            lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)blockpos));
            lightningboltentity.func_233623_a_(flag1);
            world.func_217376_c((Entity)lightningboltentity);
        }
    }

    @Redirect(method={"tickEnvironment"}, at=@At(value="INVOKE", target="Ljava/util/Random;nextInt(I)I", ordinal=0))
    private int neverSpawnLightning(Random random, int bound) {
        return this.weatherContext != null ? -1 : random.nextInt(bound);
    }

    @Redirect(method={"tickEnvironment"}, at=@At(value="INVOKE", target="Ljava/util/Random;nextInt(I)I", ordinal=1))
    private int takeAdvantageOfExistingChunkIterator(Random random, int bound, Chunk chunk, int randomTickSpeed) {
        return this.weatherContext != null ? -1 : ((ServerWorld)this).field_73012_v.nextInt(bound);
    }

    @Override
    @Nullable
    public SeasonContext getSeasonContext() {
        return this.seasonContext;
    }

    @Override
    @Nullable
    public SeasonContext setSeasonContext(SeasonContext seasonContext) {
        this.seasonContext = seasonContext;
        return this.seasonContext;
    }

    @Override
    @Nullable
    public BWWeatherEventContext getWeatherEventContext() {
        return this.weatherContext;
    }

    @Override
    @Nullable
    public BWWeatherEventContext setWeatherEventContext(BWWeatherEventContext weatherEventContext) {
        this.weatherContext = weatherEventContext;
        return this.weatherContext;
    }

    @Override
    @Nullable
    public Season getSeason() {
        return this.seasonContext;
    }
}

