/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.season;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.season.BWSubseasonSettings;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;

public final class BWSeason {
    public static final Map<String, ITag.INamedTag<Block>> AFFECTED_CROPS = new HashMap<String, ITag.INamedTag<Block>>();
    public static final Map<String, ITag.INamedTag<Block>> UNAFFECTED_CROPS = new HashMap<String, ITag.INamedTag<Block>>();
    public static final IdentityHashMap<Season.Phase, BWSubseasonSettings> DEFAULT_SPRING_PHASES = (IdentityHashMap)Util.func_200696_a(new IdentityHashMap(), map -> {
        map.put(Season.Phase.START, BWSubseasonSettings.DEFAULT_SPRING_START);
        map.put(Season.Phase.MID, BWSubseasonSettings.DEFAULT_SPRING_MID);
        map.put(Season.Phase.END, BWSubseasonSettings.DEFAULT_SPRING_END);
    });
    public static final IdentityHashMap<Season.Phase, BWSubseasonSettings> DEFAULT_SUMMER_PHASES = (IdentityHashMap)Util.func_200696_a(new IdentityHashMap(), map -> {
        map.put(Season.Phase.START, BWSubseasonSettings.DEFAULT_SUMMER_START);
        map.put(Season.Phase.MID, BWSubseasonSettings.DEFAULT_SUMMER_MID);
        map.put(Season.Phase.END, BWSubseasonSettings.DEFAULT_SUMMER_END);
    });
    public static final IdentityHashMap<Season.Phase, BWSubseasonSettings> DEFAULT_AUTUMN_PHASES = (IdentityHashMap)Util.func_200696_a(new IdentityHashMap(), map -> {
        map.put(Season.Phase.START, BWSubseasonSettings.DEFAULT_AUTUMN_START);
        map.put(Season.Phase.MID, BWSubseasonSettings.DEFAULT_AUTUMN_MID);
        map.put(Season.Phase.END, BWSubseasonSettings.DEFAULT_AUTUMN_END);
    });
    public static final IdentityHashMap<Season.Phase, BWSubseasonSettings> DEFAULT_WINTER_PHASES = (IdentityHashMap)Util.func_200696_a(new IdentityHashMap(), map -> {
        map.put(Season.Phase.START, BWSubseasonSettings.DEFAULT_WINTER_START);
        map.put(Season.Phase.MID, BWSubseasonSettings.DEFAULT_WINTER_MID);
        map.put(Season.Phase.END, BWSubseasonSettings.DEFAULT_WINTER_END);
    });
    public static final BWSeason DEFAULT_SPRING = new BWSeason(DEFAULT_SPRING_PHASES);
    public static final BWSeason DEFAULT_SUMMER = new BWSeason(DEFAULT_SUMMER_PHASES);
    public static final BWSeason DEFAULT_AUTUMN = new BWSeason(DEFAULT_AUTUMN_PHASES);
    public static final BWSeason DEFAULT_WINTER = new BWSeason(DEFAULT_WINTER_PHASES);
    public static final Codec<BWSeason> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.simpleMap(Season.Phase.CODEC, BWSubseasonSettings.CODEC, (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])Season.Phase.values())).fieldOf("phases").forGetter(seasons -> seasons.phaseSettings)).apply((Applicative)builder, p1 -> new BWSeason(new IdentityHashMap<Season.Phase, BWSubseasonSettings>((Map<Season.Phase, BWSubseasonSettings>)p1))));
    public static final Codec<BWSeason> PACKET_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.simpleMap(Season.Phase.CODEC, BWSubseasonSettings.PACKET_CODEC, (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])Season.Phase.values())).fieldOf("phases").forGetter(seasons -> seasons.phaseSettings)).apply((Applicative)builder, p1 -> new BWSeason(new IdentityHashMap<Season.Phase, BWSubseasonSettings>((Map<Season.Phase, BWSubseasonSettings>)p1))));
    private Season.Key key;
    private Season.Phase currentPhase;
    private final IdentityHashMap<Season.Phase, BWSubseasonSettings> phaseSettings;

    public BWSeason(IdentityHashMap<Season.Phase, BWSubseasonSettings> phaseSettings) {
        this.phaseSettings = phaseSettings;
    }

    public Season.Key getSeasonKey() {
        return this.key;
    }

    public void setSeasonKey(Season.Key key) {
        this.key = key;
    }

    public BWSubseasonSettings getCurrentSettings() {
        return this.phaseSettings.get((Object)this.currentPhase);
    }

    public Season.Phase getCurrentPhase() {
        return this.currentPhase;
    }

    public BWSubseasonSettings getSettingsForPhase(Season.Phase phase) {
        return this.phaseSettings.get((Object)phase);
    }

    public IdentityHashMap<Season.Phase, BWSubseasonSettings> getPhaseSettings() {
        return this.phaseSettings;
    }

    public void tick(int currentYearTime, int yearLength) {
    }

    public BWSeason setPhaseForTime(int currentYearTime, int yearLength) {
        int seasonLength;
        int phaseLength;
        int seasonTimeOffset = Season.getSeasonStartTime(this.key, yearLength);
        int seasonLocalTime = currentYearTime - seasonTimeOffset;
        this.currentPhase = seasonLocalTime < (phaseLength = Season.getPhaseLength(seasonLength = yearLength / Season.Key.values().length)) ? Season.Phase.START : (seasonLocalTime < phaseLength * 2 ? Season.Phase.MID : Season.Phase.END);
        return this;
    }
}

