/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.season;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.api.client.ColorSettings;
import corgitaco.betterweather.api.season.SubseasonSettings;
import corgitaco.betterweather.mixin.access.BlockTagsAccess;
import corgitaco.betterweather.season.storage.OverrideStorage;
import corgitaco.betterweather.util.BetterWeatherUtil;
import corgitaco.betterweather.util.client.ColorUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class BWSubseasonSettings
implements SubseasonSettings {
    public static final boolean MODIFY_TEMPERATURE = false;
    public static final Codec<BWSubseasonSettings> CODEC = RecordCodecBuilder.create(subSeasonSettingsInstance -> subSeasonSettingsInstance.group((App)Codec.DOUBLE.fieldOf("tempModifier").orElse((Object)0.0).forGetter(subSeasonSettings -> subSeasonSettings.tempModifier), (App)Codec.DOUBLE.optionalFieldOf("humidityModifier", (Object)0.0).forGetter(subSeasonSettings -> subSeasonSettings.humidityModifier), (App)Codec.DOUBLE.optionalFieldOf("weatherEventChanceMultiplier", (Object)0.0).forGetter(subSeasonSettings -> subSeasonSettings.weatherEventChanceMultiplier), (App)Codec.DOUBLE.optionalFieldOf("cropGrowthChanceMultiplier", (Object)0.0).forGetter(subSeasonSettings -> subSeasonSettings.cropGrowthChanceMultiplier), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).fieldOf("weatherEventController").forGetter(subSeasonSettings -> subSeasonSettings.weatherEventController), (App)ColorSettings.CODEC.fieldOf("client").forGetter(subSeasonSettings -> subSeasonSettings.clientSettings), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("entityBreedingBlacklist", new ArrayList()).forGetter(subSeasonSettings -> !subSeasonSettings.entityTypeBreedingBlacklist.isEmpty() ? subSeasonSettings.entityTypeBreedingBlacklist.stream().map(arg_0 -> ((DefaultedRegistry)Registry.field_212629_r).func_177774_c(arg_0)).map(ResourceLocation::toString).collect(Collectors.toList()) : Arrays.asList(new ResourceLocation("modid", "dummymob").toString(), new ResourceLocation("modid", "dummymob2").toString()))).apply((Applicative)subSeasonSettingsInstance, BWSubseasonSettings::new));
    public static final Codec<BWSubseasonSettings> PACKET_CODEC = RecordCodecBuilder.create(subSeasonSettingsInstance -> subSeasonSettingsInstance.group((App)Codec.DOUBLE.optionalFieldOf("tempModifier", (Object)0.0).forGetter(subSeasonSettings -> subSeasonSettings.tempModifier), (App)Codec.DOUBLE.optionalFieldOf("humidityModifier", (Object)0.0).forGetter(subSeasonSettings -> subSeasonSettings.humidityModifier), (App)Codec.DOUBLE.optionalFieldOf("weatherEventChanceMultiplier", (Object)0.0).forGetter(subSeasonSettings -> subSeasonSettings.weatherEventChanceMultiplier), (App)Codec.DOUBLE.optionalFieldOf("cropGrowthChanceMultiplier", (Object)0.0).forGetter(subSeasonSettings -> subSeasonSettings.cropGrowthChanceMultiplier), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).fieldOf("weatherEventController").forGetter(subSeasonSettings -> subSeasonSettings.weatherEventController), (App)ColorSettings.CODEC.fieldOf("client").forGetter(subSeasonSettings -> subSeasonSettings.clientSettings), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("entityBreedingBlacklist", new ArrayList()).forGetter(subSeasonSettings -> subSeasonSettings.entityTypeBreedingBlacklist.stream().map(arg_0 -> ((DefaultedRegistry)Registry.field_212629_r).func_177774_c(arg_0)).map(ResourceLocation::toString).collect(Collectors.toList())), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)Codec.DOUBLE).fieldOf("cropToMultiplierStorage").forGetter(subSeasonSettings -> {
        IdentityHashMap newMap = new IdentityHashMap();
        subSeasonSettings.cropToMultiplierStorage.forEach((block, multiplier) -> newMap.put(Registry.field_212618_g.func_177774_c(block), multiplier));
        return newMap;
    }), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, OverrideStorage.PACKET_CODEC).fieldOf("biomeToOverrideStorage").forGetter(subSeasonSettings -> {
        IdentityHashMap newMap = new IdentityHashMap();
        subSeasonSettings.biomeToOverrideStorage.forEach((biomeKey, overrideStorage) -> newMap.put(biomeKey.func_240901_a_(), overrideStorage));
        return newMap;
    }), (App)ResourceLocation.field_240908_a_.fieldOf("enhanced_crops").forGetter(settings -> settings.enhancedCropsTag.func_230234_a_()), (App)ResourceLocation.field_240908_a_.fieldOf("unenhanced_crops").forGetter(settings -> settings.unenhancedCropsTag.func_230234_a_())).apply((Applicative)subSeasonSettingsInstance, (tempModifier, humidityModifier, weatherEventMultiplier, cropGrowthChanceMultiplier, weatherEventController, clientSettings, entityTypeBreedingBlacklist, cropToMultiplierStorage, biomeToOverrideStorage, enhancedCrops, unenhancedCrops) -> {
        BWSubseasonSettings bwSubseasonSettings = new BWSubseasonSettings((double)tempModifier, (double)humidityModifier, (double)weatherEventMultiplier, (double)cropGrowthChanceMultiplier, (Map<String, Double>)weatherEventController, (ColorSettings)clientSettings, (List<String>)entityTypeBreedingBlacklist, (Map<Block, Double>)BetterWeatherUtil.transformBlockResourceLocations(cropToMultiplierStorage), (Map<RegistryKey<Biome>, OverrideStorage>)BetterWeatherUtil.transformBiomeResourceLocationsToKeys(biomeToOverrideStorage));
        for (ITag.INamedTag tag : BlockTagsAccess.getREGISTRY().func_241288_c_()) {
            if (bwSubseasonSettings.getEnhancedCropsTag() != null && bwSubseasonSettings.getUnenhancedCropsTag() != null) break;
            if (tag.func_230234_a_().equals(enhancedCrops)) {
                bwSubseasonSettings.setEnhancedCropsTag((ITag.INamedTag<Block>)tag);
            }
            if (!tag.func_230234_a_().equals(unenhancedCrops)) continue;
            bwSubseasonSettings.setUnEnhancedCropsTag((ITag.INamedTag<Block>)tag);
        }
        return bwSubseasonSettings;
    }));
    public static final String RAIN = "RAIN";
    public static final String THUNDER = "THUNDER";
    public static final HashMap<String, Double> SPRING_START_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> SPRING_MID_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> SPRING_END_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> SUMMER_START_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> SUMMER_MID_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> SUMMER_END_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> AUTUMN_START_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> AUTUMN_MID_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> AUTUMN_END_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> WINTER_START_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> WINTER_MID_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final HashMap<String, Double> WINTER_END_WEATHER_EVENT_CONTROLLER = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put(RAIN, 1.0);
        map.put(THUNDER, 0.75);
    });
    public static final BWSubseasonSettings DEFAULT_SPRING_START = new BWSubseasonSettings(0.0, 0.5, 1.5, 1.3, SPRING_START_WEATHER_EVENT_CONTROLLER, new ColorSettings(ColorUtil.pack(51, 97, 50), 0.5, ColorUtil.pack(51, 97, 50), 0.5));
    public static final BWSubseasonSettings DEFAULT_SPRING_MID = new BWSubseasonSettings(0.0, 0.5, 2.0, 2.0, SPRING_MID_WEATHER_EVENT_CONTROLLER, new ColorSettings(ColorUtil.pack(41, 87, 2), 0.5, ColorUtil.pack(41, 87, 2), 0.5));
    public static final BWSubseasonSettings DEFAULT_SPRING_END = new BWSubseasonSettings(0.0, 0.4, 1.5, 1.7, SPRING_END_WEATHER_EVENT_CONTROLLER, new ColorSettings(ColorUtil.pack(20, 87, 2), 0.5, ColorUtil.pack(20, 87, 2), 0.5));
    public static final BWSubseasonSettings DEFAULT_SUMMER_START = new BWSubseasonSettings(0.0, -0.1, 0.75, 1.15, SUMMER_START_WEATHER_EVENT_CONTROLLER, new ColorSettings());
    public static final BWSubseasonSettings DEFAULT_SUMMER_MID = new BWSubseasonSettings(0.0, -0.3, 0.2, 1.0, SUMMER_MID_WEATHER_EVENT_CONTROLLER, new ColorSettings());
    public static final BWSubseasonSettings DEFAULT_SUMMER_END = new BWSubseasonSettings(0.0, -0.1, 0.5, 1.0, SUMMER_END_WEATHER_EVENT_CONTROLLER, new ColorSettings());
    public static final BWSubseasonSettings DEFAULT_AUTUMN_START = new BWSubseasonSettings(0.0, 0.0, 0.7, 0.8, AUTUMN_START_WEATHER_EVENT_CONTROLLER, new ColorSettings(ColorUtil.pack(155, 103, 60), 0.5, ColorUtil.pack(155, 103, 60), 0.5));
    public static final BWSubseasonSettings DEFAULT_AUTUMN_MID = new BWSubseasonSettings(0.0, 0.0, 0.7, 0.75, AUTUMN_MID_WEATHER_EVENT_CONTROLLER, new ColorSettings(ColorUtil.pack(155, 103, 60), 0.5, ColorUtil.pack(155, 103, 60), 0.5));
    public static final BWSubseasonSettings DEFAULT_AUTUMN_END = new BWSubseasonSettings(0.0, 0.1, 0.75, 0.65, AUTUMN_END_WEATHER_EVENT_CONTROLLER, new ColorSettings(ColorUtil.pack(155, 103, 60), 0.5, ColorUtil.pack(155, 103, 60), 0.5));
    public static final BWSubseasonSettings DEFAULT_WINTER_START = new BWSubseasonSettings(0.0, 0.2, 1.0, 0.6, WINTER_START_WEATHER_EVENT_CONTROLLER, new ColorSettings(ColorUtil.pack(165, 42, 42), 0.5, ColorUtil.pack(165, 42, 42), 0.5));
    public static final BWSubseasonSettings DEFAULT_WINTER_MID = new BWSubseasonSettings(0.0, 0.2, 1.0, 0.5, WINTER_MID_WEATHER_EVENT_CONTROLLER, new ColorSettings(ColorUtil.pack(165, 42, 42), 0.5, ColorUtil.pack(165, 42, 42), 0.5));
    public static final BWSubseasonSettings DEFAULT_WINTER_END = new BWSubseasonSettings(0.0, 0.2, 1.25, 0.75, WINTER_END_WEATHER_EVENT_CONTROLLER, new ColorSettings(ColorUtil.pack(165, 42, 42), 0.5, ColorUtil.pack(165, 42, 42), 0.5));
    public static final IdentityHashMap<Object, OverrideStorage> WINTER_OVERRIDE = (IdentityHashMap)Util.func_200696_a(new IdentityHashMap(), map -> {
        OverrideStorage overrideStorage = new OverrideStorage();
        overrideStorage.getClientStorage().setTargetFoliageHexColor("#964B00").setTargetGrassHexColor("#964B00");
        map.put(Biome.Category.SWAMP, overrideStorage);
    });
    private final double tempModifier;
    private final double humidityModifier;
    private final double weatherEventChanceMultiplier;
    private final double cropGrowthChanceMultiplier;
    private final HashMap<String, Double> weatherEventController;
    private final IdentityHashMap<Block, Double> cropToMultiplierStorage;
    private final IdentityHashMap<RegistryKey<Biome>, OverrideStorage> biomeToOverrideStorage;
    private final ObjectOpenHashSet<EntityType<?>> entityTypeBreedingBlacklist;
    private final ObjectOpenHashSet<Block> enhancedCrops = new ObjectOpenHashSet();
    private ColorSettings clientSettings;
    private ITag.INamedTag<Block> enhancedCropsTag;
    private ITag.INamedTag<Block> unenhancedCropsTag;

    public BWSubseasonSettings(double tempModifier, double humidityModifier, double weatherEventChanceMultiplier, double cropGrowthChanceMultiplier, Map<String, Double> weatherEventController, ColorSettings clientSettings) {
        this(tempModifier, humidityModifier, weatherEventChanceMultiplier, cropGrowthChanceMultiplier, weatherEventController, clientSettings, (Set<String>)new ObjectOpenHashSet(), new IdentityHashMap<Block, Double>(), new IdentityHashMap<RegistryKey<Biome>, OverrideStorage>());
    }

    public BWSubseasonSettings(double tempModifier, double humidityModifier, double weatherEventChanceMultiplier, double cropGrowthChanceMultiplier, Map<String, Double> weatherEventController, ColorSettings clientSettings, List<String> entityBreedingBlacklist) {
        this(tempModifier, humidityModifier, weatherEventChanceMultiplier, cropGrowthChanceMultiplier, weatherEventController, clientSettings, new HashSet<String>(entityBreedingBlacklist), new IdentityHashMap<Block, Double>(), new IdentityHashMap<RegistryKey<Biome>, OverrideStorage>());
    }

    public BWSubseasonSettings(double tempModifier, double humidityModifier, double weatherEventChanceMultiplier, double cropGrowthChanceMultiplier, Map<String, Double> weatherEventController, ColorSettings clientSettings, List<String> entityBreedingBlacklist, Map<Block, Double> cropToMultiplierStorage, Map<RegistryKey<Biome>, OverrideStorage> biomeToOverrideStorage) {
        this(tempModifier, humidityModifier, weatherEventChanceMultiplier, cropGrowthChanceMultiplier, weatherEventController, clientSettings, new HashSet<String>(entityBreedingBlacklist), new IdentityHashMap<Block, Double>(cropToMultiplierStorage), new IdentityHashMap<RegistryKey<Biome>, OverrideStorage>(biomeToOverrideStorage));
    }

    public BWSubseasonSettings(double tempModifier, double humidityModifier, double weatherEventChanceMultiplier, double cropGrowthChanceMultiplier, Map<String, Double> weatherEventController, ColorSettings clientSettings, Set<String> entityBreedingBlacklist, IdentityHashMap<Block, Double> cropToMultiplierStorage, IdentityHashMap<RegistryKey<Biome>, OverrideStorage> biomeToOverrideStorage) {
        this.tempModifier = tempModifier;
        this.humidityModifier = humidityModifier;
        this.weatherEventChanceMultiplier = weatherEventChanceMultiplier;
        this.cropGrowthChanceMultiplier = cropGrowthChanceMultiplier;
        this.weatherEventController = new HashMap<String, Double>(weatherEventController);
        this.clientSettings = clientSettings;
        this.entityTypeBreedingBlacklist = new ObjectOpenHashSet((Collection)entityBreedingBlacklist.stream().map(ResourceLocation::new).filter(resourceLocation -> BetterWeatherUtil.filterRegistryID(resourceLocation, Registry.field_212629_r, "Entity")).map(arg_0 -> ((DefaultedRegistry)Registry.field_212629_r).func_241873_b(arg_0)).map(Optional::get).collect(Collectors.toSet()));
        this.cropToMultiplierStorage = cropToMultiplierStorage;
        this.biomeToOverrideStorage = biomeToOverrideStorage;
    }

    public void setClient(ColorSettings clientSettings) {
        this.clientSettings = clientSettings;
    }

    public void setEnhancedCropsTag(ITag.INamedTag<Block> enhancedCrops) {
        this.enhancedCropsTag = enhancedCrops;
        this.enhancedCrops.addAll((Collection)enhancedCrops.func_230236_b_());
    }

    public void setUnEnhancedCropsTag(ITag.INamedTag<Block> unenhancedCropsTag) {
        this.unenhancedCropsTag = unenhancedCropsTag;
        this.enhancedCrops.removeAll((Collection)unenhancedCropsTag.func_230236_b_());
    }

    public void setCropTags(ITag.INamedTag<Block> enhancedCrops, ITag.INamedTag<Block> unenhancedCrops) {
        this.setEnhancedCropsTag(enhancedCrops);
        this.setUnEnhancedCropsTag(unenhancedCrops);
    }

    public IdentityHashMap<Block, Double> getCropToMultiplierStorage() {
        return this.cropToMultiplierStorage;
    }

    public void setCropToMultiplierStorage(IdentityHashMap<Block, Double> cropToMultiplierStorage) {
        this.cropToMultiplierStorage.putAll(cropToMultiplierStorage);
    }

    public IdentityHashMap<RegistryKey<Biome>, OverrideStorage> getBiomeToOverrideStorage() {
        return this.biomeToOverrideStorage;
    }

    public void setBiomeToOverrideStorage(IdentityHashMap<RegistryKey<Biome>, OverrideStorage> biomeToOverrideStorage) {
        this.biomeToOverrideStorage.putAll(biomeToOverrideStorage);
    }

    @Override
    public double getTemperatureModifier(RegistryKey<Biome> biomeKey) {
        double defaultValue = this.tempModifier;
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        double tempModifier = this.getBiomeToOverrideStorage().get(biomeKey).getTempModifier();
        return tempModifier == Double.MAX_VALUE ? defaultValue : tempModifier;
    }

    @Override
    public double getHumidityModifier(RegistryKey<Biome> biomeKey) {
        double defaultValue = this.humidityModifier;
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        double humidityModifier = this.getBiomeToOverrideStorage().get(biomeKey).getHumidityModifier();
        return humidityModifier == Double.MAX_VALUE ? defaultValue : humidityModifier;
    }

    public double getWeatherEventChanceMultiplier() {
        return this.weatherEventChanceMultiplier;
    }

    @Override
    public double getCropGrowthMultiplier(@Nullable RegistryKey<Biome> biomeKey, @Nullable Block block) {
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return this.getCropToMultiplierStorage().getOrDefault(block, this.cropGrowthChanceMultiplier);
        }
        OverrideStorage overrideStorage = this.getBiomeToOverrideStorage().get(biomeKey);
        double fallBack = overrideStorage.getFallBack();
        return overrideStorage.getBlockToCropGrowthMultiplierMap().getOrDefault(block, fallBack == Double.MAX_VALUE ? this.cropGrowthChanceMultiplier : fallBack);
    }

    public HashMap<String, Double> getWeatherEventController() {
        return this.weatherEventController;
    }

    public ColorSettings getClientSettings() {
        return this.clientSettings;
    }

    public int getTargetFoliageColor(RegistryKey<Biome> biomeKey) {
        int defaultValue = this.clientSettings.getTargetFoliageHexColor();
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        int overrideTargetFoliageColor = this.getBiomeToOverrideStorage().get(biomeKey).getClientStorage().getParsedFoliageHexColor();
        return overrideTargetFoliageColor == Integer.MAX_VALUE ? defaultValue : overrideTargetFoliageColor;
    }

    public double getFoliageColorBlendStrength(RegistryKey<Biome> biomeKey) {
        double defaultValue = this.clientSettings.getFoliageColorBlendStrength();
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        double overrideTargetFoliageBlendStrength = this.getBiomeToOverrideStorage().get(biomeKey).getClientStorage().getFoliageColorBlendStrength();
        return overrideTargetFoliageBlendStrength == Double.MAX_VALUE ? defaultValue : overrideTargetFoliageBlendStrength;
    }

    public int getTargetGrassColor(RegistryKey<Biome> biomeKey) {
        int defaultValue = this.clientSettings.getTargetGrassHexColor();
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        int overrideTargetGrassColor = this.getBiomeToOverrideStorage().get(biomeKey).getClientStorage().getParsedGrassHexColor();
        return overrideTargetGrassColor == Integer.MAX_VALUE ? defaultValue : overrideTargetGrassColor;
    }

    public double getGrassColorBlendStrength(RegistryKey<Biome> biomeKey) {
        double defaultValue = this.clientSettings.getGrassColorBlendStrength();
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        double overrideTargetGrassBlendStrength = this.getBiomeToOverrideStorage().get(biomeKey).getClientStorage().getGrassColorBlendStrength();
        return overrideTargetGrassBlendStrength == Double.MAX_VALUE ? defaultValue : overrideTargetGrassBlendStrength;
    }

    public int getTargetSkyColor(RegistryKey<Biome> biomeKey) {
        int defaultValue = this.clientSettings.getTargetSkyHexColor();
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        int overrideTargetSkyColor = this.getBiomeToOverrideStorage().get(biomeKey).getClientStorage().getParsedSkyHexColor();
        return overrideTargetSkyColor == Integer.MAX_VALUE ? defaultValue : overrideTargetSkyColor;
    }

    public double getSkyColorBlendStrength(RegistryKey<Biome> biomeKey) {
        double defaultValue = this.clientSettings.getSkyColorBlendStrength();
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        double overrideTargetGrassBlendStrength = this.getBiomeToOverrideStorage().get(biomeKey).getClientStorage().getSkyColorBlendStrength();
        return overrideTargetGrassBlendStrength == Double.MAX_VALUE ? defaultValue : overrideTargetGrassBlendStrength;
    }

    public int getTargetFogColor(RegistryKey<Biome> biomeKey) {
        int defaultValue = this.clientSettings.getTargetFogHexColor();
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        int overrideTargetFogColor = this.getBiomeToOverrideStorage().get(biomeKey).getClientStorage().getParsedFogHexColor();
        return overrideTargetFogColor == Integer.MAX_VALUE ? defaultValue : overrideTargetFogColor;
    }

    public double getFogColorBlendStrength(RegistryKey<Biome> biomeKey) {
        double defaultValue = this.clientSettings.getFogColorBlendStrength();
        if (!this.getBiomeToOverrideStorage().containsKey(biomeKey)) {
            return defaultValue;
        }
        double overrideFogColorBlendStrangth = this.getBiomeToOverrideStorage().get(biomeKey).getClientStorage().getFogColorBlendStrength();
        return overrideFogColorBlendStrangth == Double.MAX_VALUE ? defaultValue : overrideFogColorBlendStrangth;
    }

    public ObjectOpenHashSet<EntityType<?>> getEntityTypeBreedingBlacklist() {
        return this.entityTypeBreedingBlacklist;
    }

    public ObjectOpenHashSet<Block> getEnhancedCrops() {
        return this.enhancedCrops;
    }

    public ITag.INamedTag<Block> getEnhancedCropsTag() {
        return this.enhancedCropsTag;
    }

    public ITag.INamedTag<Block> getUnenhancedCropsTag() {
        return this.unenhancedCropsTag;
    }
}

