/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.season;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.api.season.SubseasonSettings;
import corgitaco.betterweather.data.network.NetworkHandler;
import corgitaco.betterweather.data.network.packet.season.SeasonTimePacket;
import corgitaco.betterweather.data.network.packet.util.RefreshRenderersPacket;
import corgitaco.betterweather.data.storage.SeasonSavedData;
import corgitaco.betterweather.helpers.BiomeUpdate;
import corgitaco.betterweather.season.BWSeason;
import corgitaco.betterweather.season.BWSubseasonSettings;
import corgitaco.betterweather.season.config.SeasonConfigHolder;
import corgitaco.betterweather.season.config.cropfavoritebiomes.CropFavoriteBiomesConfigHandler;
import corgitaco.betterweather.season.config.overrides.BiomeOverrideJsonHandler;
import corgitaco.betterweather.season.storage.OverrideStorage;
import corgitaco.betterweather.server.BetterWeatherGameRules;
import corgitaco.betterweather.util.BetterWeatherUtil;
import corgitaco.betterweather.util.TomlCommentedConfigOps;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.common.Tags;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class SeasonContext
implements Season {
    public static final String CONFIG_NAME = "season-settings.toml";
    public static final ITag.INamedTag<Block> GLOBAL_AFFECTED_CROPS = BlockTags.createOptional((ResourceLocation)new ResourceLocation("betterweather", "global.affected_crops"));
    public static final Codec<SeasonContext> PACKET_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("currentYearTime").forGetter(seasonContext -> seasonContext.currentYearTime), (App)Codec.INT.fieldOf("yearLength").forGetter(seasonContext -> seasonContext.yearLength), (App)ResourceLocation.field_240908_a_.fieldOf("worldID").forGetter(seasonContext -> seasonContext.worldID), (App)Codec.simpleMap(Season.Key.CODEC, BWSeason.PACKET_CODEC, (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])Season.Key.values())).fieldOf("seasons").forGetter(seasonContext -> seasonContext.seasons), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)Codec.DOUBLE)).fieldOf("cropFavoriteBiomes").forGetter(seasonContext -> {
        HashMap serialized = new HashMap();
        for (Map.Entry<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> blockToFavoriteBiome : seasonContext.cropToFavoriteBiomes.entrySet()) {
            HashMap<ResourceLocation, Double> favBiomeSerialized = new HashMap<ResourceLocation, Double>();
            for (Object2DoubleMap.Entry favBiomeToBonus : blockToFavoriteBiome.getValue().object2DoubleEntrySet()) {
                favBiomeSerialized.put(((RegistryKey)favBiomeToBonus.getKey()).func_240901_a_(), favBiomeToBonus.getDoubleValue());
            }
            serialized.put(Registry.field_212618_g.func_177774_c((Object)blockToFavoriteBiome.getKey()), favBiomeSerialized);
        }
        return serialized;
    })).apply((Applicative)builder, (currentYearTime, yearLength, worldID, seasonMap, cropFavoriteBiomesSerialized) -> {
        IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> cropFavoriteBiomes = new IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>>();
        for (Map.Entry serializedCropEntry : cropFavoriteBiomesSerialized.entrySet()) {
            Object2DoubleArrayMap favBiomes = new Object2DoubleArrayMap();
            for (Map.Entry value : ((Map)serializedCropEntry.getValue()).entrySet()) {
                favBiomes.put((Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)((ResourceLocation)value.getKey())), ((Double)value.getValue()).doubleValue());
            }
            Optional optional = Registry.field_212618_g.func_241873_b((ResourceLocation)serializedCropEntry.getKey());
            if (!optional.isPresent()) {
                throw new IllegalArgumentException("\"" + serializedCropEntry.getKey() + "\" is not a crop in the CLIENT registry! Failing packet serialization....");
            }
            cropFavoriteBiomes.put((Block)optional.get(), (Object2DoubleArrayMap<RegistryKey<Biome>>)favBiomes);
        }
        return new SeasonContext((int)currentYearTime, (int)yearLength, cropFavoriteBiomes, (ResourceLocation)worldID, new IdentityHashMap<Season.Key, BWSeason>((Map<Season.Key, BWSeason>)seasonMap));
    }));
    public static final IdentityHashMap<Block, Object2DoubleArrayMap<Object>> BLOCK_TO_FAVORITE_BIOMES_DEFAULT = (IdentityHashMap)Util.func_200696_a(new IdentityHashMap(), map -> {
        map.put(Blocks.field_150394_bc, Util.func_200696_a((Object)new Object2DoubleArrayMap(), favoriteBiomes -> favoriteBiomes.put((Object)Biome.Category.JUNGLE, 0.4)));
        map.put(Blocks.field_222434_lW, Util.func_200696_a((Object)new Object2DoubleArrayMap(), favoriteBiomes -> favoriteBiomes.put((Object)Biome.Category.TAIGA, 0.4)));
    });
    public static final TomlCommentedConfigOps CONFIG_OPS = new TomlCommentedConfigOps((Map)Util.func_200696_a(new HashMap(), map -> {
        map.put("yearLength", "Represents this world's year length in ticks(a minecraft day is 24000 ticks). Season length is 1/4 of this value. Sub season length is 1/12(or 1/3 of season length) of this value.");
        map.put("tickSeasonTimeWhenNoPlayersOnline", "Does Season Time tick in this world when no players are online?");
        map.put("tempModifier", "Modifies this world's temperature.");
        map.put("cropGrowthChanceMultiplier", "Multiplies the growth rate of crops when ticked.");
        map.put("entityBreedingBlacklist", "Blacklist specific mobs from breeding.");
        map.put("humidityModifier", "Modifies this world's humidity.");
        map.put("weatherEventChanceMultiplier", "Multiplies the chance of a weather event occurring.");
        map.put("fogColorBlendStrength", "The strength of this world's fog color blend towards the value of \"fogTargetHexColor\".\nRange: 0 - 1.0");
        map.put("fogTargetHexColor", "Blends the world's fog color towards this value. Blend strength is determined by the value of \"fogColorBlendStrength\".");
        map.put("foliageColorBlendStrength", "The strength of this world's sky color blend towards the value of \"foliageTargetHexColor\".\nRange: 0 - 1.0");
        map.put("foliageTargetHexColor", "Blends this world's foliage color towards this value. Blend strength is determined by the value of \"foliageColorBlendStrength\".");
        map.put("grassColorBlendStrength", "The strength of this world's grass color blend towards the value of \"grassTargetHexColor\".\nRange: 0 - 1.0");
        map.put("grassTargetHexColor", "Blends this world's grass color towards this value. Blend strength is determined by the value of \"grassColorBlendStrength\".");
        map.put("skyColorBlendStrength", "The strength of this world's sky color blend towards the value of \"skyTargetHexColor\".\nRange: 0 - 1.0");
        map.put("skyTargetHexColor", "Blends this world's grass color towards this value. Blend strength is determined by the value of \"skyColorBlendStrength\".");
        map.put("weatherEventController", "Represents the chance of the listed weather event.");
    }), true);
    private final ResourceLocation worldID;
    private final Registry<Biome> biomeRegistry;
    private final File seasonConfigFile;
    private final Path seasonsPath;
    private final Path seasonOverridesPath;
    private final IdentityHashMap<Season.Key, BWSeason> seasons = new IdentityHashMap();
    private final IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> cropToFavoriteBiomes;
    private boolean tickSeasonTimeWhenNoPlayersOnline = true;
    private BWSeason currentSeason;
    private int currentYearTime;
    private int yearLength;

    public SeasonContext(int currentYearTime, int yearLength, IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> cropToFavoriteBiomes, ResourceLocation worldID, IdentityHashMap<Season.Key, BWSeason> seasons) {
        this(currentYearTime, yearLength, worldID, cropToFavoriteBiomes, null, seasons);
    }

    public SeasonContext(SeasonSavedData seasonData, RegistryKey<World> worldID, Registry<Biome> biomeRegistry) {
        this(seasonData.getCurrentYearTime(), seasonData.getYearLength(), worldID.func_240901_a_(), new IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>>(), biomeRegistry, null);
        this.cropToFavoriteBiomes.putAll(CropFavoriteBiomesConfigHandler.handle(this.seasonsPath.resolve("crop-favorite-biomes.json"), BLOCK_TO_FAVORITE_BIOMES_DEFAULT, biomeRegistry));
    }

    public SeasonContext(int currentYearTime, int yearLength, ResourceLocation worldID, IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> cropToFavoriteBiomes, @Nullable Registry<Biome> biomeRegistry, @Nullable IdentityHashMap<Season.Key, BWSeason> seasons) {
        boolean isPacket;
        this.currentYearTime = currentYearTime;
        this.yearLength = yearLength;
        this.worldID = worldID;
        this.biomeRegistry = biomeRegistry;
        this.seasonsPath = BetterWeather.CONFIG_PATH.resolve(worldID.func_110624_b()).resolve(worldID.func_110623_a()).resolve("seasons");
        this.seasonConfigFile = this.seasonsPath.resolve(CONFIG_NAME).toFile();
        this.seasonOverridesPath = this.seasonsPath.resolve("overrides");
        this.cropToFavoriteBiomes = cropToFavoriteBiomes;
        boolean isClient = seasons != null;
        boolean bl = isPacket = biomeRegistry == null;
        if (isClient) {
            this.seasons.putAll(seasons);
        }
        if (!isPacket) {
            this.tickSeasonTimeWhenNoPlayersOnline = this.handleConfig(isClient).isTickSeasonTimeWhenNoPlayersOnline();
            this.currentSeason = this.seasons.get((Object)Season.getSeasonFromTime(this.currentYearTime, this.yearLength));
            this.currentSeason.setPhaseForTime(this.currentYearTime, this.yearLength);
        }
    }

    public void setSeason(ServerWorld world, List<ServerPlayerEntity> players, Season.Key newSeason, Season.Phase phase) {
        BWSubseasonSettings prevSettings = this.getCurrentSubSeasonSettings();
        this.currentYearTime = Season.getSeasonAndPhaseStartTime(newSeason, phase, this.yearLength);
        this.currentSeason = this.seasons.get((Object)newSeason);
        this.currentSeason.setPhaseForTime(this.currentYearTime, this.yearLength);
        BWSubseasonSettings currentSubSeasonSettings = this.getCurrentSubSeasonSettings();
        if (prevSettings != currentSubSeasonSettings) {
            this.onSeasonChange((World)world, prevSettings, currentSubSeasonSettings);
        }
    }

    public void tick(World world) {
        boolean changedPhaseFlag;
        BWSeason prevSeason = this.currentSeason;
        Season.Phase prevPhase = this.currentSeason.getCurrentPhase();
        BWSubseasonSettings prevSettings = prevSeason.getSettingsForPhase(prevPhase);
        this.tickSeasonTime(world);
        boolean changedSeasonFlag = prevSeason != this.currentSeason;
        boolean bl = changedPhaseFlag = prevPhase != this.currentSeason.getCurrentPhase();
        if (changedSeasonFlag || changedPhaseFlag) {
            this.onSeasonChange(world, prevSettings, this.currentSeason.getCurrentSettings());
        }
    }

    private void onSeasonChange(World world, BWSubseasonSettings prevSettings, BWSubseasonSettings currentSettings) {
        ((BiomeUpdate)world).updateBiomeData();
        if (!world.field_72995_K) {
            this.updateWeatherMultiplier(world, prevSettings.getWeatherEventChanceMultiplier(), currentSettings.getWeatherEventChanceMultiplier());
            this.updatePacket(((ServerWorld)world).func_217369_A());
        }
    }

    public void updateWeatherMultiplier(World world, double prevMultiplier, double currentMultiplier) {
        ServerWorldInfo worldInfo;
        if (world.func_72912_H() instanceof ServerWorldInfo && !(worldInfo = (ServerWorldInfo)world.func_72912_H()).func_76059_o()) {
            worldInfo.func_76080_g(BetterWeatherUtil.transformRainOrThunderTimeToCurrentSeason(worldInfo.func_76083_p(), prevMultiplier, currentMultiplier));
            worldInfo.func_76090_f(BetterWeatherUtil.transformRainOrThunderTimeToCurrentSeason(worldInfo.func_76071_n(), prevMultiplier, currentMultiplier));
        }
    }

    public void enhanceCropRandomTick(ServerWorld world, BlockPos pos, Block block, BlockState self, CallbackInfo ci) {
        if (this.getCurrentSeason().getCurrentSettings().getEnhancedCrops().contains((Object)block)) {
            RegistryKey currentBiomeKey = (RegistryKey)world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)world.func_226691_t_(pos)).get();
            double cropBonus = this.cropToFavoriteBiomes.containsKey(block) ? this.cropToFavoriteBiomes.get(block).getOrDefault((Object)currentBiomeKey, 0.0) : 0.0;
            double cropGrowthMultiplier = this.getCurrentSubSeasonSettings().getCropGrowthMultiplier((RegistryKey<Biome>)currentBiomeKey, block) + cropBonus;
            if (cropGrowthMultiplier == 1.0) {
                return;
            }
            BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos.func_177981_b(1));
            for (int move = 0; move <= 16; ++move) {
                if (!world.func_180495_p((BlockPos)mutable.func_189536_c(Direction.UP)).func_235714_a_((ITag)Tags.Blocks.GLASS)) continue;
                cropGrowthMultiplier *= 1.5;
                break;
            }
            if (cropGrowthMultiplier < 1.0) {
                if (world.func_201674_k().nextDouble() < cropGrowthMultiplier) {
                    block.func_225542_b_(self, world, pos, world.func_201674_k());
                } else {
                    ci.cancel();
                }
            } else if (cropGrowthMultiplier > 1.0) {
                int numberOfTicks = world.func_201674_k().nextInt(world.func_201674_k().nextDouble() + (cropGrowthMultiplier - 1.0) < cropGrowthMultiplier ? (int)Math.ceil(cropGrowthMultiplier) : (int)cropGrowthMultiplier) + 1;
                for (int tick = 0; tick < numberOfTicks && (tick <= 0 || block == (self = world.func_180495_p(pos)).func_177230_c()); ++tick) {
                    block.func_225542_b_(self, world, pos, world.func_201674_k());
                }
            }
        }
    }

    public void updatePacket(List<ServerPlayerEntity> players) {
        NetworkHandler.sendToAllPlayers(players, new RefreshRenderersPacket());
    }

    private void tickSeasonTime(World world) {
        if (world instanceof ServerWorld && !this.tickSeasonTimeWhenNoPlayersOnline && world.func_217369_A().isEmpty()) {
            return;
        }
        if (world.func_82736_K().func_223586_b(BetterWeatherGameRules.DO_SEASON_CYCLE)) {
            this.currentYearTime = this.currentYearTime > this.yearLength ? 0 : this.currentYearTime + 1;
            this.currentSeason = this.seasons.get((Object)Season.getSeasonFromTime(this.currentYearTime, this.yearLength)).setPhaseForTime(this.currentYearTime, this.yearLength);
            if (world.func_72912_H().func_82573_f() % 50L == 0L) {
                this.save(world);
            }
        }
        if (world instanceof ServerWorld && world.func_72912_H().func_82573_f() % 3L == 0L) {
            NetworkHandler.sendToAllPlayers(((ServerWorld)world).func_217369_A(), new SeasonTimePacket(this.currentYearTime));
        }
    }

    private void save(World world) {
        SeasonSavedData.get((IWorld)world).setCurrentYearTime(this.currentYearTime);
        SeasonSavedData.get((IWorld)world).setYearLength(this.yearLength);
    }

    public SeasonConfigHolder handleConfig(boolean isClient) {
        this.createConfig();
        if (!this.seasonConfigFile.exists()) {
            BetterWeather.LOGGER.error(this.seasonConfigFile.toString() + " does not exist and therefore cannot be read, using defaults...");
            return SeasonConfigHolder.DEFAULT_CONFIG_HOLDER;
        }
        SeasonConfigHolder configHolder = this.read(isClient);
        this.fillSubSeasonOverrideStorageAndSetCropTags(isClient);
        return configHolder;
    }

    private void createConfig() {
        CommentedConfig readConfig;
        CommentedConfig commentedConfig = readConfig = this.seasonConfigFile.exists() ? (CommentedConfig)CommentedFileConfig.builder((File)this.seasonConfigFile).sync().autosave().writingMode(WritingMode.REPLACE).build() : CommentedConfig.inMemory();
        if (readConfig instanceof CommentedFileConfig) {
            ((CommentedFileConfig)readConfig).load();
        }
        CommentedConfig encodedConfig = (CommentedConfig)SeasonConfigHolder.CODEC.encodeStart((DynamicOps)CONFIG_OPS, (Object)SeasonConfigHolder.DEFAULT_CONFIG_HOLDER).result().get();
        try {
            Files.createDirectories(this.seasonConfigFile.toPath().getParent(), new FileAttribute[0]);
            new TomlWriter().write((UnmodifiableConfig)(this.seasonConfigFile.exists() ? TomlCommentedConfigOps.recursivelyUpdateAndSortConfig(readConfig, encodedConfig) : encodedConfig), this.seasonConfigFile, WritingMode.REPLACE);
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SeasonConfigHolder read(boolean isClient) {
        try (FileReader reader = new FileReader(this.seasonConfigFile);){
            Optional configHolder = SeasonConfigHolder.CODEC.parse((DynamicOps)CONFIG_OPS, (Object)new TomlParser().parse((Reader)reader)).resultOrPartial(arg_0 -> ((Logger)BetterWeather.LOGGER).error(arg_0));
            if (!isClient) {
                if (configHolder.isPresent()) {
                    this.seasons.putAll(((SeasonConfigHolder)configHolder.get()).getSeasonKeySeasonMap());
                    this.yearLength = ((SeasonConfigHolder)configHolder.get()).getSeasonCycleLength();
                } else {
                    this.seasons.putAll(SeasonConfigHolder.DEFAULT_CONFIG_HOLDER.getSeasonKeySeasonMap());
                    this.yearLength = SeasonConfigHolder.DEFAULT_CONFIG_HOLDER.getSeasonCycleLength();
                }
            } else if (configHolder.isPresent()) {
                for (Map.Entry entry : ((SeasonConfigHolder)configHolder.get()).getSeasonKeySeasonMap().entrySet()) {
                    Season.Key key = (Season.Key)((Object)entry.getKey());
                    BWSeason season = (BWSeason)entry.getValue();
                    for (Season.Phase phase : Season.Phase.values()) {
                        this.seasons.get((Object)key).getSettingsForPhase(phase).setClient(season.getSettingsForPhase(phase).getClientSettings());
                    }
                }
            }
            SeasonConfigHolder seasonConfigHolder = configHolder.orElse(SeasonConfigHolder.DEFAULT_CONFIG_HOLDER);
            return seasonConfigHolder;
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error(e.toString());
            return SeasonConfigHolder.DEFAULT_CONFIG_HOLDER;
        }
    }

    private void fillSubSeasonOverrideStorageAndSetCropTags(boolean isClient) {
        for (Map.Entry<Season.Key, BWSeason> seasonKeySeasonEntry : this.seasons.entrySet()) {
            Season.Key seasonKey = seasonKeySeasonEntry.getKey();
            seasonKeySeasonEntry.getValue().setSeasonKey(seasonKey);
            IdentityHashMap<Season.Phase, BWSubseasonSettings> phaseSettings = seasonKeySeasonEntry.getValue().getPhaseSettings();
            for (Map.Entry phaseSubSeasonSettingsEntry : phaseSettings.entrySet()) {
                String mapKey = (Object)((Object)seasonKey) + "-" + phaseSubSeasonSettingsEntry.getKey();
                if (!isClient) {
                    String worldKey = this.worldID.toString().replace(":", ".");
                    ITag.INamedTag<Block> unenhancedCrops = BWSeason.UNAFFECTED_CROPS.get(mapKey);
                    ((BWSubseasonSettings)phaseSubSeasonSettingsEntry.getValue()).setCropTags(BWSeason.AFFECTED_CROPS.get(mapKey).func_230236_b_().isEmpty() ? (BWSeason.AFFECTED_CROPS.get(worldKey).func_230236_b_().isEmpty() ? GLOBAL_AFFECTED_CROPS : BWSeason.AFFECTED_CROPS.get(worldKey)) : GLOBAL_AFFECTED_CROPS, unenhancedCrops.func_230236_b_().isEmpty() ? (BWSeason.UNAFFECTED_CROPS.get(worldKey).func_230236_b_().isEmpty() ? unenhancedCrops : unenhancedCrops) : unenhancedCrops);
                }
                BiomeOverrideJsonHandler.handleOverrideJsonConfigs(this.seasonOverridesPath.resolve(seasonKeySeasonEntry.getKey().toString() + "-" + phaseSubSeasonSettingsEntry.getKey() + ".json"), seasonKeySeasonEntry.getKey() == Season.Key.WINTER ? BWSubseasonSettings.WINTER_OVERRIDE : new IdentityHashMap<Object, OverrideStorage>(), (BWSubseasonSettings)phaseSubSeasonSettingsEntry.getValue(), this.biomeRegistry, isClient);
            }
        }
    }

    public BWSeason getCurrentSeason() {
        return this.currentSeason;
    }

    public BWSubseasonSettings getCurrentSubSeasonSettings() {
        return this.currentSeason.getCurrentSettings();
    }

    @Override
    public Season.Key getKey() {
        return this.currentSeason.getSeasonKey();
    }

    @Override
    public int getYearLength() {
        return this.yearLength;
    }

    @Override
    public int getCurrentYearTime() {
        return this.currentYearTime;
    }

    @Override
    public Season.Phase getPhase() {
        return this.currentSeason.getCurrentPhase();
    }

    @Override
    public SubseasonSettings getSettings() {
        return this.currentSeason.getCurrentSettings();
    }

    @Override
    public IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> getCropFavoriteBiomeBonuses() {
        return this.cropToFavoriteBiomes;
    }

    public void setCurrentYearTime(int currentYearTime) {
        this.currentYearTime = currentYearTime;
    }

    public IdentityHashMap<Season.Key, BWSeason> getSeasons() {
        return this.seasons;
    }
}

