/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.season.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.season.BWSeason;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;

public class SeasonConfigHolder {
    public static final IdentityHashMap<Season.Key, BWSeason> DEFAULT_SEASONS = (IdentityHashMap)Util.func_200696_a(new IdentityHashMap(), map -> {
        map.put(Season.Key.SPRING, BWSeason.DEFAULT_SPRING);
        map.put(Season.Key.SUMMER, BWSeason.DEFAULT_SUMMER);
        map.put(Season.Key.AUTUMN, BWSeason.DEFAULT_AUTUMN);
        map.put(Season.Key.WINTER, BWSeason.DEFAULT_WINTER);
    });
    public static final SeasonConfigHolder DEFAULT_CONFIG_HOLDER = new SeasonConfigHolder(true, 2400000, DEFAULT_SEASONS);
    public static final Codec<SeasonConfigHolder> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("tickSeasonTimeWhenNoPlayersOnline").orElse((Object)true).forGetter(seasonConfigHolder -> seasonConfigHolder.tickSeasonTimeWhenNoPlayersOnline), (App)Codec.INT.fieldOf("yearLength").orElse((Object)2400000).forGetter(seasonConfigHolder -> seasonConfigHolder.seasonCycleLength), (App)Codec.simpleMap(Season.Key.CODEC, BWSeason.CODEC, (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])Season.Key.values())).fieldOf("seasons").forGetter(seasonConfigHolder -> seasonConfigHolder.seasonKeySeasonMap)).apply((Applicative)builder, (tickSeasonTimeWhenNoPlayersOnline, cycleLength, seasons) -> new SeasonConfigHolder((boolean)tickSeasonTimeWhenNoPlayersOnline, (int)cycleLength, new IdentityHashMap<Season.Key, BWSeason>((Map<Season.Key, BWSeason>)seasons))));
    private final boolean tickSeasonTimeWhenNoPlayersOnline;
    private final int seasonCycleLength;
    private final IdentityHashMap<Season.Key, BWSeason> seasonKeySeasonMap;

    public SeasonConfigHolder(boolean tickSeasonTimeWhenNoPlayersOnline, int seasonCycleLength, IdentityHashMap<Season.Key, BWSeason> seasonKeySeasonMap) {
        this.tickSeasonTimeWhenNoPlayersOnline = tickSeasonTimeWhenNoPlayersOnline;
        this.seasonCycleLength = seasonCycleLength;
        this.seasonKeySeasonMap = seasonKeySeasonMap;
        for (Season.Key key : seasonKeySeasonMap.keySet()) {
            seasonKeySeasonMap.get((Object)key).setSeasonKey(key);
        }
    }

    public boolean isTickSeasonTimeWhenNoPlayersOnline() {
        return this.tickSeasonTimeWhenNoPlayersOnline;
    }

    public int getSeasonCycleLength() {
        return this.seasonCycleLength;
    }

    public IdentityHashMap<Season.Key, BWSeason> getSeasonKeySeasonMap() {
        return this.seasonKeySeasonMap;
    }
}

