/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.season.config.cropfavoritebiomes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.season.config.cropfavoritebiomes.CropFavoriteBiomesDeserializer;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.IdentityHashMap;
import net.minecraft.block.Block;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class CropFavoriteBiomesConfigHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> handle(Path path, IdentityHashMap<Block, Object2DoubleArrayMap<Object>> objectToOverrideStorageDefault, Registry<Biome> biomeRegistry) {
        Gson gson = new GsonBuilder().registerTypeAdapter(IdentityHashMap.class, (Object)new CropFavoriteBiomesDeserializer(biomeRegistry)).setPrettyPrinting().disableHtmlEscaping().create();
        File file = path.toFile();
        if (!file.exists() && !objectToOverrideStorageDefault.isEmpty()) {
            CropFavoriteBiomesConfigHandler.create(path, biomeRegistry, objectToOverrideStorageDefault);
        }
        if (!file.exists()) return new IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>>();
        try (FileReader reader = new FileReader(path.toString());){
            IdentityHashMap cropToFavoriteBiome = (IdentityHashMap)gson.fromJson((Reader)reader, IdentityHashMap.class);
            if (cropToFavoriteBiome != null) {
                IdentityHashMap identityHashMap = cropToFavoriteBiome;
                return identityHashMap;
            }
            BetterWeather.LOGGER.error("\"" + path.toString() + "\" could not be read...");
            return new IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>>();
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error("\"" + path.toString() + "\" could not be read..." + e.toString());
        }
        return new IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>>();
    }

    public static void create(Path path, Registry<Biome> biomeRegistry, IdentityHashMap<Block, Object2DoubleArrayMap<Object>> objectToOverrideStorageDefault) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(IdentityHashMap.class, (Object)new CropFavoriteBiomesDeserializer(biomeRegistry));
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(objectToOverrideStorageDefault);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, jsonString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error("\"" + path.toString() + "\" could not be created..." + e.toString());
        }
    }
}

