/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.season.config.cropfavoritebiomes;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.season.config.overrides.OverrideDeserializer;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class CropFavoriteBiomesDeserializer
implements JsonSerializer<IdentityHashMap<Block, Object2DoubleArrayMap<Object>>>,
JsonDeserializer<IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>>> {
    private final Registry<Biome> biomeRegistry;
    private final Map<Biome.Category, List<Biome>> categoryBiomes;
    private final Map<BiomeDictionary.Type, List<Biome>> biomeDictionaryBiomes;

    public CropFavoriteBiomesDeserializer(Registry<Biome> biomeRegistry) {
        this.biomeRegistry = biomeRegistry;
        this.categoryBiomes = biomeRegistry.func_239659_c_().stream().map(Map.Entry::getValue).collect(Collectors.groupingBy(Biome::func_201856_r));
        this.biomeDictionaryBiomes = biomeRegistry.func_239659_c_().stream().flatMap(biomeKey -> BiomeDictionary.getTypes((RegistryKey)((RegistryKey)biomeKey.getKey())).stream().map(biomeDictionaryType -> new AbstractMap.SimpleEntry((BiomeDictionary.Type)biomeDictionaryType, biomeKey.getValue()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Set blockFavBiomesEntries = json.getAsJsonObject().entrySet();
        StringBuilder errors = new StringBuilder();
        IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>> cropToFavoriteBiome = new IdentityHashMap<Block, Object2DoubleArrayMap<RegistryKey<Biome>>>();
        for (Map.Entry entry : blockFavBiomesEntries) {
            String key = (String)entry.getKey();
            ResourceLocation resourceLocation = ResourceLocation.func_208304_a((String)key);
            Optional blockOptional = Registry.field_212618_g.func_241873_b(resourceLocation);
            if (!blockOptional.isPresent()) {
                BetterWeather.LOGGER.error("\"" + key + "\" is not a valid block resource location, skipping...");
                continue;
            }
            Block block = (Block)blockOptional.get();
            Set favBiomeEntries = ((JsonElement)entry.getValue()).getAsJsonObject().entrySet();
            for (Map.Entry favBiomeEntry : favBiomeEntries) {
                String favBiomeEntryKey = (String)favBiomeEntry.getKey();
                Object type = OverrideDeserializer.extractKey(errors, favBiomeEntryKey, this.biomeRegistry);
                if (type == null) continue;
                double asDouble = ((JsonElement)favBiomeEntry.getValue()).getAsDouble();
                if (asDouble <= 0.0) {
                    BetterWeather.LOGGER.warn("Bonus must be above 0.0. You put \"" + asDouble + "\" for biome entry \"" + key + "\" at crop \"" + key + "\".");
                    continue;
                }
                if (type instanceof Biome) {
                    cropToFavoriteBiome.computeIfAbsent(block, block1 -> new Object2DoubleArrayMap()).put(this.biomeRegistry.func_230519_c_((Object)((Biome)type)).orElse(null), asDouble);
                    continue;
                }
                if (type instanceof Biome.Category) {
                    for (Biome biome : this.categoryBiomes.get((Biome.Category)type)) {
                        cropToFavoriteBiome.computeIfAbsent(block, block1 -> new Object2DoubleArrayMap()).put(this.biomeRegistry.func_230519_c_((Object)biome).orElse(null), asDouble);
                    }
                    continue;
                }
                if (!(type instanceof BiomeDictionary.Type)) continue;
                for (Biome biome : (List)this.biomeDictionaryBiomes.getOrDefault((BiomeDictionary.Type)type, new ArrayList())) {
                    cropToFavoriteBiome.computeIfAbsent(block, block1 -> new Object2DoubleArrayMap()).put(this.biomeRegistry.func_230519_c_((Object)biome).orElse(null), asDouble);
                }
            }
        }
        if (!errors.toString().isEmpty()) {
            BetterWeather.LOGGER.error((CharSequence)errors);
        }
        return cropToFavoriteBiome;
    }

    public JsonElement serialize(IdentityHashMap<Block, Object2DoubleArrayMap<Object>> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        for (Map.Entry<Block, Object2DoubleArrayMap<Object>> blockObject2DoubleArrayMapEntry : src.entrySet()) {
            Block key = blockObject2DoubleArrayMapEntry.getKey();
            Object2DoubleArrayMap<Object> favoriteBiomes = blockObject2DoubleArrayMapEntry.getValue();
            JsonObject favBiomes = new JsonObject();
            for (Object2DoubleMap.Entry objectEntry : favoriteBiomes.object2DoubleEntrySet()) {
                Object object = objectEntry.getKey();
                double value = objectEntry.getDoubleValue();
                if (object instanceof Biome.Category) {
                    Biome.Category category = (Biome.Category)object;
                    favBiomes.addProperty("category/" + category.toString(), (Number)value);
                    continue;
                }
                if (object instanceof BiomeDictionary.Type) {
                    BiomeDictionary.Type type = (BiomeDictionary.Type)object;
                    favBiomes.addProperty("forge/" + type.toString(), (Number)value);
                    continue;
                }
                if (object instanceof ResourceLocation) {
                    ResourceLocation location = (ResourceLocation)object;
                    favBiomes.addProperty("biome/" + location.toString(), (Number)value);
                    continue;
                }
                throw new IllegalArgumentException("Could not serialize object of class type: " + object.getClass().getName());
            }
            result.add(Registry.field_212618_g.func_177774_c((Object)key).toString(), (JsonElement)favBiomes);
        }
        return result;
    }
}

