/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.season.config.overrides;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.season.BWSubseasonSettings;
import corgitaco.betterweather.season.config.overrides.BiomeToOverrideStorageJsonStorage;
import corgitaco.betterweather.season.config.overrides.OverrideDeserializer;
import corgitaco.betterweather.season.storage.OverrideStorage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.IdentityHashMap;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class BiomeOverrideJsonHandler {
    public static void handleOverrideJsonConfigs(Path path, IdentityHashMap<Object, OverrideStorage> objectToOverrideStorageDefault, BWSubseasonSettings subSeasonSettings, Registry<Biome> biomeRegistry, boolean isClient) {
        Gson gson = new GsonBuilder().registerTypeAdapter(BiomeToOverrideStorageJsonStorage.class, (Object)new OverrideDeserializer(biomeRegistry, subSeasonSettings.getBiomeToOverrideStorage(), subSeasonSettings.getCropToMultiplierStorage(), isClient)).setPrettyPrinting().disableHtmlEscaping().create();
        File CONFIG_FILE = path.toFile();
        if (!CONFIG_FILE.exists() && !objectToOverrideStorageDefault.isEmpty()) {
            BiomeOverrideJsonHandler.createOverridesJson(path, objectToOverrideStorageDefault);
        }
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(path.toString());){
                BiomeToOverrideStorageJsonStorage biomeToOverrideStorageJsonStorage = (BiomeToOverrideStorageJsonStorage)gson.fromJson((Reader)reader, BiomeToOverrideStorageJsonStorage.class);
                if (biomeToOverrideStorageJsonStorage != null) {
                    subSeasonSettings.setBiomeToOverrideStorage(biomeToOverrideStorageJsonStorage.getBiomeToOverrideStorage());
                    subSeasonSettings.setCropToMultiplierStorage(biomeToOverrideStorageJsonStorage.getSeasonCropOverrides());
                } else {
                    BetterWeather.LOGGER.error("\"" + path.toString() + "\" could not be read...");
                }
            }
            catch (IOException e) {
                BetterWeather.LOGGER.error("\"" + path.toString() + "\" could not be read..." + e.toString());
            }
        }
    }

    public static void createOverridesJson(Path path, IdentityHashMap<Object, OverrideStorage> objectToOverrideStorageDefault) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(BiomeToOverrideStorageJsonStorage.ObjectToOverrideStorageJsonStorage.class, (Object)new OverrideDeserializer.ObjectToOverrideStorageJsonStorageSerializer());
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson((Object)new BiomeToOverrideStorageJsonStorage.ObjectToOverrideStorageJsonStorage(objectToOverrideStorageDefault));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, jsonString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error("\"" + path.toString() + "\" could not be created..." + e.toString());
        }
    }
}

