/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.season.SeasonContext;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SetSeasonCommand {
    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        List seasons = Arrays.stream(Season.Key.values()).map(Objects::toString).collect(Collectors.toList());
        List phases = Arrays.stream(Season.Phase.values()).map(Objects::toString).collect(Collectors.toList());
        return Commands.func_197057_a((String)"setseason").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"season", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(seasons.stream(), (SuggestionsBuilder)sb)).executes(cs -> SetSeasonCommand.betterWeatherSetSeason((CommandSource)cs.getSource(), (String)cs.getArgument("season", String.class), Season.Phase.MID.name()))).then(Commands.func_197056_a((String)"phase", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(phases.stream(), (SuggestionsBuilder)sb)).executes(cs -> SetSeasonCommand.betterWeatherSetSeason((CommandSource)cs.getSource(), (String)cs.getArgument("season", String.class), (String)cs.getArgument("phase", String.class)))));
    }

    public static int betterWeatherSetSeason(CommandSource source, String seasonKey, String phaseString) {
        SeasonContext seasonContext = ((BetterWeatherWorldData)source.func_197023_e()).getSeasonContext();
        if (seasonContext == null) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.bw.setseason.fail.no_seasons"));
            return 0;
        }
        seasonKey = seasonKey.toUpperCase();
        phaseString = phaseString.toUpperCase();
        if (!Season.Key.hasType(seasonKey) || !Season.Phase.hasType(phaseString)) {
            return 0;
        }
        Season.Key season = Season.Key.valueOf(seasonKey);
        Season.Phase phase = Season.Phase.valueOf(phaseString);
        seasonContext.setSeason(source.func_197023_e(), source.func_197023_e().func_217369_A(), season, phase);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.bw.setseason.success", new Object[]{season.translationTextComponent(), phase.translationTextComponent()}), true);
        return 1;
    }
}

