/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.weather.BWWeatherEventContext;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class SetWeatherCommand {
    public static final String WEATHER_NOT_ENABLED = "null";
    public static final List<String> LENGTH_SUGGESTIONS = Arrays.asList("1200", "6000", "12000", "36000");

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return Commands.func_197057_a((String)"setweather").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"weather", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> {
            BWWeatherEventContext weatherEventContext = ((BetterWeatherWorldData)((CommandSource)ctx.getSource()).func_197023_e()).getWeatherEventContext();
            return ISuggestionProvider.func_197013_a(weatherEventContext != null ? weatherEventContext.getWeatherEvents().keySet().stream() : Arrays.stream(new String[]{WEATHER_NOT_ENABLED}), (SuggestionsBuilder)sb);
        }).executes(cs -> SetWeatherCommand.betterWeatherSetSeason((CommandSource)cs.getSource(), (String)cs.getArgument("weather", String.class), 12000))).then(Commands.func_197056_a((String)"length", (ArgumentType)IntegerArgumentType.integer()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(LENGTH_SUGGESTIONS.stream(), (SuggestionsBuilder)sb)).executes(cs -> SetWeatherCommand.betterWeatherSetSeason((CommandSource)cs.getSource(), (String)cs.getArgument("weather", String.class), (Integer)cs.getArgument("length", Integer.TYPE)))));
    }

    public static int betterWeatherSetSeason(CommandSource source, String weatherKey, int length) {
        if (weatherKey.equals(WEATHER_NOT_ENABLED)) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.bw.setweather.no.weather.for.world"));
            return 0;
        }
        ServerWorld world = source.func_197023_e();
        BWWeatherEventContext weatherEventContext = ((BetterWeatherWorldData)world).getWeatherEventContext();
        if (weatherEventContext != null) {
            if (weatherEventContext.getWeatherEvents().containsKey(weatherKey)) {
                source.func_197030_a((ITextComponent)weatherEventContext.weatherForcer(weatherKey, length, world).successTranslationTextComponent(weatherKey), true);
            } else {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.bw.setweather.fail.no_weather_event", new Object[]{weatherKey}));
                return 0;
            }
        }
        return 1;
    }
}

