/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.util;

import com.mojang.serialization.Codec;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.BetterWeatherRegistry;
import corgitaco.betterweather.api.weather.WeatherEvent;
import corgitaco.betterweather.season.BWSubseasonSettings;
import corgitaco.betterweather.season.storage.OverrideStorage;
import corgitaco.betterweather.util.client.ColorUtil;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class BetterWeatherUtil {
    public static boolean filterRegistryID(ResourceLocation id, Registry<?> registry, String registryTypeName) {
        if (registry.func_148742_b().contains(id)) {
            return true;
        }
        if (!id.toString().contains("modid:dummymob")) {
            BetterWeather.LOGGER.error("\"" + id.toString() + "\" was not a registryID in the " + registryTypeName + "! Skipping entry...");
        }
        return false;
    }

    public static <I, O> O unsafeCast(I obj) {
        return (O)obj;
    }

    public static int transformRainOrThunderTimeToCurrentSeason(int rainOrThunderTime, BWSubseasonSettings previous, BWSubseasonSettings current) {
        double previousMultiplier = previous.getWeatherEventChanceMultiplier();
        double currentMultiplier = current.getWeatherEventChanceMultiplier();
        return BetterWeatherUtil.transformRainOrThunderTimeToCurrentSeason(rainOrThunderTime, previousMultiplier, currentMultiplier);
    }

    public static int transformRainOrThunderTimeToCurrentSeason(int rainOrThunderTime, double prevMultiplier, double currentMultiplier) {
        double normalTime = (double)rainOrThunderTime * prevMultiplier;
        return (int)(normalTime * 1.0 / currentMultiplier);
    }

    public static int modifiedColorValue(int original, int target, double blendStrength) {
        return (int)MathHelper.func_219803_d((double)blendStrength, (double)original, (double)target);
    }

    public static int transformFloatColor(Vector3d floatColor) {
        return ColorUtil.pack((int)(floatColor.func_82615_a() * 255.0), (int)(floatColor.func_82617_b() * 255.0), (int)(floatColor.func_82616_c() * 255.0));
    }

    public static IdentityHashMap<Block, Double> transformBlockResourceLocations(Map<ResourceLocation, Double> blockResourceLocationToCropGrowthMultiplierMap) {
        IdentityHashMap<Block, Double> newMap = new IdentityHashMap<Block, Double>();
        blockResourceLocationToCropGrowthMultiplierMap.forEach((resourceLocation, multiplier) -> {
            if (Registry.field_212618_g.func_148742_b().contains(resourceLocation)) {
                newMap.put((Block)Registry.field_212618_g.func_82594_a(resourceLocation), (Double)multiplier);
            } else {
                BetterWeather.LOGGER.error("The value: \"" + resourceLocation.toString() + "\" is not a valid block ID...");
            }
        });
        return newMap;
    }

    public static IdentityHashMap<Block, Block> transformBlockBlockResourceLocations(Map<ResourceLocation, ResourceLocation> blockBlockMap) {
        IdentityHashMap<Block, Block> newMap = new IdentityHashMap<Block, Block>();
        blockBlockMap.forEach((resourceLocation, resourceLocation2) -> {
            if (Registry.field_212618_g.func_148742_b().contains(resourceLocation) && Registry.field_212618_g.func_148742_b().contains(resourceLocation2)) {
                newMap.put((Block)Registry.field_212618_g.func_82594_a(resourceLocation), (Block)Registry.field_212618_g.func_82594_a(resourceLocation2));
            } else {
                BetterWeather.LOGGER.error("The value: \"" + resourceLocation.toString() + "\" is not a valid block ID...");
            }
        });
        return newMap;
    }

    public static TreeMap<ResourceLocation, ResourceLocation> transformBlockBlocksToResourceLocations(Map<Block, Block> blockBlockMap) {
        TreeMap<ResourceLocation, ResourceLocation> newMap = new TreeMap<ResourceLocation, ResourceLocation>(Comparator.comparing(ResourceLocation::toString));
        blockBlockMap.forEach((resourceLocation, resourceLocation2) -> newMap.put(Registry.field_212618_g.func_177774_c(resourceLocation), Registry.field_212618_g.func_177774_c(resourceLocation2)));
        return newMap;
    }

    public static IdentityHashMap<RegistryKey<Biome>, OverrideStorage> transformBiomeResourceLocationsToKeys(Map<ResourceLocation, OverrideStorage> blockResourceLocationToCropGrowthMultiplierMap) {
        IdentityHashMap<RegistryKey<Biome>, OverrideStorage> newMap = new IdentityHashMap<RegistryKey<Biome>, OverrideStorage>();
        blockResourceLocationToCropGrowthMultiplierMap.forEach((resourceLocation, multiplier) -> newMap.put((RegistryKey<Biome>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)resourceLocation), (OverrideStorage)multiplier));
        return newMap;
    }

    public static ReferenceArraySet<RegistryKey<Codec<? extends WeatherEvent>>> transformWeatherLocationsToKeys(Collection<ResourceLocation> blockResourceLocationToCropGrowthMultiplierMap) {
        ReferenceArraySet newMap = new ReferenceArraySet();
        blockResourceLocationToCropGrowthMultiplierMap.forEach(resourceLocation -> newMap.add((Object)RegistryKey.func_240903_a_(BetterWeatherRegistry.WEATHER_EVENT_KEY, (ResourceLocation)resourceLocation)));
        return newMap;
    }
}

