/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.util;

import com.mojang.serialization.Lifecycle;
import corgitaco.betterweather.mixin.access.BiomeAccess;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CommonKeyMutableRegistry
extends SimpleRegistry<Biome> {
    private final Map<Biome, Biome> storage = new IdentityHashMap<Biome, Biome>();

    public CommonKeyMutableRegistry(MutableRegistry<Biome> registry) {
        super(registry.func_243578_f(), registry.func_241875_b());
        registry.func_239659_c_().forEach(entry -> {
            Biome biome1 = (Biome)entry.getValue();
            Biome biome2 = (Biome)this.func_218382_a(registry.func_148757_b((Object)biome1), (RegistryKey)entry.getKey(), CommonKeyMutableRegistry.shallow(biome1), ((SimpleRegistry)registry).func_241876_d((Object)biome1));
            ResourceLocation name = Objects.requireNonNull(biome1.getRegistryName(), "Invalid Biome registry name.");
            this.storage.put(biome1, (Biome)biome2.setRegistryName(name));
        });
    }

    private static Biome shallow(Biome biome) {
        Biome.Climate climate = ((BiomeAccess)biome).getClimate();
        return BiomeAccess.create(climate, biome.func_201856_r(), biome.func_185355_j(), biome.func_185360_m(), biome.func_235089_q_(), biome.func_242440_e(), biome.func_242433_b());
    }

    public ResourceLocation getKey(@NotNull Biome biome) {
        return super.func_177774_c((Object)this.get(biome));
    }

    @NotNull
    public Optional<RegistryKey<Biome>> getOptionalKey(@NotNull Biome biome) {
        return super.func_230519_c_((Object)this.get(biome));
    }

    public int getId(@Nullable Biome biome) {
        return super.func_148757_b((Object)this.get(biome));
    }

    @NotNull
    public Lifecycle getLifecycleByRegistry(@NotNull Biome biome) {
        return super.func_241876_d((Object)this.get(biome));
    }

    @Contract(value="null -> param1")
    private Biome get(Biome biome) {
        return this.storage.getOrDefault(biome, biome);
    }
}

