/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.util;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TomlCommentedConfigOps
implements DynamicOps<Object> {
    public static final TomlCommentedConfigOps INSTANCE = new TomlCommentedConfigOps(new HashMap<String, String>(), true);
    private final Map<String, String> keyCommentMap;
    private final boolean isAlphabeticallySorted;

    public TomlCommentedConfigOps(Map<String, String> keyCommentMap, boolean isAlphabeticallySorted) {
        this.keyCommentMap = keyCommentMap;
        this.isAlphabeticallySorted = isAlphabeticallySorted;
    }

    public Object empty() {
        return NullObject.NULL_OBJECT;
    }

    public <U> U convertTo(DynamicOps<U> outOps, Object input) {
        if (input instanceof Config) {
            return (U)this.convertMap(outOps, input);
        }
        if (input instanceof Collection) {
            return (U)this.convertList(outOps, input);
        }
        if (input == null || input instanceof NullObject) {
            return (U)outOps.empty();
        }
        if (input instanceof Enum) {
            return (U)outOps.createString(((Enum)input).name());
        }
        if (input instanceof Temporal) {
            return (U)outOps.createString(input.toString());
        }
        if (input instanceof String) {
            return (U)outOps.createString((String)input);
        }
        if (input instanceof Boolean) {
            return (U)outOps.createBoolean(((Boolean)input).booleanValue());
        }
        if (input instanceof Number) {
            return (U)outOps.createNumeric((Number)input);
        }
        throw new UnsupportedOperationException("TomlConfigOps was unable to convert toml value: " + input);
    }

    public DataResult<Number> getNumberValue(Object input) {
        return input instanceof Number ? DataResult.success((Object)((Number)input)) : DataResult.error((String)("Not a number: " + input));
    }

    public DataResult<Boolean> getBooleanValue(Object input) {
        return input instanceof Boolean ? DataResult.success((Object)((Boolean)input)) : DataResult.error((String)("Not a boolean: " + input));
    }

    public boolean compressMaps() {
        return false;
    }

    public Object createNumeric(Number i) {
        return i;
    }

    public DataResult<String> getStringValue(Object input) {
        if (input instanceof CommentedConfig || input instanceof Collection) {
            return DataResult.error((String)("Not a string: " + input));
        }
        return DataResult.success((Object)String.valueOf(input));
    }

    public Object createString(String value) {
        return value;
    }

    public Object createBoolean(boolean value) {
        return value;
    }

    public DataResult<Object> mergeToList(Object list, Object value) {
        if (!(list instanceof Collection) && list != this.empty()) {
            return DataResult.error((String)("mergeToList called with not a list: " + list), (Object)list);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (list != this.empty()) {
            Collection listAsCollection = (Collection)list;
            result.addAll(listAsCollection);
        }
        result.add(value);
        return DataResult.success(result);
    }

    public DataResult<Object> mergeToMap(Object map, Object key, Object value) {
        if (!(map instanceof CommentedConfig) && map != this.empty()) {
            return DataResult.error((String)("mergeToMap called with not a map: " + map), (Object)map);
        }
        DataResult<String> stringResult = this.getStringValue(key);
        Optional badResult = stringResult.error();
        if (badResult.isPresent()) {
            return DataResult.error((String)("key is not a string: " + key), (Object)map);
        }
        return stringResult.flatMap(s -> {
            CommentedConfig output = CommentedConfig.inMemory();
            if (map != this.empty()) {
                CommentedConfig oldConfig = TomlCommentedConfigOps.organizeConfig((CommentedConfig)map, this.isAlphabeticallySorted);
                output.addAll((UnmodifiableConfig)oldConfig);
                output.commentMap().putAll(oldConfig.commentMap());
            }
            output.add(s, value);
            if (this.getKeyCommentMap().containsKey(s) && !output.containsComment(s)) {
                output.setComment(s, this.getKeyCommentMap().get(s));
            }
            return DataResult.success((Object)TomlCommentedConfigOps.organizeConfig(output, this.isAlphabeticallySorted));
        });
    }

    public static CommentedConfig organizeConfig(CommentedConfig config, boolean isAlphabeticallySorted) {
        if (!isAlphabeticallySorted) {
            return config;
        }
        CommentedConfig newConfig = CommentedConfig.of((Supplier)Config.getDefaultMapCreator((boolean)false, (boolean)true), (ConfigFormat)TomlFormat.instance());
        List<Map.Entry> organizedCollection = config.valueMap().entrySet().stream().sorted(Comparator.comparing(Objects::toString)).collect(Collectors.toList());
        organizedCollection.forEach(stringObjectEntry -> newConfig.set((String)stringObjectEntry.getKey(), stringObjectEntry.getValue()));
        newConfig.commentMap().putAll(config.commentMap());
        return newConfig;
    }

    public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
        if (!(input instanceof CommentedConfig)) {
            return DataResult.error((String)("Not a Config: " + input));
        }
        CommentedConfig config = (CommentedConfig)input;
        return DataResult.success(config.entrySet().stream().sorted(Comparator.comparing(Objects::toString)).map(entry -> Pair.of((Object)entry.getKey(), (Object)entry.getValue())));
    }

    public Object createMap(Stream<Pair<Object, Object>> map) {
        CommentedConfig result = CommentedConfig.inMemory();
        map.sorted(Comparator.comparing(Objects::toString)).forEach(p -> {
            String key = (String)this.getStringValue(p.getFirst()).getOrThrow(false, s -> {});
            result.add(key, p.getSecond());
            if (this.getKeyCommentMap().containsKey(key) && !result.containsComment(key)) {
                result.setComment(key, this.getKeyCommentMap().get(key));
            }
        });
        return TomlCommentedConfigOps.organizeConfig(result, this.isAlphabeticallySorted);
    }

    public DataResult<Stream<Object>> getStream(Object input) {
        if (input instanceof Collection) {
            Collection collection = (Collection)input;
            return DataResult.success(collection.stream().sorted(Comparator.comparing(Object::toString)));
        }
        return DataResult.error((String)("Not a collection: " + input));
    }

    public Object createList(Stream<Object> input) {
        return input.sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
    }

    public Object remove(Object input, String key) {
        if (input instanceof CommentedConfig) {
            CommentedConfig result = CommentedConfig.inMemory();
            Config oldConfig = (Config)input;
            oldConfig.entrySet().stream().sorted(Comparator.comparing(Objects::toString)).filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(entry -> {
                result.add(entry.getKey(), entry.getValue());
                if (this.getKeyCommentMap().containsKey(key) && !result.containsComment(key)) {
                    result.setComment(key, this.getKeyCommentMap().get(key));
                }
            });
            return TomlCommentedConfigOps.organizeConfig(result, this.isAlphabeticallySorted);
        }
        return TomlCommentedConfigOps.organizeConfig((CommentedConfig)input, this.isAlphabeticallySorted);
    }

    public String toString() {
        return "TOML";
    }

    public RecordBuilder<Object> mapBuilder() {
        return super.mapBuilder();
    }

    public Map<String, String> getKeyCommentMap() {
        return this.keyCommentMap;
    }

    public static CommentedConfig recursivelyUpdateAndSortConfig(CommentedConfig readConfig, CommentedConfig encodedConfig) {
        CommentedConfig newConfig = TomlCommentedConfigOps.organizeConfig(readConfig, true);
        encodedConfig.valueMap().entrySet().stream().sorted(Comparator.comparing(Objects::toString)).forEachOrdered(entry -> {
            Object object = entry.getValue();
            String key = (String)entry.getKey();
            if (object instanceof CommentedConfig) {
                boolean hasConfig;
                try {
                    hasConfig = !newConfig.contains(key);
                }
                catch (NullPointerException e) {
                    hasConfig = false;
                }
                object = !hasConfig ? TomlCommentedConfigOps.recursivelyUpdateAndSortConfig((CommentedConfig)newConfig.set(key, object), (CommentedConfig)object) : TomlCommentedConfigOps.recursivelyUpdateAndSortConfig((CommentedConfig)newConfig.get(key), (CommentedConfig)object);
                newConfig.set(key, object);
            }
            newConfig.add(key, object);
            if (!newConfig.containsComment(key) || !newConfig.getComment(key).equals(encodedConfig.getComment(key))) {
                newConfig.setComment(key, encodedConfig.getComment(key));
            }
        });
        HashSet keysToRemove = new HashSet();
        newConfig.valueMap().forEach((key, object) -> {
            if (!encodedConfig.contains(key)) {
                keysToRemove.add(key);
            }
        });
        keysToRemove.forEach(key -> {
            newConfig.removeComment(key);
            newConfig.remove(key);
        });
        return newConfig;
    }

    class TomlRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Object, CommentedConfig> {
        protected TomlRecordBuilder() {
            super((DynamicOps)TomlCommentedConfigOps.this);
        }

        protected CommentedConfig initBuilder() {
            return CommentedConfig.inMemory();
        }

        protected CommentedConfig append(String key, Object value, CommentedConfig builder) {
            builder.add(key, value);
            return builder;
        }

        protected DataResult<Object> build(CommentedConfig builder, Object prefix) {
            if (prefix == null || prefix instanceof NullObject) {
                return DataResult.success((Object)builder);
            }
            if (prefix instanceof CommentedConfig) {
                CommentedConfig result = CommentedConfig.inMemory();
                CommentedConfig oldConfig = (CommentedConfig)prefix;
                for (Config.Entry entry : oldConfig.entrySet()) {
                    result.add(entry.getKey(), entry.getValue());
                    if (!TomlCommentedConfigOps.this.getKeyCommentMap().containsKey(entry.getKey()) || !result.containsComment(entry.getKey())) continue;
                    result.setComment(entry.getKey(), TomlCommentedConfigOps.this.getKeyCommentMap().get(entry.getKey()));
                }
                for (Config.Entry entry : builder.entrySet()) {
                    result.add(entry.getKey(), entry.getValue());
                    if (!TomlCommentedConfigOps.this.getKeyCommentMap().containsKey(entry.getKey()) || !result.containsComment(entry.getKey())) continue;
                    result.setComment(entry.getKey(), TomlCommentedConfigOps.this.getKeyCommentMap().get(entry.getKey()));
                }
                return DataResult.success((Object)result);
            }
            return DataResult.error((String)("mergeToMap called with not a Config: " + prefix), (Object)prefix);
        }
    }
}

