/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.util;

import com.mojang.serialization.Lifecycle;
import corgitaco.betterweather.mixin.access.DynamicRegistriesAccess;
import corgitaco.betterweather.mixin.access.DynamicRegistriesImplAccess;
import corgitaco.betterweather.util.CommonKeyMutableRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;

public class WorldDynamicRegistry
extends DynamicRegistries.Impl {
    private final DynamicRegistries.Impl serverRegistry;
    private final CommonKeyMutableRegistry commonKeyMutableRegistry;

    public WorldDynamicRegistry(DynamicRegistries.Impl serverRegistry) {
        this.serverRegistry = serverRegistry;
        this.commonKeyMutableRegistry = new CommonKeyMutableRegistry((MutableRegistry<Biome>)serverRegistry.func_243612_b(Registry.field_239720_u_));
        ((DynamicRegistriesImplAccess)((Object)this)).setKeyToSimpleRegistryMap(this.fill());
    }

    public Map<? extends RegistryKey<? extends Registry<?>>, ? extends SimpleRegistry<?>> fill() {
        return DynamicRegistriesAccess.getRegistryCodecMap().keySet().stream().collect(Collectors.toMap(Function.identity(), this::createStableRegistry));
    }

    private <E> SimpleRegistry<?> createStableRegistry(RegistryKey<? extends Registry<?>> key) {
        if (key.func_240901_a_().toString().equals("minecraft:worldgen/biome")) {
            return this.commonKeyMutableRegistry;
        }
        return new SimpleRegistry(key, Lifecycle.stable());
    }

    public <E> Optional<MutableRegistry<E>> func_230521_a_(RegistryKey<? extends Registry<E>> key) {
        if (key.func_240901_a_().toString().equals("minecraft:worldgen/biome")) {
            return Optional.of(this.commonKeyMutableRegistry);
        }
        return this.serverRegistry.func_230521_a_(key);
    }

    public <E> MutableRegistry<E> func_243612_b(RegistryKey<? extends Registry<E>> key) {
        if (key.func_240901_a_().toString().equals("minecraft:worldgen/biome")) {
            return this.func_230521_a_(key).orElseThrow(() -> new IllegalStateException("Missing registry: " + key));
        }
        return this.serverRegistry.func_243612_b(key);
    }

    public Registry<DimensionType> func_230520_a_() {
        return this.serverRegistry.func_230520_a_();
    }
}

