/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.util.client;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.client.ColorSettings;
import corgitaco.betterweather.helpers.BetterWeatherWorldData;
import corgitaco.betterweather.season.BWSubseasonSettings;
import corgitaco.betterweather.season.SeasonContext;
import corgitaco.betterweather.weather.BWWeatherEventContext;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public final class ColorUtil {
    private static final long BIT_MASK = 255L;
    public static final int DEFAULT_RAIN_SKY = ColorUtil.pack(103, 114, 136);
    public static final int DEFAULT_RAIN_FOG = ColorUtil.pack(89, 100, 142);
    public static final int DEFAULT_RAIN_CLOUDS = ColorUtil.pack(158, 158, 158);
    public static final int DEFAULT_THUNDER_SKY = ColorUtil.pack(42, 45, 51);
    public static final int DEFAULT_THUNDER_FOG = ColorUtil.pack(85, 95, 135);
    public static final int DEFAULT_THUNDER_CLOUDS = ColorUtil.pack(37, 37, 37);

    private ColorUtil() {
    }

    public static int getBiomeColor(Biome biome, Type type, int previous) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientWorld world = minecraft.field_71441_e;
        if (world == null) {
            return previous;
        }
        SeasonContext seasonContext = ((BetterWeatherWorldData)world).getSeasonContext();
        BWWeatherEventContext weatherEventContext = ((BetterWeatherWorldData)world).getWeatherEventContext();
        if (seasonContext == null && weatherEventContext == null) {
            return previous;
        }
        Optional optionalKey = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)biome);
        if (!optionalKey.isPresent()) {
            return previous;
        }
        RegistryKey key = (RegistryKey)optionalKey.get();
        int seasonTarget = Integer.MAX_VALUE;
        double seasonBlend = -1.0;
        if (seasonContext != null) {
            BWSubseasonSettings settings = seasonContext.getCurrentSubSeasonSettings();
            switch (type) {
                case GRASS: {
                    seasonTarget = ColorUtil.clamp(settings.getTargetGrassColor((RegistryKey<Biome>)key), previous);
                    seasonBlend = settings.getGrassColorBlendStrength((RegistryKey<Biome>)key);
                    break;
                }
                case FOLIAGE: {
                    seasonTarget = ColorUtil.clamp(settings.getTargetFoliageColor((RegistryKey<Biome>)key), previous);
                    seasonBlend = settings.getFoliageColorBlendStrength((RegistryKey<Biome>)key);
                    break;
                }
                case FOG: {
                    seasonTarget = ColorUtil.clamp(settings.getTargetFogColor((RegistryKey<Biome>)key), previous);
                    seasonBlend = settings.getFogColorBlendStrength((RegistryKey<Biome>)key);
                    break;
                }
                default: {
                    seasonTarget = ColorUtil.clamp(settings.getTargetSkyColor((RegistryKey<Biome>)key), previous);
                    seasonBlend = settings.getSkyColorBlendStrength((RegistryKey<Biome>)key);
                }
            }
        }
        int weatherTarget = Integer.MAX_VALUE;
        double weatherBlend = -1.0;
        if (weatherEventContext != null) {
            ColorSettings colorSettings = weatherEventContext.getCurrentEvent().getClientSettings().getColorSettings();
            switch (type) {
                case GRASS: {
                    if (!weatherEventContext.isRefreshRenderers()) break;
                    weatherTarget = ColorUtil.clamp(colorSettings.getTargetFogHexColor(), previous);
                    weatherBlend = colorSettings.getGrassColorBlendStrength();
                    break;
                }
                case FOLIAGE: {
                    if (!weatherEventContext.isRefreshRenderers()) break;
                    weatherTarget = ColorUtil.clamp(colorSettings.getTargetFoliageHexColor(), previous);
                    weatherBlend = colorSettings.getFoliageColorBlendStrength();
                    break;
                }
                case FOG: {
                    weatherTarget = ColorUtil.clamp(colorSettings.getTargetFogHexColor(), previous);
                    weatherBlend = colorSettings.getFogColorBlendStrength();
                    break;
                }
                default: {
                    weatherTarget = ColorUtil.clamp(colorSettings.getTargetSkyHexColor(), previous);
                    weatherBlend = colorSettings.getSkyColorBlendStrength();
                }
            }
        }
        int seasonMix = ColorUtil.mix(ColorUtil.unpack(previous), ColorUtil.unpack(seasonTarget), seasonBlend);
        int weatherMix = weatherEventContext != null && weatherEventContext.getCurrentEvent().isValidBiome(biome) ? ColorUtil.mix(ColorUtil.unpack(seasonContext != null ? seasonMix : previous), ColorUtil.unpack(weatherTarget), weatherBlend) : Integer.MAX_VALUE;
        return weatherMix == Integer.MAX_VALUE ? seasonMix : weatherMix;
    }

    private static int clamp(int target, int fallback) {
        return target == Integer.MAX_VALUE ? fallback : target;
    }

    public static int mix(int[] start, int[] end, double blend) {
        return ColorUtil.pack(ColorUtil.lerp(start[0], end[0], blend), ColorUtil.lerp(start[1], end[1], blend), ColorUtil.lerp(start[2], end[2], blend), ColorUtil.lerp(start[3], end[3], blend));
    }

    public static int[] transformFloatColor(Vector3d floatColor) {
        return new int[]{255, (int)(floatColor.func_82615_a() * 255.0), (int)(floatColor.func_82617_b() * 255.0), (int)(floatColor.func_82616_c() * 255.0)};
    }

    private static int lerp(int start, int end, double blend) {
        return (int)((double)start + (double)(end - start) * blend);
    }

    public static int pack(int a, int r, int g, int b) {
        return (int)(((long)a & 0xFFL) << 24 | ((long)r & 0xFFL) << 16 | ((long)g & 0xFFL) << 8 | (long)b & 0xFFL);
    }

    public static int pack(int r, int g, int b) {
        return ColorUtil.pack(255, r, g, b);
    }

    public static int[] unpack(int decimal) {
        return new int[]{(int)((long)(decimal >> 24) & 0xFFL), (int)((long)(decimal >> 16) & 0xFFL), (int)((long)(decimal >> 8) & 0xFFL), (int)((long)decimal & 0xFFL)};
    }

    public static int tryParseColor(String input) {
        int result = Integer.MAX_VALUE;
        if (input.isEmpty()) {
            return result;
        }
        try {
            result = (int)Long.parseLong(input.replace("#", "").replace("0x", ""), 16);
        }
        catch (NumberFormatException e) {
            BetterWeather.LOGGER.warn("\"{}\" is not a valid hex. Defaulted to Vanilla.", (Object)input);
        }
        return result;
    }

    public static enum Type {
        GRASS,
        FOLIAGE,
        FOG,
        SKY;

    }
}

