/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weather;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.BetterWeatherRegistry;
import corgitaco.betterweather.api.Climate;
import corgitaco.betterweather.api.client.WeatherEventClient;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.api.weather.WeatherEvent;
import corgitaco.betterweather.api.weather.WeatherEventContext;
import corgitaco.betterweather.api.weather.WeatherEventSettings;
import corgitaco.betterweather.config.BetterWeatherConfig;
import corgitaco.betterweather.data.network.NetworkHandler;
import corgitaco.betterweather.data.network.packet.util.RefreshRenderersPacket;
import corgitaco.betterweather.data.network.packet.weather.WeatherDataPacket;
import corgitaco.betterweather.data.storage.WeatherEventSavedData;
import corgitaco.betterweather.helpers.BiomeUpdate;
import corgitaco.betterweather.util.TomlCommentedConfigOps;
import corgitaco.betterweather.weather.event.None;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Logger;

public class BWWeatherEventContext
implements WeatherEventContext {
    public static final String CONFIG_NAME = "weather-settings.toml";
    private static final String DEFAULT = "betterweather-none";
    public static final Codec<BWWeatherEventContext> PACKET_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("currentEvent").forGetter(weatherEventContext -> weatherEventContext.currentEvent.getName()), (App)Codec.BOOL.fieldOf("weatherForced").forGetter(weatherEventContext -> weatherEventContext.weatherForced), (App)ResourceLocation.field_240908_a_.fieldOf("worldID").forGetter(weatherEventContext -> weatherEventContext.worldID), (App)Codec.unboundedMap((Codec)Codec.STRING, WeatherEvent.CODEC).fieldOf("weatherEvents").forGetter(weatherEventContext -> weatherEventContext.weatherEvents)).apply((Applicative)builder, BWWeatherEventContext::new));
    public static final TomlCommentedConfigOps CONFIG_OPS = new TomlCommentedConfigOps((Map)Util.func_200696_a(new HashMap(), map -> map.put("changeBiomeColors", "Do weather events change biome vegetation colors? This will cause chunks to refresh (F3+A).")), true);
    private final Map<String, WeatherEvent> weatherEvents = new HashMap<String, WeatherEvent>();
    private final ResourceLocation worldID;
    private final Registry<Biome> biomeRegistry;
    private final Path weatherConfigPath;
    private final Path weatherEventsConfigPath;
    private final File weatherConfigFile;
    private boolean refreshRenderers;
    private WeatherEvent currentEvent;
    private boolean weatherForced;

    public BWWeatherEventContext(String currentEvent, boolean weatherForced, ResourceLocation worldID, Map<String, WeatherEvent> weatherEvents) {
        this(currentEvent, weatherForced, worldID, null, weatherEvents);
    }

    public BWWeatherEventContext(WeatherEventSavedData weatherEventSavedData, RegistryKey<World> worldID, Registry<Biome> biomeRegistry) {
        this(weatherEventSavedData.getEvent(), weatherEventSavedData.isWeatherForced(), worldID.func_240901_a_(), biomeRegistry, null);
    }

    public BWWeatherEventContext(String currentEvent, boolean weatherForced, ResourceLocation worldID, @Nullable Registry<Biome> biomeRegistry, @Nullable Map<String, WeatherEvent> weatherEvents) {
        boolean isPacket;
        this.worldID = worldID;
        this.biomeRegistry = biomeRegistry;
        this.weatherConfigPath = BetterWeather.CONFIG_PATH.resolve(worldID.func_110624_b()).resolve(worldID.func_110623_a()).resolve("weather");
        this.weatherEventsConfigPath = this.weatherConfigPath.resolve("events");
        this.weatherConfigFile = this.weatherConfigPath.resolve(CONFIG_NAME).toFile();
        this.weatherEvents.put(DEFAULT, None.DEFAULT.setName(DEFAULT));
        this.weatherForced = weatherForced;
        boolean isClient = weatherEvents != null;
        boolean bl = isPacket = biomeRegistry == null;
        if (isClient) {
            this.weatherEvents.putAll(weatherEvents);
            this.weatherEvents.forEach((key, weatherEvent) -> weatherEvent.setClient(weatherEvent.getClientSettings().createClientSettings()));
        }
        if (!isPacket) {
            this.handleConfig(isClient);
        }
        WeatherEvent currentWeatherEvent = this.weatherEvents.get(currentEvent);
        this.currentEvent = this.weatherEvents.getOrDefault(currentEvent, None.DEFAULT);
        if (currentEvent != null && currentWeatherEvent == null) {
            BetterWeather.LOGGER.error("The last weather event for the world: \"" + worldID.toString() + "\" was not found in: \"" + this.weatherEventsConfigPath.toString() + "\".\nDefaulting to weather event: \"" + DEFAULT + "\".");
        } else if (!isClient && !isPacket) {
            BetterWeather.LOGGER.info(worldID.toString() + " initialized with a weather event of: \"" + (currentEvent == null ? DEFAULT : currentEvent) + "\".");
        }
        if (!isPacket) {
            for (Map.Entry<String, WeatherEvent> stringWeatherEventEntry : this.weatherEvents.entrySet()) {
                stringWeatherEventEntry.getValue().fillBiomes(biomeRegistry);
            }
        }
    }

    public void tick(World world) {
        if (this.weatherEvents.get(DEFAULT) == this.currentEvent && world.func_72896_J()) {
            world.func_72912_H().func_76084_b(false);
        }
        WeatherEvent prevEvent = this.currentEvent;
        boolean wasForced = this.weatherForced;
        if (world instanceof ServerWorld) {
            this.shuffleAndPickWeatherEvent(world);
        }
        if (prevEvent != this.currentEvent || wasForced != this.weatherForced) {
            this.onWeatherChange(world);
        }
        if (world instanceof ServerWorld) {
            this.currentEvent.worldTick((ServerWorld)world, world.func_82736_K().func_223592_c(GameRules.field_223610_m), world.func_82737_E());
        }
        if (world.field_72995_K) {
            this.getCurrentClientEvent().clientTick((ClientWorld)world, world.func_82736_K().func_223592_c(GameRules.field_223610_m), world.func_82737_E(), Minecraft.func_71410_x(), this.currentEvent::isValidBiome);
        }
    }

    private void onWeatherChange(World world) {
        ((BiomeUpdate)world).updateBiomeData();
        this.save(world);
        if (world instanceof ServerWorld) {
            ((IServerWorldInfo)world.func_72912_H()).func_76069_a(this.currentEvent.isThundering());
            this.sendPackets((ServerWorld)world);
        }
    }

    private void sendPackets(ServerWorld world) {
        NetworkHandler.sendToAllPlayers(world.func_217369_A(), new WeatherDataPacket(this));
        if (this.refreshRenderers) {
            NetworkHandler.sendToAllPlayers(world.func_217369_A(), new RefreshRenderersPacket());
        }
    }

    private void shuffleAndPickWeatherEvent(World world) {
        boolean isPrecipitation = world.func_72912_H().func_76059_o();
        Season season = ((Climate)world).getSeason();
        boolean hasSeasons = season != null;
        float rainingStrength = world.field_73004_o;
        if (isPrecipitation) {
            if (rainingStrength <= 0.02f && !this.weatherForced) {
                Random random = new Random(((ServerWorld)world).func_72905_C() + world.func_82737_E());
                ArrayList<String> list = new ArrayList<String>(this.weatherEvents.keySet());
                Collections.shuffle(list, random);
                for (String entry : list) {
                    double chance;
                    if (entry.equals(DEFAULT)) continue;
                    WeatherEvent weatherEvent = this.weatherEvents.get(entry);
                    double d = chance = hasSeasons ? ((Map)weatherEvent.getSeasonChances().getOrDefault((Object)season.getKey(), new IdentityHashMap())).getOrDefault((Object)season.getPhase(), weatherEvent.getDefaultChance()).doubleValue() : weatherEvent.getDefaultChance();
                    if (!(random.nextDouble() < chance) && this.currentEvent != this.weatherEvents.get(DEFAULT)) continue;
                    this.currentEvent = weatherEvent;
                    break;
                }
            }
        } else if (rainingStrength == 0.0f) {
            this.currentEvent = this.weatherEvents.get(DEFAULT);
            this.weatherForced = false;
        }
    }

    private void save(World world) {
        WeatherEventSavedData weatherEventSavedData = WeatherEventSavedData.get((IWorld)world);
        weatherEventSavedData.setEvent(this.currentEvent.getName());
        weatherEventSavedData.setWeatherForced(this.weatherForced);
    }

    public WeatherEvent weatherForcer(String weatherEventName, int weatherEventLength, ServerWorld world) {
        this.currentEvent = this.weatherEvents.get(weatherEventName);
        this.weatherForced = true;
        IServerWorldInfo worldInfo = (IServerWorldInfo)world.func_72912_H();
        boolean isDefault = weatherEventName.equals(DEFAULT);
        if (isDefault) {
            worldInfo.func_230391_a_(weatherEventLength);
        } else {
            worldInfo.func_230391_a_(0);
            worldInfo.func_76080_g(weatherEventLength);
            worldInfo.func_76084_b(true);
            worldInfo.func_76069_a(this.currentEvent.isThundering());
        }
        this.onWeatherChange((World)world);
        return this.currentEvent;
    }

    public void handleConfig(boolean isClient) {
        if (!this.weatherConfigFile.exists()) {
            this.createDefaultWeatherConfigFile();
        } else {
            try (FileReader reader = new FileReader(this.weatherConfigFile);){
                Optional configHolder = WeatherEventConfig.CODEC.parse((DynamicOps)CONFIG_OPS, (Object)new TomlParser().parse((Reader)reader)).resultOrPartial(arg_0 -> ((Logger)BetterWeather.LOGGER).error(arg_0));
                if (configHolder.isPresent()) {
                    this.refreshRenderers = ((WeatherEventConfig)configHolder.get()).changeBiomeColors;
                } else {
                    BetterWeather.LOGGER.error("\"" + this.weatherConfigFile.toString() + "\" not there when requested.");
                }
            }
            catch (IOException e) {
                BetterWeather.LOGGER.error(e.toString());
            }
        }
        this.handleEventConfigs(isClient);
    }

    private void createDefaultWeatherConfigFile() {
        CommentedConfig readConfig;
        CommentedConfig commentedConfig = readConfig = this.weatherConfigFile.exists() ? (CommentedConfig)CommentedFileConfig.builder((File)this.weatherConfigFile).sync().autosave().writingMode(WritingMode.REPLACE).build() : CommentedConfig.inMemory();
        if (readConfig instanceof CommentedFileConfig) {
            ((CommentedFileConfig)readConfig).load();
        }
        CommentedConfig encodedConfig = (CommentedConfig)WeatherEventConfig.CODEC.encodeStart((DynamicOps)CONFIG_OPS, (Object)WeatherEventConfig.DEFAULT).result().get();
        try {
            Files.createDirectories(this.weatherConfigFile.toPath().getParent(), new FileAttribute[0]);
            new TomlWriter().write((UnmodifiableConfig)(this.weatherConfigFile.exists() ? TomlCommentedConfigOps.recursivelyUpdateAndSortConfig(readConfig, encodedConfig) : encodedConfig), this.weatherConfigFile, WritingMode.REPLACE);
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error(e.toString());
        }
    }

    private void handleEventConfigs(boolean isClient) {
        File[] files;
        File eventsDirectory = this.weatherEventsConfigPath.toFile();
        if (!eventsDirectory.exists()) {
            this.createDefaultEventConfigs();
        }
        if ((files = eventsDirectory.listFiles()).length == 0) {
            this.createDefaultEventConfigs();
        }
        if (isClient) {
            this.addSettingsIfMissing();
        }
        this.iterateAndReadConfiguredEvents(eventsDirectory.listFiles(), isClient);
    }

    private void iterateAndReadConfiguredEvents(File[] files, boolean isClient) {
        for (File configFile : files) {
            String absolutePath = configFile.getAbsolutePath();
            if (absolutePath.endsWith(".toml")) {
                this.readToml(isClient, configFile);
                continue;
            }
            if (!absolutePath.endsWith(".json")) continue;
            this.readJson(isClient, configFile);
        }
    }

    private void readJson(boolean isClient, File configFile) {
        try {
            String name = configFile.getName().replace(".json", "").toLowerCase();
            WeatherEvent decodedValue = ((WeatherEvent)((Pair)WeatherEvent.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(configFile))).resultOrPartial(arg_0 -> ((Logger)BetterWeather.LOGGER).error(arg_0)).get()).getFirst()).setName(name);
            if (isClient && !BetterWeather.CLIENT_CONFIG.useServerClientSettings) {
                if (this.weatherEvents.containsKey(name)) {
                    WeatherEvent weatherEvent = this.weatherEvents.get(name);
                    weatherEvent.setClientSettings(decodedValue.getClientSettings());
                    weatherEvent.setClient(weatherEvent.getClientSettings().createClientSettings());
                }
            } else {
                this.weatherEvents.put(name, decodedValue);
            }
        }
        catch (FileNotFoundException e) {
            BetterWeather.LOGGER.error(e.toString());
        }
    }

    private void readToml(boolean isClient, File configFile) {
        CommentedConfig readConfig;
        CommentedConfig commentedConfig = readConfig = configFile.exists() ? (CommentedConfig)CommentedFileConfig.builder((File)configFile).sync().autosave().writingMode(WritingMode.REPLACE).build() : CommentedConfig.inMemory();
        if (readConfig instanceof CommentedFileConfig) {
            ((CommentedFileConfig)readConfig).load();
        }
        String name = configFile.getName().replace(".toml", "").toLowerCase();
        WeatherEvent decodedValue = ((WeatherEvent)((Pair)WeatherEvent.CODEC.decode((DynamicOps)TomlCommentedConfigOps.INSTANCE, (Object)readConfig).resultOrPartial(arg_0 -> ((Logger)BetterWeather.LOGGER).error(arg_0)).get()).getFirst()).setName(name);
        if (isClient && !BetterWeather.CLIENT_CONFIG.useServerClientSettings) {
            if (this.weatherEvents.containsKey(name)) {
                WeatherEvent weatherEvent = this.weatherEvents.get(name);
                weatherEvent.setClientSettings(decodedValue.getClientSettings());
                weatherEvent.setClient(weatherEvent.getClientSettings().createClientSettings());
            }
        } else {
            this.weatherEvents.put(name, decodedValue);
        }
    }

    private void createTomlEventConfig(WeatherEvent weatherEvent, String weatherEventID) {
        CommentedConfig readConfig;
        Path configFile = this.weatherEventsConfigPath.resolve(weatherEventID.replace(":", "-") + ".toml");
        CommentedConfig commentedConfig = readConfig = configFile.toFile().exists() ? (CommentedConfig)CommentedFileConfig.builder((Path)configFile).sync().autosave().writingMode(WritingMode.REPLACE).build() : CommentedConfig.inMemory();
        if (readConfig instanceof CommentedFileConfig) {
            ((CommentedFileConfig)readConfig).load();
        }
        CommentedConfig encodedConfig = (CommentedConfig)WeatherEvent.CODEC.encodeStart(weatherEvent.configOps(), (Object)weatherEvent).result().get();
        try {
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            new TomlWriter().write((UnmodifiableConfig)(configFile.toFile().exists() ? TomlCommentedConfigOps.recursivelyUpdateAndSortConfig(readConfig, encodedConfig) : encodedConfig), configFile, WritingMode.REPLACE);
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error(e.toString());
        }
    }

    private void createJsonEventConfig(WeatherEvent weatherEvent, String weatherEventID) {
        Path configFile = this.weatherEventsConfigPath.resolve(weatherEventID.replace(":", "-") + ".json");
        JsonElement jsonElement = (JsonElement)WeatherEvent.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)weatherEvent).result().get();
        try {
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            Files.write(configFile, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(jsonElement).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error(e.toString());
        }
    }

    public void createDefaultEventConfigs() {
        for (Map.Entry<ResourceLocation, WeatherEvent> entry : BetterWeatherRegistry.DEFAULT_EVENTS.entrySet()) {
            ResourceLocation location = entry.getKey();
            WeatherEvent event = entry.getValue();
            Optional optionalKey = BetterWeatherRegistry.WEATHER_EVENT.func_230519_c_(event.codec());
            if (optionalKey.isPresent()) {
                if (BetterWeatherConfig.SERIALIZE_AS_JSON) {
                    this.createJsonEventConfig(event, location.toString());
                    continue;
                }
                this.createTomlEventConfig(event, location.toString());
                continue;
            }
            throw new IllegalStateException("Weather Event Key for codec not there when requested: " + event.getClass().getSimpleName());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addSettingsIfMissing() {
        for (Map.Entry<String, WeatherEvent> entry : this.weatherEvents.entrySet()) {
            WeatherEvent event = entry.getValue();
            String key = entry.getKey();
            File tomlFile = this.weatherEventsConfigPath.resolve(key + ".toml").toFile();
            File jsonFile = this.weatherEventsConfigPath.resolve(key + ".json").toFile();
            Optional optionalKey = BetterWeatherRegistry.WEATHER_EVENT.func_230519_c_(event.codec());
            if (optionalKey.isPresent()) {
                if (tomlFile.exists() || jsonFile.exists()) continue;
                if (BetterWeatherConfig.SERIALIZE_AS_JSON) {
                    this.createJsonEventConfig(event, key);
                    continue;
                }
                this.createTomlEventConfig(event, key);
                continue;
            }
            throw new IllegalStateException("Weather Event Key for codec not there when requested: " + event.getClass().getSimpleName());
        }
    }

    public void setCurrentEvent(WeatherEvent currentEvent) {
        this.currentEvent = currentEvent;
    }

    public void setCurrentEvent(String currentEvent) {
        this.currentEvent = this.weatherEvents.get(currentEvent);
    }

    public void setWeatherForced(boolean weatherForced) {
        this.weatherForced = weatherForced;
    }

    public WeatherEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public Map<String, WeatherEvent> getWeatherEvents() {
        return this.weatherEvents;
    }

    public boolean isWeatherForced() {
        return this.weatherForced;
    }

    @Override
    public boolean isLocalizedWeather() {
        return false;
    }

    @Override
    public String getCurrentWeatherEventKey() {
        return this.currentEvent.getName();
    }

    @Override
    public WeatherEventSettings getCurrentWeatherEventSettings() {
        return this.currentEvent;
    }

    public boolean isRefreshRenderers() {
        return this.refreshRenderers;
    }

    @OnlyIn(value=Dist.CLIENT)
    public WeatherEventClient<?> getCurrentClientEvent() {
        return this.currentEvent.getClient();
    }

    private static class WeatherEventConfig {
        public static final WeatherEventConfig DEFAULT = new WeatherEventConfig(true);
        public static Codec<WeatherEventConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("changeBiomeColors").forGetter(weatherEventConfig -> weatherEventConfig.changeBiomeColors)).apply((Applicative)builder, WeatherEventConfig::new));
        private final boolean changeBiomeColors;

        private WeatherEventConfig(boolean changeBiomeColors) {
            this.changeBiomeColors = changeBiomeColors;
        }
    }
}

