/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weather.event;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.api.weather.WeatherEvent;
import corgitaco.betterweather.api.weather.WeatherEventClientSettings;
import corgitaco.betterweather.util.BetterWeatherUtil;
import corgitaco.betterweather.util.TomlCommentedConfigOps;
import corgitaco.betterweather.weather.event.Blizzard;
import corgitaco.betterweather.weather.event.Rain;
import corgitaco.betterweather.weather.event.client.settings.RainClientSettings;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class AcidRain
extends Rain {
    public static final Codec<AcidRain> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)WeatherEventClientSettings.CODEC.fieldOf("clientSettings").forGetter(rain -> rain.getClientSettings()), (App)Codec.STRING.fieldOf("biomeCondition").forGetter(rain -> rain.getBiomeCondition()), (App)Codec.DOUBLE.fieldOf("defaultChance").forGetter(rain -> rain.getDefaultChance()), (App)Codec.DOUBLE.fieldOf("temperatureOffset").forGetter(rain -> rain.getTemperatureOffsetRaw()), (App)Codec.DOUBLE.fieldOf("humidityOffset").forGetter(rain -> rain.getHumidityOffsetRaw()), (App)Codec.INT.fieldOf("chunkTickChance").forGetter(blizzard -> blizzard.chunkTickChance), (App)Codec.INT.fieldOf("entityDamageChance").forGetter(blizzard -> blizzard.entityDamageChance), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)ResourceLocation.field_240908_a_).fieldOf("decayer").forGetter(rain -> BetterWeatherUtil.transformBlockBlocksToResourceLocations(rain.blockToBlock)), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT).fieldOf("entityDamage").forGetter(rain -> rain.entityDamageSerializable), (App)Codec.BOOL.fieldOf("isThundering").forGetter(rain -> rain.isThundering()), (App)Codec.INT.fieldOf("lightningChance").forGetter(rain -> rain.getLightningChance()), (App)Codec.simpleMap(Season.Key.CODEC, (Codec)Codec.unboundedMap(Season.Phase.CODEC, (Codec)Codec.DOUBLE), (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])Season.Key.values())).fieldOf("seasonChances").forGetter(rain -> rain.getSeasonChances())).apply((Applicative)builder, AcidRain::new));
    public static final Map<String, String> VALUE_COMMENTS = (Map)Util.func_200696_a(new HashMap<String, String>(WeatherEvent.VALUE_COMMENTS), map -> {
        map.putAll(RainClientSettings.VALUE_COMMENTS);
        map.put("entityDamageChance", "The chance of an entity getting damaged every tick when acid rain is on the player's position.");
        map.put("decayer", "What the specified block(left) \"decays\" into(right).");
        map.put("entityDamage", "Entity/Category(left) damage strength(right).");
        map.put("chunkTickChance", "The chance of a chunk being ticked for this tick.");
    });
    public static final TomlCommentedConfigOps CONFIG_OPS = new TomlCommentedConfigOps(VALUE_COMMENTS, true);
    public static final ResourceLocation ACID_RAIN_LOCATION = new ResourceLocation("betterweather", "textures/environment/acid_rain.png");
    public static final IdentityHashMap<ResourceLocation, ResourceLocation> DEFAULT_DECAYER = (IdentityHashMap)Util.func_200696_a(new IdentityHashMap(), map -> {
        for (Block block : Registry.field_212618_g) {
            Material material = block.func_176223_P().func_185904_a();
            if (material != Material.field_151584_j && material != Material.field_151585_k) continue;
            map.put(Registry.field_212618_g.func_177774_c((Object)block), Registry.field_212618_g.func_177774_c((Object)Blocks.field_150350_a));
        }
        map.put(Registry.field_212618_g.func_177774_c((Object)Blocks.field_196658_i), Registry.field_212618_g.func_177774_c((Object)Blocks.field_150346_d));
        map.put(Registry.field_212618_g.func_177774_c((Object)Blocks.field_196661_l), Registry.field_212618_g.func_177774_c((Object)Blocks.field_150346_d));
        map.put(Registry.field_212618_g.func_177774_c((Object)Blocks.field_150391_bh), Registry.field_212618_g.func_177774_c((Object)Blocks.field_150346_d));
    });
    public static final HashMap<String, Float> DEFAULT_ENTITY_DAMAGE = (HashMap)Util.func_200696_a(new HashMap(), map -> {
        map.put("category/monster", Float.valueOf(0.5f));
        map.put("minecraft:player", Float.valueOf(0.5f));
    });
    public static final AcidRain DEFAULT = new AcidRain(new RainClientSettings(RAIN_COLORS, 0.0f, -1.0f, true, ACID_RAIN_LOCATION, SNOW_LOCATION), "!#DESERT#SAVANNA#NETHER#THEEND", 0.25, 0.0, 0.1, 150, 100, DEFAULT_DECAYER, DEFAULT_ENTITY_DAMAGE, false, 0, (Map)Util.func_200696_a(new EnumMap(Season.Key.class), seasons -> {
        seasons.put(Season.Key.SPRING, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.23);
            phases.put(Season.Phase.MID, 0.26);
            phases.put(Season.Phase.END, 0.16);
        }));
        seasons.put(Season.Key.SUMMER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.03);
            phases.put(Season.Phase.MID, 0.0);
            phases.put(Season.Phase.END, 0.0);
        }));
        seasons.put(Season.Key.AUTUMN, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.03);
            phases.put(Season.Phase.MID, 0.03);
            phases.put(Season.Phase.END, 0.03);
        }));
        seasons.put(Season.Key.WINTER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.03);
            phases.put(Season.Phase.MID, 0.03);
            phases.put(Season.Phase.END, 0.06);
        }));
    }));
    public static final AcidRain DEFAULT_THUNDERING = new AcidRain(new RainClientSettings(THUNDER_COLORS, 0.0f, -1.0f, true, ACID_RAIN_LOCATION, SNOW_LOCATION), "!#DESERT#SAVANNA#NETHER#THEEND", 0.125, 0.0, 0.1, 150, 100, DEFAULT_DECAYER, DEFAULT_ENTITY_DAMAGE, true, 100000, (Map)Util.func_200696_a(new EnumMap(Season.Key.class), seasons -> {
        seasons.put(Season.Key.SPRING, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.115);
            phases.put(Season.Phase.MID, 0.13);
            phases.put(Season.Phase.END, 0.08);
        }));
        seasons.put(Season.Key.SUMMER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.0115);
            phases.put(Season.Phase.MID, 0.0);
            phases.put(Season.Phase.END, 0.0);
        }));
        seasons.put(Season.Key.AUTUMN, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.0115);
            phases.put(Season.Phase.MID, 0.0115);
            phases.put(Season.Phase.END, 0.0115);
        }));
        seasons.put(Season.Key.WINTER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.0115);
            phases.put(Season.Phase.MID, 0.0115);
            phases.put(Season.Phase.END, 0.03);
        }));
    }));
    private final int chunkTickChance;
    private final int entityDamageChance;
    private final IdentityHashMap<Block, Block> blockToBlock;
    private final Map<String, Float> entityDamageSerializable;
    private final Object2FloatArrayMap<EntityType<?>> entityDamage = new Object2FloatArrayMap();

    public AcidRain(WeatherEventClientSettings clientSettings, String biomeCondition, double defaultChance, double temperatureOffsetRaw, double humidityOffsetRaw, int chunkTickChance, int entityDamageChance, Map<ResourceLocation, ResourceLocation> blockToBlock, Map<String, Float> entityDamage, boolean isThundering, int lightningChance, Map<Season.Key, Map<Season.Phase, Double>> seasonChance) {
        super(clientSettings, biomeCondition, defaultChance, temperatureOffsetRaw, humidityOffsetRaw, isThundering, lightningChance, seasonChance);
        this.chunkTickChance = chunkTickChance;
        this.entityDamageChance = entityDamageChance;
        this.blockToBlock = BetterWeatherUtil.transformBlockBlockResourceLocations(blockToBlock);
        this.entityDamageSerializable = entityDamage;
        for (Map.Entry<String, Float> entry : entityDamage.entrySet()) {
            String key = entry.getKey();
            float value = entry.getValue().floatValue();
            if (key.startsWith("category/")) {
                String mobCategory = key.substring("category/".length()).toUpperCase();
                Object[] values = EntityClassification.values();
                if (Arrays.stream(values).noneMatch(difficulty -> difficulty.toString().equals(mobCategory))) {
                    BetterWeather.LOGGER.error("\"" + mobCategory + "\" is not a valid mob category value. Skipping mob category entry...\nValid Mob Categories: " + Arrays.toString(values));
                    continue;
                }
                for (EntityType<?> entityType : Blizzard.CLASSIFICATION_ENTITY_TYPES.get(EntityClassification.valueOf((String)mobCategory))) {
                    this.entityDamage.put(entityType, value);
                }
                continue;
            }
            ResourceLocation entityTypeID = Blizzard.tryParse(key.toLowerCase());
            if (entityTypeID != null && !Registry.field_212629_r.func_148742_b().contains(entityTypeID)) {
                BetterWeather.LOGGER.error("\"" + key + "\" is not a valid entity ID. Skipping entry...");
                continue;
            }
            this.entityDamage.put(Registry.field_212629_r.func_241873_b(entityTypeID).get(), value);
        }
    }

    @Override
    public void chunkTick(Chunk chunk, ServerWorld world) {
        super.chunkTick(chunk, world);
        if (this.chunkTickChance < 1) {
            return;
        }
        if (world.field_73012_v.nextInt(this.chunkTickChance) == 0) {
            ChunkPos chunkpos = chunk.func_76632_l();
            int xStart = chunkpos.func_180334_c();
            int zStart = chunkpos.func_180333_d();
            BlockPos randomPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(xStart, 0, zStart, 15));
            BlockPos randomPosDown = randomPos.func_177977_b();
            Biome biome = world.func_226691_t_(randomPos);
            if (this.isValidBiome(biome) && !biome.func_201850_b((IWorldReader)world, randomPos)) {
                Block currentBlock = world.func_180495_p(randomPos).func_177230_c();
                Block currentBlockDown = world.func_180495_p(randomPosDown).func_177230_c();
                if (this.blockToBlock.containsKey(currentBlock)) {
                    world.func_175656_a(randomPos, this.blockToBlock.get(currentBlock).func_176223_P());
                }
                if (this.blockToBlock.containsKey(currentBlockDown)) {
                    world.func_175656_a(randomPosDown, this.blockToBlock.get(currentBlockDown).func_176223_P());
                }
            }
        }
    }

    @Override
    public void livingEntityUpdate(LivingEntity entity) {
        if (this.chunkTickChance < 1) {
            return;
        }
        World world = entity.field_70170_p;
        if (world.field_73012_v.nextInt(this.entityDamageChance) == 0) {
            BlockPos entityPosition = entity.func_233580_cy_();
            Biome biome = world.func_226691_t_(entityPosition);
            if (world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, entityPosition.func_177958_n(), entityPosition.func_177952_p()) > entityPosition.func_177956_o() || !this.isValidBiome(biome) || biome.func_201850_b((IWorldReader)world, entityPosition)) {
                return;
            }
            if (this.entityDamage.containsKey((Object)entity.func_200600_R())) {
                entity.func_70097_a(DamageSource.field_76377_j, this.entityDamage.getFloat((Object)entity.func_200600_R()));
            }
        }
    }

    @Override
    public Codec<? extends WeatherEvent> codec() {
        return CODEC;
    }

    @Override
    public DynamicOps<?> configOps() {
        return CONFIG_OPS;
    }
}

