/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weather.event;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.client.ColorSettings;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.api.weather.WeatherEvent;
import corgitaco.betterweather.api.weather.WeatherEventClientSettings;
import corgitaco.betterweather.core.SoundRegistry;
import corgitaco.betterweather.util.TomlCommentedConfigOps;
import corgitaco.betterweather.weather.event.Rain;
import corgitaco.betterweather.weather.event.client.settings.BlizzardClientSettings;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class Blizzard
extends WeatherEvent {
    public static final Codec<Blizzard> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)WeatherEventClientSettings.CODEC.fieldOf("clientSettings").forGetter(blizzard -> blizzard.getClientSettings()), (App)Codec.STRING.fieldOf("biomeCondition").forGetter(blizzard -> blizzard.getBiomeCondition()), (App)Codec.DOUBLE.fieldOf("temperatureOffset").forGetter(blizzard -> blizzard.getTemperatureOffsetRaw()), (App)Codec.DOUBLE.fieldOf("humidityOffset").forGetter(blizzard -> blizzard.getHumidityOffsetRaw()), (App)Codec.DOUBLE.fieldOf("defaultChance").forGetter(blizzard -> blizzard.getDefaultChance()), (App)Codec.INT.fieldOf("blockLightThreshold").forGetter(blizzard -> blizzard.blockLightThreshold), (App)Codec.INT.fieldOf("chunkTickChance").forGetter(blizzard -> blizzard.chunkTickChance), (App)ResourceLocation.field_240908_a_.fieldOf("snowBlock").forGetter(blizzard -> Registry.field_212618_g.func_177774_c((Object)blizzard.snowBlock)), (App)Codec.BOOL.fieldOf("snowLayering").forGetter(blizzard -> blizzard.snowLayers), (App)Codec.BOOL.fieldOf("waterFreezes").forGetter(blizzard -> blizzard.waterFreezes), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.list((Codec)Codec.STRING)).fieldOf("entityEffects").forGetter(blizzard -> blizzard.entityOrCategoryToEffectsMap), (App)Codec.BOOL.fieldOf("isThundering").forGetter(rain -> rain.isThundering()), (App)Codec.INT.fieldOf("lightningChance").forGetter(rain -> rain.getLightningChance()), (App)Codec.simpleMap(Season.Key.CODEC, (Codec)Codec.unboundedMap(Season.Phase.CODEC, (Codec)Codec.DOUBLE), (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])Season.Key.values())).fieldOf("seasonChances").forGetter(blizzard -> blizzard.getSeasonChances())).apply((Applicative)builder, (clientSettings, biomeCondition, temperatureOffsetRaw, humidityOffsetRaw, defaultChance, tickRate, blockLightThreshold, snowBlockID, snowLayers, waterFreezes, entityOrCategoryToEffectsMap, isThundering, lightningChance, map) -> {
        Optional blockOptional = Registry.field_212618_g.func_241873_b(snowBlockID);
        if (!blockOptional.isPresent()) {
            BetterWeather.LOGGER.error("\"" + snowBlockID.toString() + "\" is not a valid block ID in the registry, defaulting to \"minecraft:snow\"...");
        }
        return new Blizzard((WeatherEventClientSettings)clientSettings, (String)biomeCondition, (double)defaultChance, (double)temperatureOffsetRaw, (double)humidityOffsetRaw, (int)tickRate, (int)blockLightThreshold, blockOptional.orElse(Blocks.field_150433_aE), (boolean)snowLayers, (boolean)waterFreezes, (Map<String, List<String>>)entityOrCategoryToEffectsMap, (boolean)isThundering, (int)lightningChance, (Map<Season.Key, Map<Season.Phase, Double>>)map);
    }));
    public static final Map<String, String> VALUE_COMMENTS = (Map)Util.func_200696_a(new HashMap<String, String>(WeatherEvent.VALUE_COMMENTS), map -> {
        map.putAll(BlizzardClientSettings.VALUE_COMMENTS);
        map.put("blockLightThreshold", "The max sky brightness to allow snow to generate.");
        map.put("snowBlock", "What block generates when chunks are ticking? If this block has the layers property & \"snowLayering\" is true, this block will layer.");
        map.put("snowLayering", "Does the \"snowBlock\" layer when chunks are ticking? Only works if the\"snowBlock\" has a layers property!");
        map.put("waterFreezes", "Does water freeze?");
        map.put("entityEffects", "Entity/Category(left) effect(s)(right).");
        map.put("chunkTickChance", "The chance of a chunk being ticked for this tick.");
    });
    public static final TomlCommentedConfigOps CONFIG_OPS = new TomlCommentedConfigOps(VALUE_COMMENTS, true);
    public static final Blizzard DEFAULT = new Blizzard(new BlizzardClientSettings(new ColorSettings(Integer.MAX_VALUE, 0.0, Integer.MAX_VALUE, 0.0), 0.0f, 0.2f, false, Rain.SNOW_LOCATION, SoundRegistry.BLIZZARD_LOOP2, 0.6f, 0.6f), "!#DESERT#SAVANNA#NETHER#THEEND", 0.1, 0.0, 0.1, 2, 10, Blocks.field_150433_aE, true, true, (Map)Util.func_200696_a(new HashMap(), stringListHashMap -> {
        List cfr_ignored_0 = (List)stringListHashMap.put(Registry.field_212629_r.func_177774_c((Object)EntityType.field_200729_aH).toString(), ImmutableList.of((Object)Registry.field_212631_t.func_177774_c((Object)Effects.field_76421_d).toString()));
    }), false, 0, (Map)Util.func_200696_a(new EnumMap(Season.Key.class), seasons -> {
        seasons.put(Season.Key.SPRING, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.1);
            phases.put(Season.Phase.MID, 0.01);
            phases.put(Season.Phase.END, 0.0);
        }));
        seasons.put(Season.Key.SUMMER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.0);
            phases.put(Season.Phase.MID, 0.0);
            phases.put(Season.Phase.END, 0.0);
        }));
        seasons.put(Season.Key.AUTUMN, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.0);
            phases.put(Season.Phase.MID, 0.01);
            phases.put(Season.Phase.END, 0.1);
        }));
        seasons.put(Season.Key.WINTER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.3);
            phases.put(Season.Phase.MID, 0.5);
            phases.put(Season.Phase.END, 0.45);
        }));
    }));
    public static final Blizzard DEFAULT_THUNDERING = new Blizzard(new BlizzardClientSettings(new ColorSettings(Integer.MAX_VALUE, 0.0, Integer.MAX_VALUE, 0.0), 0.0f, 0.2f, false, Rain.SNOW_LOCATION, SoundRegistry.BLIZZARD_LOOP2, 0.6f, 0.6f), "!#DESERT#SAVANNA#NETHER#THEEND", 0.05, 0.0, 0.1, 2, 10, Blocks.field_150433_aE, true, true, (Map)Util.func_200696_a(new HashMap(), stringListHashMap -> {
        List cfr_ignored_0 = (List)stringListHashMap.put(Registry.field_212629_r.func_177774_c((Object)EntityType.field_200729_aH).toString(), ImmutableList.of((Object)Registry.field_212631_t.func_177774_c((Object)Effects.field_76421_d).toString()));
    }), true, 100000, (Map)Util.func_200696_a(new EnumMap(Season.Key.class), seasons -> {
        seasons.put(Season.Key.SPRING, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.05);
            phases.put(Season.Phase.MID, 0.005);
            phases.put(Season.Phase.END, 0.0);
        }));
        seasons.put(Season.Key.SUMMER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.0);
            phases.put(Season.Phase.MID, 0.0);
            phases.put(Season.Phase.END, 0.0);
        }));
        seasons.put(Season.Key.AUTUMN, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.0);
            phases.put(Season.Phase.MID, 0.005);
            phases.put(Season.Phase.END, 0.05);
        }));
        seasons.put(Season.Key.WINTER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.15);
            phases.put(Season.Phase.MID, 0.25);
            phases.put(Season.Phase.END, 0.225);
        }));
    }));
    public static final Map<EntityClassification, List<EntityType<?>>> CLASSIFICATION_ENTITY_TYPES = (Map)Util.func_200696_a(new EnumMap(EntityClassification.class), map -> {
        for (EntityType entityType : Registry.field_212629_r) {
            map.computeIfAbsent(entityType.func_220339_d(), mobCategory -> new ArrayList()).add(entityType);
        }
    });
    private final int chunkTickChance;
    private final int blockLightThreshold;
    private final Block snowBlock;
    private final boolean snowLayers;
    private final boolean waterFreezes;
    private final Map<String, List<String>> entityOrCategoryToEffectsMap;
    private final Map<EntityType<?>, List<EffectInstance>> entityTypeToEffectMap = new Reference2ReferenceArrayMap();

    public Blizzard(WeatherEventClientSettings clientSettings, String biomeCondition, double defaultChance, double temperatureOffsetRaw, double humidityOffsetRaw, int chunkTickChance, int blockLightThreshold, Block snowBlock, boolean snowLayers, boolean waterFreezes, Map<String, List<String>> entityOrCategoryToEffectsMap, boolean isThundering, int lightningChance, Map<Season.Key, Map<Season.Phase, Double>> map) {
        super(clientSettings, biomeCondition, defaultChance, temperatureOffsetRaw, humidityOffsetRaw, isThundering, lightningChance, map);
        this.chunkTickChance = chunkTickChance;
        this.blockLightThreshold = blockLightThreshold;
        this.snowBlock = snowBlock;
        this.snowLayers = snowLayers;
        this.waterFreezes = waterFreezes;
        this.entityOrCategoryToEffectsMap = entityOrCategoryToEffectsMap;
        for (Map.Entry<String, List<String>> entry : entityOrCategoryToEffectsMap.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            if (key.startsWith("category/")) {
                String mobCategory = key.substring("category/".length()).toUpperCase();
                Object[] values = EntityClassification.values();
                if (Arrays.stream(values).noneMatch(difficulty -> difficulty.toString().equals(mobCategory))) {
                    BetterWeather.LOGGER.error("\"" + mobCategory + "\" is not a valid mob category value. Skipping mob category entry...\nValid Mob Categories: " + Arrays.toString(values));
                    continue;
                }
                for (EntityType<?> entityType : CLASSIFICATION_ENTITY_TYPES.get(EntityClassification.valueOf((String)mobCategory))) {
                    this.addEntry(value, entityType);
                }
                continue;
            }
            ResourceLocation entityTypeID = Blizzard.tryParse(key.toLowerCase());
            if (entityTypeID != null && !Registry.field_212629_r.func_148742_b().contains(entityTypeID)) {
                BetterWeather.LOGGER.error("\"" + key + "\" is not a valid entity ID. Skipping entry...");
                continue;
            }
            this.addEntry(value, (EntityType)Registry.field_212629_r.func_241873_b(entityTypeID).get());
        }
    }

    private void addEntry(List<String> value, EntityType<?> entityType) {
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        for (String effectArguments : value) {
            EffectInstance effectInstanceFromString = Blizzard.createEffectInstanceFromString(effectArguments);
            if (effectInstanceFromString == null) continue;
            effects.add(effectInstanceFromString);
        }
        this.entityTypeToEffectMap.put(entityType, effects);
    }

    @Override
    public void worldTick(ServerWorld world, int tickSpeed, long worldTime) {
    }

    @Override
    public void chunkTick(Chunk chunk, ServerWorld world) {
        if (this.chunkTickChance < 1) {
            return;
        }
        if (world.field_73012_v.nextInt(this.chunkTickChance) == 0) {
            int currentLayer;
            ChunkPos chunkpos = chunk.func_76632_l();
            int xStart = chunkpos.func_180334_c();
            int zStart = chunkpos.func_180333_d();
            BlockPos randomHeightMapPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(xStart, 0, zStart, 15));
            BlockPos randomPosDown = randomHeightMapPos.func_177977_b();
            BlockState blockState = world.func_180495_p(randomHeightMapPos);
            Biome biome = world.func_226691_t_(randomHeightMapPos);
            if (!this.isValidBiome(biome)) {
                return;
            }
            if (this.waterFreezes && biome.func_201848_a((IWorldReader)world, randomPosDown)) {
                world.func_175656_a(randomPosDown, Blocks.field_150432_aD.func_176223_P());
            }
            if (this.meetsStateRequirements((IWorldReader)world, randomHeightMapPos)) {
                world.func_175656_a(randomHeightMapPos, this.snowBlock.func_176223_P());
                return;
            }
            if (this.snowLayers && this.meetsLayeringRequirement((IWorldReader)world, randomHeightMapPos) && (currentLayer = ((Integer)blockState.func_177229_b((Property)BlockStateProperties.field_208129_ad)).intValue()) < 7) {
                world.func_180501_a(randomHeightMapPos, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(currentLayer + 1)), 2);
            }
        }
    }

    private boolean meetsStateRequirements(IWorldReader worldIn, BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < worldIn.func_217301_I() && worldIn.func_226658_a_(LightType.BLOCK, pos) < this.blockLightThreshold) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            BlockState defaultState = this.snowBlock.func_176223_P();
            return blockstate.isAir((IBlockReader)worldIn, pos) && defaultState.func_196955_c(worldIn, pos);
        }
        return false;
    }

    private boolean meetsLayeringRequirement(IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        BlockState defaultState = this.snowBlock.func_176223_P();
        return defaultState.func_235901_b_((Property)BlockStateProperties.field_208129_ad) && this.snowLayers && blockstate.func_177230_c() == this.snowBlock;
    }

    @Override
    public boolean spawnSnowInFreezingClimates() {
        return true;
    }

    @Override
    public void livingEntityUpdate(LivingEntity entity) {
    }

    @Override
    public Codec<? extends WeatherEvent> codec() {
        return CODEC;
    }

    @Override
    public DynamicOps<?> configOps() {
        return CONFIG_OPS;
    }

    @Override
    public double getTemperatureModifierAtPosition(BlockPos pos) {
        return this.getTemperatureOffsetRaw();
    }

    @Override
    public double getHumidityModifierAtPosition(BlockPos pos) {
        return this.getHumidityOffsetRaw();
    }

    @Nullable
    private static EffectInstance createEffectInstanceFromString(String effectString) {
        String[] split = effectString.split("(?=[\\$])");
        Effect effect = null;
        int amplifier = 4;
        for (int i = 0; i < split.length; ++i) {
            String variable = split[i];
            if (i != 0) continue;
            if (!variable.startsWith("$") && !variable.startsWith("#")) {
                ResourceLocation resourceLocation = Blizzard.tryParse(variable);
                if (resourceLocation != null) {
                    if (Registry.field_212631_t.func_148742_b().contains(resourceLocation)) {
                        effect = (Effect)Registry.field_212631_t.func_241873_b(resourceLocation).get();
                        continue;
                    }
                    return null;
                }
                return null;
            }
            if (!variable.startsWith("$")) continue;
            String substring = variable.substring(1);
            try {
                if (substring.isEmpty()) continue;
                amplifier = Integer.getInteger(substring);
                continue;
            }
            catch (NumberFormatException e) {
                BetterWeather.LOGGER.error("Not a number: " + substring);
            }
        }
        return effect != null ? new EffectInstance(effect, 5, amplifier, true, false, false) : null;
    }

    @Nullable
    public static ResourceLocation tryParse(String id) {
        try {
            return new ResourceLocation(id);
        }
        catch (ResourceLocationException resourcelocationexception) {
            BetterWeather.LOGGER.error(resourcelocationexception.getMessage());
            return null;
        }
    }
}

