/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weather.event;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.api.client.ColorSettings;
import corgitaco.betterweather.api.season.Season;
import corgitaco.betterweather.api.weather.WeatherEvent;
import corgitaco.betterweather.api.weather.WeatherEventClientSettings;
import corgitaco.betterweather.util.TomlCommentedConfigOps;
import corgitaco.betterweather.util.client.ColorUtil;
import corgitaco.betterweather.weather.event.client.settings.RainClientSettings;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class Rain
extends WeatherEvent {
    public static final Codec<Rain> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)WeatherEventClientSettings.CODEC.fieldOf("clientSettings").forGetter(rain -> rain.getClientSettings()), (App)Codec.STRING.fieldOf("biomeCondition").forGetter(rain -> rain.getBiomeCondition()), (App)Codec.DOUBLE.fieldOf("defaultChance").forGetter(rain -> rain.getDefaultChance()), (App)Codec.DOUBLE.fieldOf("temperatureOffset").forGetter(rain -> rain.getTemperatureOffsetRaw()), (App)Codec.DOUBLE.fieldOf("humidityOffset").forGetter(rain -> rain.getHumidityOffsetRaw()), (App)Codec.BOOL.fieldOf("isThundering").forGetter(rain -> rain.isThundering()), (App)Codec.INT.fieldOf("lightningChance").forGetter(rain -> rain.getLightningChance()), (App)Codec.simpleMap(Season.Key.CODEC, (Codec)Codec.unboundedMap(Season.Phase.CODEC, (Codec)Codec.DOUBLE), (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])Season.Key.values())).fieldOf("seasonChances").forGetter(rain -> rain.getSeasonChances())).apply((Applicative)builder, Rain::new));
    public static final Map<String, String> VALUE_COMMENTS = (Map)Util.func_200696_a(new HashMap<String, String>(WeatherEvent.VALUE_COMMENTS), map -> {
        map.put("defaultChance", "What is the default chance for this weather event to occur? This value is only used when Seasons are NOT present in the given dimension.");
        map.put("type", "Target Weather Event's Registry ID to configure settings for in this config.");
        map.put("seasonChances", "What is the chance for this weather event to occur for the given season (phase)?");
        map.put("biomeCondition", "Better Weather uses a prefix system for what biomes weather is allowed to function in.\n Prefix Guide:\n \"#\" - Biome category representable.\n \"$\" - Biome dictionary representable.\n \",\" - Creates a new condition, separate from the previous.\n \"ALL\" - Spawn in all biomes(no condition).\n \"!\" - Negates/flips/does the reverse of the condition.\n \"\" - No prefix serves as a biome ID OR Mod ID representable.\n\n Here are a few examples:\n1. \"byg#THE_END, $OCEAN\" would mean that the ore may spawn in biomes with the name space \"byg\" AND in the \"END\" biome category, OR all biomes in the \"OCEAN\" dictionary.\n2. \"byg:guiana_shield, #MESA\" would mean that the ore may spawn in the \"byg:guiana_shield\" OR all biomes in the \"MESA\" category.\n3. \"byg#ICY$MOUNTAIN\" would mean that the ore may only spawn in biomes from byg in the \"ICY\" category and \"MOUNTAIN\" dictionary type.\n4. \"!byg#DESERT\" would mean that the ore may only spawn in biomes that are NOT from byg and NOT in the \"DESERT\" category.\n5. \"ALL\", spawn everywhere. \n6. \"\" Don't spawn anywhere.");
    });
    public static final TomlCommentedConfigOps CONFIG_OPS = new TomlCommentedConfigOps(VALUE_COMMENTS, true);
    public static final ResourceLocation RAIN_LOCATION = new ResourceLocation("minecraft:textures/environment/rain.png");
    public static final ResourceLocation SNOW_LOCATION = new ResourceLocation("minecraft:textures/environment/snow.png");
    public static final ColorSettings THUNDER_COLORS = new ColorSettings(Integer.MAX_VALUE, 0.1, Integer.MAX_VALUE, 0.0, ColorUtil.DEFAULT_THUNDER_SKY, 1.0, ColorUtil.DEFAULT_THUNDER_FOG, 1.0, ColorUtil.DEFAULT_THUNDER_CLOUDS, 1.0);
    public static final ColorSettings RAIN_COLORS = new ColorSettings(Integer.MAX_VALUE, 0.1, Integer.MAX_VALUE, 0.0, ColorUtil.DEFAULT_RAIN_SKY, 1.0, ColorUtil.DEFAULT_RAIN_FOG, 1.0, ColorUtil.DEFAULT_RAIN_CLOUDS, 1.0);
    public static final String DEFAULT_BIOME_CONDITION = "!#DESERT#SAVANNA#NETHER#THEEND";
    public static final Rain DEFAULT = new Rain(new RainClientSettings(RAIN_COLORS, 0.0f, -1.0f, true, RAIN_LOCATION, SNOW_LOCATION), "!#DESERT#SAVANNA#NETHER#THEEND", 0.7, 0.0, 0.1, false, 0, (Map)Util.func_200696_a(new EnumMap(Season.Key.class), seasons -> {
        seasons.put(Season.Key.SPRING, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.7);
            phases.put(Season.Phase.MID, 0.8);
            phases.put(Season.Phase.END, 0.5);
        }));
        seasons.put(Season.Key.SUMMER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.1);
            phases.put(Season.Phase.MID, 0.0);
            phases.put(Season.Phase.END, 0.0);
        }));
        seasons.put(Season.Key.AUTUMN, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.1);
            phases.put(Season.Phase.MID, 0.1);
            phases.put(Season.Phase.END, 0.1);
        }));
        seasons.put(Season.Key.WINTER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.1);
            phases.put(Season.Phase.MID, 0.1);
            phases.put(Season.Phase.END, 0.2);
        }));
    }));
    public static final Rain DEFAULT_THUNDERING = new Rain(new RainClientSettings(THUNDER_COLORS, 0.0f, -1.0f, true, RAIN_LOCATION, SNOW_LOCATION), "!#DESERT#SAVANNA#NETHER#THEEND", 0.3, 0.0, 0.1, true, 100000, (Map)Util.func_200696_a(new EnumMap(Season.Key.class), seasons -> {
        seasons.put(Season.Key.SPRING, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.35);
            phases.put(Season.Phase.MID, 0.4);
            phases.put(Season.Phase.END, 0.25);
        }));
        seasons.put(Season.Key.SUMMER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.05);
            phases.put(Season.Phase.MID, 0.0);
            phases.put(Season.Phase.END, 0.0);
        }));
        seasons.put(Season.Key.AUTUMN, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.05);
            phases.put(Season.Phase.MID, 0.05);
            phases.put(Season.Phase.END, 0.05);
        }));
        seasons.put(Season.Key.WINTER, Util.func_200696_a(new EnumMap(Season.Phase.class), phases -> {
            phases.put(Season.Phase.START, 0.05);
            phases.put(Season.Phase.MID, 0.05);
            phases.put(Season.Phase.END, 0.1);
        }));
    }));

    public Rain(WeatherEventClientSettings clientSettings, String biomeCondition, double defaultChance, double temperatureOffsetRaw, double humidityOffsetRaw, boolean isThundering, int lightningFrequency, Map<Season.Key, Map<Season.Phase, Double>> seasonChance) {
        super(clientSettings, biomeCondition, defaultChance, temperatureOffsetRaw, humidityOffsetRaw, isThundering, lightningFrequency, seasonChance);
    }

    @Override
    public void worldTick(ServerWorld world, int tickSpeed, long worldTime) {
    }

    @Override
    public void chunkTick(Chunk chunk, ServerWorld world) {
        if (world.field_73012_v.nextInt(16) == 0) {
            ChunkPos chunkpos = chunk.func_76632_l();
            int xStart = chunkpos.func_180334_c();
            int zStart = chunkpos.func_180333_d();
            BlockPos randomPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(xStart, 0, zStart, 15));
            BlockPos randomPosDown = randomPos.func_177977_b();
            Biome biome = world.func_226691_t_(randomPos);
            if (this.isValidBiome(biome)) {
                if (this.spawnSnowInFreezingClimates() && biome.func_201848_a((IWorldReader)world, randomPosDown)) {
                    world.func_175656_a(randomPosDown, Blocks.field_150432_aD.func_176223_P());
                }
                if (this.spawnSnowInFreezingClimates() && biome.func_201850_b((IWorldReader)world, randomPos)) {
                    world.func_175656_a(randomPos, Blocks.field_150433_aE.func_176223_P());
                }
                if (world.func_175727_C(randomPos.func_177981_b(25)) && this.fillBlocksWithWater()) {
                    world.func_180495_p(randomPosDown).func_177230_c().func_176224_k((World)world, randomPosDown);
                }
            }
        }
    }

    @Override
    public Codec<? extends WeatherEvent> codec() {
        return CODEC;
    }

    @Override
    public DynamicOps<?> configOps() {
        return CONFIG_OPS;
    }

    @Override
    public double getTemperatureModifierAtPosition(BlockPos pos) {
        return this.getTemperatureOffsetRaw();
    }

    @Override
    public double getHumidityModifierAtPosition(BlockPos pos) {
        return this.getHumidityOffsetRaw();
    }
}

