/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weather.event.client;

import com.mojang.blaze3d.systems.RenderSystem;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.client.WeatherEventClient;
import corgitaco.betterweather.api.client.graphics.Graphics;
import corgitaco.betterweather.api.client.graphics.opengl.program.ShaderProgramBuilder;
import corgitaco.betterweather.api.weather.WeatherEventAudio;
import corgitaco.betterweather.weather.event.client.settings.BlizzardClientSettings;
import java.io.IOException;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;

public class BlizzardClient
extends WeatherEventClient<BlizzardClientSettings>
implements WeatherEventAudio {
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private final ResourceLocation textureLocation;
    private final SoundEvent audio;
    private final float audioVolume;
    private final float audioPitch;
    private final Consumer<ShaderProgramBuilder> builder;
    private final Matrix4f modelMatrix = new Matrix4f();

    public BlizzardClient(BlizzardClientSettings clientSettings) {
        super(clientSettings);
        this.textureLocation = clientSettings.textureLocation;
        this.audio = clientSettings.getSound();
        this.audioVolume = clientSettings.getVolume();
        this.audioPitch = clientSettings.getPitch();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainSizeX[i << 5 | j] = -f1 / f2;
                this.rainSizeZ[i << 5 | j] = f / f2;
            }
        }
        this.builder = builder1 -> {
            IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
            try {
                builder1.compile(35632, manager.func_199002_a(new ResourceLocation("betterweather", "shaders/fragment.glsl"))).compile(35633, manager.func_199002_a(new ResourceLocation("betterweather", "shaders/vertex.glsl")));
            }
            catch (IOException e) {
                BetterWeather.LOGGER.error((Object)e);
                builder1.clean();
            }
        };
    }

    @Override
    public boolean renderWeatherShaders(Graphics graphics, ClientWorld world, double x, double y, double z) {
        return true;
    }

    @Override
    public boolean renderWeatherLegacy(Minecraft mc, ClientWorld world, LightTexture lightTexture, int ticks, float partialTicks, double x, double y, double z, Predicate<Biome> biomePredicate) {
        float rainStrength = world.func_72867_j(partialTicks);
        lightTexture.func_205109_c();
        int floorX = MathHelper.func_76128_c((double)x);
        int floorY = MathHelper.func_76128_c((double)y);
        int floorZ = MathHelper.func_76128_c((double)z);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableCull();
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableDepthTest();
        int graphicsQuality = 5;
        if (Minecraft.func_71375_t()) {
            graphicsQuality = 10;
        }
        RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
        int i1 = -1;
        float ticksAndPartialTicks = (float)ticks + partialTicks;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int graphicQualityZ = floorZ - graphicsQuality; graphicQualityZ <= floorZ + graphicsQuality; ++graphicQualityZ) {
            for (int graphicQualityX = floorX - graphicsQuality; graphicQualityX <= floorX + graphicsQuality; ++graphicQualityX) {
                int rainSizeIdx = (graphicQualityZ - floorZ + 16) * 32 + graphicQualityX - floorX + 16;
                double rainSizeX = (double)this.rainSizeX[rainSizeIdx] * 0.5;
                double rainSizeZ = (double)this.rainSizeZ[rainSizeIdx] * 0.5;
                blockPos.func_181079_c(graphicQualityX, 0, graphicQualityZ);
                Biome biome = world.func_226691_t_((BlockPos)blockPos);
                int topPosY = mc.field_71441_e.func_201676_a(Heightmap.Type.MOTION_BLOCKING, blockPos.func_177958_n(), blockPos.func_177952_p());
                int floorYMinusGraphicsQuality = floorY - graphicsQuality;
                int floorYPlusGraphicsQuality = floorY + graphicsQuality;
                if (floorYMinusGraphicsQuality < topPosY) {
                    floorYMinusGraphicsQuality = topPosY;
                }
                if (floorYPlusGraphicsQuality < topPosY) {
                    floorYPlusGraphicsQuality = topPosY;
                }
                int posY2 = Math.max(topPosY, floorY);
                if (floorYMinusGraphicsQuality == floorYPlusGraphicsQuality) continue;
                Random random = new Random(graphicQualityX * graphicQualityX * 3121 + graphicQualityX * 45238971 ^ graphicQualityZ * graphicQualityZ * 418711 + graphicQualityZ * 13761);
                blockPos.func_181079_c(graphicQualityX, floorYMinusGraphicsQuality, graphicQualityZ);
                if (i1 != 1) {
                    if (i1 >= 0) {
                        tessellator.func_78381_a();
                    }
                    i1 = 1;
                    mc.func_110434_K().func_110577_a(this.textureLocation);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                }
                float f7 = (float)(random.nextDouble() + (double)(ticksAndPartialTicks * (float)random.nextGaussian()) * 0.03);
                float fallSpeed = (float)(random.nextDouble() + (double)(ticksAndPartialTicks * (float)random.nextGaussian()) * 0.03);
                double d3 = (double)((float)graphicQualityX + 0.5f) - x;
                double d5 = (double)((float)graphicQualityZ + 0.5f) - z;
                float f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / (float)graphicsQuality;
                float ticksAndPartialTicks0 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * rainStrength;
                blockPos.func_181079_c(graphicQualityX, posY2, graphicQualityZ);
                int k3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockPos);
                int l3 = k3 >> 16 & 0xFFFF;
                int i4 = (k3 & 0xFFFF) * 3;
                int j4 = (l3 * 3 + 240) / 4;
                int k4 = (i4 * 3 + 240) / 4;
                if (!biomePredicate.test(biome)) continue;
                bufferbuilder.func_225582_a_((double)graphicQualityX - x - rainSizeX + 0.5 + random.nextGaussian() * 2.0, (double)floorYPlusGraphicsQuality - y, (double)graphicQualityZ - z - rainSizeZ + 0.5 + random.nextGaussian()).func_225583_a_(0.0f + f7, (float)floorYMinusGraphicsQuality * 0.25f - Math.abs(fallSpeed)).func_227885_a_(1.0f, 1.0f, 1.0f, ticksAndPartialTicks0).func_225587_b_(k4, j4).func_181675_d();
                bufferbuilder.func_225582_a_((double)graphicQualityX - x + rainSizeX + 0.5 + random.nextGaussian() * 2.0, (double)floorYPlusGraphicsQuality - y, (double)graphicQualityZ - z + rainSizeZ + 0.5 + random.nextGaussian()).func_225583_a_(1.0f + f7, (float)floorYMinusGraphicsQuality * 0.25f - Math.abs(fallSpeed)).func_227885_a_(1.0f, 1.0f, 1.0f, ticksAndPartialTicks0).func_225587_b_(k4, j4).func_181675_d();
                bufferbuilder.func_225582_a_((double)graphicQualityX - x + rainSizeX + 0.5 + random.nextGaussian() * 2.0, (double)floorYMinusGraphicsQuality - y, (double)graphicQualityZ - z + rainSizeZ + 0.5 + random.nextGaussian()).func_225583_a_(1.0f + f7, (float)floorYPlusGraphicsQuality * 0.25f - Math.abs(fallSpeed)).func_227885_a_(1.0f, 1.0f, 1.0f, ticksAndPartialTicks0).func_225587_b_(k4, j4).func_181675_d();
                bufferbuilder.func_225582_a_((double)graphicQualityX - x - rainSizeX + 0.5 + random.nextGaussian() * 2.0, (double)floorYMinusGraphicsQuality - y, (double)graphicQualityZ - z - rainSizeZ + 0.5 + random.nextGaussian()).func_225583_a_(0.0f + f7, (float)floorYPlusGraphicsQuality * 0.25f - Math.abs(fallSpeed)).func_227885_a_(1.0f, 1.0f, 1.0f, ticksAndPartialTicks0).func_225587_b_(k4, j4).func_181675_d();
            }
        }
        if (i1 >= 0) {
            tessellator.func_78381_a();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.disableAlphaTest();
        lightTexture.func_205108_b();
        return true;
    }

    @Override
    public void clientTick(ClientWorld world, int tickSpeed, long worldTime, Minecraft mc, Predicate<Biome> biomePredicate) {
    }

    @Override
    public float getVolume() {
        return this.audioVolume;
    }

    @Override
    public float getPitch() {
        return this.audioPitch;
    }

    @Override
    public SoundEvent getSound() {
        return this.audio;
    }
}

