/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weather.event.client;

import corgitaco.betterweather.api.client.WeatherEventClient;
import corgitaco.betterweather.api.client.graphics.Graphics;
import corgitaco.betterweather.weather.event.client.settings.RainClientSettings;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;

public class RainClient
extends WeatherEventClient<RainClientSettings> {
    protected final ResourceLocation rainTexture;
    protected final ResourceLocation snowTexture;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private int rainSoundTime;

    public RainClient(RainClientSettings clientSettings) {
        super(clientSettings);
        this.rainTexture = clientSettings.rainTexture;
        this.snowTexture = clientSettings.snowTexture;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainSizeX[i << 5 | j] = -f1 / f2;
                this.rainSizeZ[i << 5 | j] = f / f2;
            }
        }
    }

    @Override
    public boolean renderWeatherShaders(Graphics graphics, ClientWorld world, double x, double y, double z) {
        return false;
    }

    @Override
    public boolean renderWeatherLegacy(Minecraft mc, ClientWorld world, LightTexture lightTexture, int ticks, float partialTicks, double x, double y, double z, Predicate<Biome> biomePredicate) {
        this.renderVanillaWeather(mc, partialTicks, x, y, z, lightTexture, this.rainSizeX, this.rainSizeZ, this.rainTexture, this.snowTexture, ticks, biomePredicate);
        return true;
    }

    @Override
    public boolean weatherParticlesAndSound(ActiveRenderInfo renderInfo, Minecraft mc, float ticks, Predicate<Biome> validBiomes) {
        float particleStrength = mc.field_71441_e.func_72867_j(1.0f) / (Minecraft.func_71375_t() ? 1.0f : 2.0f);
        if (!(particleStrength <= 0.0f)) {
            Random random = new Random((long)ticks * 312987231L);
            ClientWorld worldReader = mc.field_71441_e;
            BlockPos blockpos = new BlockPos(renderInfo.func_216785_c());
            BlockPos blockpos1 = null;
            int particleCount = (int)(100.0f * particleStrength * particleStrength) / (mc.field_71474_y.field_74362_aa == ParticleStatus.DECREASED ? 2 : 1);
            for (int particleCounter = 0; particleCounter < particleCount; ++particleCounter) {
                int randomAddZ;
                int randomAddX = random.nextInt(21) - 10;
                BlockPos motionBlockingHeightMinus1 = worldReader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos.func_177982_a(randomAddX, 0, randomAddZ = random.nextInt(21) - 10)).func_177977_b();
                Biome biome = worldReader.func_226691_t_(motionBlockingHeightMinus1);
                if (!validBiomes.test(biome) || motionBlockingHeightMinus1.func_177956_o() <= 0 || motionBlockingHeightMinus1.func_177956_o() > blockpos.func_177956_o() + 10 || motionBlockingHeightMinus1.func_177956_o() < blockpos.func_177956_o() - 10 || biome.func_201851_b() != Biome.RainType.RAIN || !(biome.func_225486_c(motionBlockingHeightMinus1) >= 0.15f)) continue;
                blockpos1 = motionBlockingHeightMinus1;
                if (mc.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) break;
                double randDouble = random.nextDouble();
                double randDouble2 = random.nextDouble();
                BlockState blockstate = worldReader.func_180495_p(motionBlockingHeightMinus1);
                FluidState fluidstate = worldReader.func_204610_c(motionBlockingHeightMinus1);
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)worldReader, motionBlockingHeightMinus1);
                double voxelShapeMax = voxelshape.func_197760_b(Direction.Axis.Y, randDouble, randDouble2);
                double fluidstateActualHeight = fluidstate.func_215679_a((IBlockReader)worldReader, motionBlockingHeightMinus1);
                double particleMaxAddedY = Math.max(voxelShapeMax, fluidstateActualHeight);
                this.addParticlesToWorld(mc, motionBlockingHeightMinus1, randDouble, randDouble2, blockstate, fluidstate, particleMaxAddedY);
            }
            if (blockpos1 != null && random.nextInt(3) < this.rainSoundTime++) {
                this.rainSoundTime = 0;
                if (blockpos1.func_177956_o() > blockpos.func_177956_o() + 1 && worldReader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                    mc.field_71441_e.func_184156_a(blockpos1, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
                } else {
                    mc.field_71441_e.func_184156_a(blockpos1, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
        return true;
    }

    protected void addParticlesToWorld(Minecraft mc, BlockPos motionBlockingHeightMinus1, double randDouble, double randDouble2, BlockState blockstate, FluidState fluidstate, double particleMaxAddedY) {
        BasicParticleType iparticledata = !fluidstate.func_206884_a((ITag)FluidTags.field_206960_b) && !blockstate.func_203425_a(Blocks.field_196814_hQ) && !CampfireBlock.func_226915_i_((BlockState)blockstate) ? ParticleTypes.field_197600_K : ParticleTypes.field_197601_L;
        mc.field_71441_e.func_195594_a((IParticleData)iparticledata, (double)motionBlockingHeightMinus1.func_177958_n() + randDouble, (double)motionBlockingHeightMinus1.func_177956_o() + particleMaxAddedY, (double)motionBlockingHeightMinus1.func_177952_p() + randDouble2, 0.0, 0.0, 0.0);
    }

    @Override
    public boolean drippingLeaves() {
        return true;
    }

    @Override
    public void clientTick(ClientWorld world, int tickSpeed, long worldTime, Minecraft mc, Predicate<Biome> biomePredicate) {
    }
}

