/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weather.event.client.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.api.client.ColorSettings;
import corgitaco.betterweather.api.client.WeatherEventClient;
import corgitaco.betterweather.api.weather.WeatherEventAudio;
import corgitaco.betterweather.api.weather.WeatherEventClientSettings;
import corgitaco.betterweather.weather.event.client.BlizzardClient;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;

public class BlizzardClientSettings
extends WeatherEventClientSettings
implements WeatherEventAudio {
    public static final Codec<BlizzardClientSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ColorSettings.CODEC.fieldOf("colorSettings").forGetter(blizzardClientSettings -> blizzardClientSettings.getColorSettings()), (App)Codec.FLOAT.fieldOf("skyOpacity").forGetter(blizzardClientSettings -> Float.valueOf(blizzardClientSettings.skyOpacity())), (App)Codec.FLOAT.fieldOf("fogDensity").forGetter(blizzardClientSettings -> Float.valueOf(blizzardClientSettings.fogDensity())), (App)Codec.BOOL.fieldOf("sunsetSunriseColor").forGetter(blizzardClientSettings -> blizzardClientSettings.sunsetSunriseColor()), (App)ResourceLocation.field_240908_a_.fieldOf("rendererTexture").forGetter(blizzardClientSettings -> blizzardClientSettings.textureLocation), (App)SoundEvent.field_232678_a_.fieldOf("audioLocation").forGetter(blizzardClientSettings -> blizzardClientSettings.audio), (App)Codec.FLOAT.fieldOf("audioVolume").forGetter(blizzardClientSettings -> Float.valueOf(blizzardClientSettings.audioVolume)), (App)Codec.FLOAT.fieldOf("audioPitch").forGetter(blizzardClientSettings -> Float.valueOf(blizzardClientSettings.audioPitch))).apply((Applicative)builder, BlizzardClientSettings::new));
    public static final Map<String, String> VALUE_COMMENTS = (Map)Util.func_200696_a(new HashMap<String, String>(WeatherEventClientSettings.VALUE_COMMENTS), map -> {
        map.put("rendererTexture", "The texture used by the weather renderer.");
        map.put("audioLocation", "The audio played by the weather.");
        map.put("audioVolume", "The volume of the audio played by the weather.");
        map.put("audioPitch", "The pitch of the audio played by the weather.");
    });
    public final ResourceLocation textureLocation;
    private final SoundEvent audio;
    private final float audioVolume;
    private final float audioPitch;

    public BlizzardClientSettings(ColorSettings colorSettings, float skyOpacity, float fogDensity, boolean sunsetSunriseColor, ResourceLocation textureLocation, SoundEvent audio, float audioVolume, float audioPitch) {
        super(colorSettings, skyOpacity, fogDensity, sunsetSunriseColor);
        this.textureLocation = textureLocation;
        this.audio = audio;
        this.audioVolume = audioVolume;
        this.audioPitch = audioPitch;
    }

    @Override
    public Codec<? extends WeatherEventClientSettings> codec() {
        return CODEC;
    }

    @Override
    public WeatherEventClient<?> createClientSettings() {
        return new BlizzardClient(this);
    }

    @Override
    public float getVolume() {
        return this.audioVolume;
    }

    @Override
    public float getPitch() {
        return this.audioPitch;
    }

    @Override
    public SoundEvent getSound() {
        return this.audio;
    }
}

