/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.stal111.valhelsia_structures.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.world.structures.BigTreeStructure;
import com.stal111.valhelsia_structures.world.structures.CastleRuinStructure;
import com.stal111.valhelsia_structures.world.structures.CastleStructure;
import com.stal111.valhelsia_structures.world.structures.DesertHouseStructure;
import com.stal111.valhelsia_structures.world.structures.ForgeStructure;
import com.stal111.valhelsia_structures.world.structures.PlayerHouseStructure;
import com.stal111.valhelsia_structures.world.structures.SpawnerDungeonStructure;
import com.stal111.valhelsia_structures.world.structures.TowerRuinStructure;
import com.stal111.valhelsia_structures.world.structures.WitchHutStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.valhelsia.valhelsia_core.world.IValhelsiaStructure;

public class ModStructures {
    public static final List<IValhelsiaStructure> MOD_STRUCTURES = new ArrayList<IValhelsiaStructure>();
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"valhelsia_structures");
    public static final RegistryObject<CastleStructure> CASTLE = ModStructures.register(new CastleStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<CastleRuinStructure> CASTLE_RUIN = ModStructures.register(new CastleRuinStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<DesertHouseStructure> DESERT_HOUSE = ModStructures.register(new DesertHouseStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<ForgeStructure> FORGE = ModStructures.register(new ForgeStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<PlayerHouseStructure> PLAYER_HOUSE = ModStructures.register(new PlayerHouseStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<SpawnerDungeonStructure> SPAWNER_DUNGEON = ModStructures.register(new SpawnerDungeonStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<TowerRuinStructure> TOWER_RUIN = ModStructures.register(new TowerRuinStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<WitchHutStructure> WITCH_HUT = ModStructures.register(new WitchHutStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));
    public static final RegistryObject<BigTreeStructure> BIG_TREE = ModStructures.register(new BigTreeStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_));

    private static <T extends AbstractValhelsiaStructure> RegistryObject<T> register(T structure) {
        MOD_STRUCTURES.add((IValhelsiaStructure)structure);
        return STRUCTURES.register(structure.getName(), () -> structure);
    }

    public static void setupStructures() {
        for (IValhelsiaStructure iStructure : MOD_STRUCTURES) {
            Structure structure = iStructure.getStructure();
            StructureSeparationSettings separationSettings = iStructure.getSeparationSettings();
            Structure.field_236365_a_.put((Object)Objects.requireNonNull(structure.getRegistryName()).toString(), (Object)structure);
            if (iStructure.transformsSurroundingLand()) {
                Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add((Object)structure).build();
            }
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)structure, (Object)separationSettings).build();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                    tempMap.put(structure, separationSettings);
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                } else {
                    structureMap.put(structure, separationSettings);
                }
            });
        }
    }
}

