/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.world.structures;

import com.mojang.serialization.Codec;
import com.stal111.valhelsia_structures.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.config.StructureGenConfig;
import com.stal111.valhelsia_structures.init.ModStructures;
import com.stal111.valhelsia_structures.utils.StructureUtils;
import com.stal111.valhelsia_structures.world.structures.start.ValhelsiaStructureStart;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.valhelsia.valhelsia_core.world.IValhelsiaStructure;
import net.valhelsia.valhelsia_core.world.ValhelsiaJigsawStructure;

public abstract class AbstractValhelsiaStructure
extends ValhelsiaJigsawStructure {
    private final int size;
    private final StructureConfigEntry structureConfigEntry;

    public AbstractValhelsiaStructure(Codec<VillageConfig> codec, String name, int size, StructureConfigEntry structureConfigEntry) {
        super(codec, name);
        this.size = size;
        this.structureConfigEntry = structureConfigEntry;
    }

    protected boolean func_230363_a_(@Nonnull ChunkGenerator generator, @Nonnull BiomeProvider provider, long seed, @Nonnull SharedSeedRandom rand, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull ChunkPos pos, @Nonnull VillageConfig config) {
        if (this.checkSurface() && !this.isSurfaceFlat(generator, chunkX, chunkZ)) {
            return false;
        }
        if (!this.canGenerateOnWater()) {
            BlockPos centerOfChunk = new BlockPos(chunkX << 4, 0, chunkZ << 4);
            int landHeight = generator.func_222529_a(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            IBlockReader columnOfBlocks = generator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
            BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
            if (!topBlock.func_204520_s().func_206888_e()) {
                return false;
            }
        }
        rand.setSeed((long)(chunkX >> 4 ^ chunkZ >> 4 << 4) ^ seed);
        rand.nextInt();
        if (this.func_236396_f_() == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            ArrayList structures = new ArrayList();
            for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
                Structure structure = iStructure.getStructure();
                if (structure.func_236396_f_() != this.func_236396_f_()) continue;
                structures.add(structure);
            }
            structures.add(Structure.field_236381_q_);
            if (!StructureUtils.checkForOtherStructures(this, generator, seed, rand, chunkX, chunkZ, structures)) {
                return false;
            }
        }
        return rand.nextDouble() < this.getSpawnChance();
    }

    @Nonnull
    public String func_143025_a() {
        return new ResourceLocation("valhelsia_structures", this.getName()).toString();
    }

    protected boolean isSurfaceFlat(@Nonnull ChunkGenerator generator, int chunkX, int chunkZ) {
        int offset = this.getSize() * 16 / 2;
        int xStart = chunkX << 4;
        int zStart = chunkZ << 4;
        int i1 = generator.func_222531_c(xStart, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = generator.func_222531_c(xStart, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = generator.func_222531_c(xStart + offset, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = generator.func_222531_c(xStart + offset, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int minHeight = Math.min(Math.min(i1, j1), Math.min(k1, l1));
        int maxHeight = Math.max(Math.max(i1, j1), Math.max(k1, l1));
        return Math.abs(maxHeight - minHeight) <= (Integer)StructureGenConfig.FLATNESS_DELTA.get();
    }

    @Nonnull
    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public boolean transformsSurroundingLand() {
        return true;
    }

    public int getSize() {
        return this.size;
    }

    public StructureConfigEntry getStructureConfigEntry() {
        return this.structureConfigEntry;
    }

    public int getSpacing() {
        return Math.max((Integer)this.getStructureConfigEntry().configuredSpacing.get(), this.getSeparation() + 1);
    }

    public int getSeparation() {
        return (Integer)this.getStructureConfigEntry().configuredSeparation.get();
    }

    public abstract int getSeedModifier();

    public StructureSeparationSettings getSeparationSettings() {
        return new StructureSeparationSettings(this.getSpacing(), this.getSeparation(), this.getSeedModifier());
    }

    public double getSpawnChance() {
        return (Double)this.getStructureConfigEntry().configuredSpawnChance.get();
    }

    public abstract StructureFeature<VillageConfig, ? extends Structure<VillageConfig>> getStructureFeature();

    public boolean checkSurface() {
        return true;
    }

    public boolean canGenerateOnWater() {
        return false;
    }

    @Nullable
    public BlockPos func_236388_a_(@Nonnull IWorldReader world, @Nonnull StructureManager structureManager, @Nonnull BlockPos startPos, int searchRadius, boolean skipExistingChunks, long seed, @Nonnull StructureSeparationSettings settings) {
        return super.func_236388_a_(world, structureManager, startPos, searchRadius, skipExistingChunks, seed, new StructureSeparationSettings(this.getSpacing(), this.getSeparation(), this.getSeedModifier()));
    }

    public boolean hasMargin() {
        return true;
    }

    public int getMargin() {
        return 12;
    }

    @Nonnull
    public Structure.IStartFactory<VillageConfig> func_214557_a() {
        return Start::new;
    }

    public int getGenerationHeight() {
        return -1;
    }

    public static class Start
    extends ValhelsiaStructureStart<VillageConfig> {
        private final Structure<VillageConfig> structure;
        private final int height;

        public Start(Structure<VillageConfig> structure, int chunkX, int chunkZ, MutableBoundingBox boundingBox, int reference, long seed) {
            this(structure, chunkX, chunkZ, boundingBox, reference, seed, ((AbstractValhelsiaStructure)structure).getGenerationHeight());
        }

        public Start(Structure<VillageConfig> structure, int chunkX, int chunkZ, MutableBoundingBox boundingBox, int reference, long seed, int height) {
            super(structure, chunkX, chunkZ, boundingBox, reference, seed);
            this.structure = structure;
            this.height = height;
        }

        public void func_230364_a_(@Nonnull DynamicRegistries registries, @Nonnull ChunkGenerator generator, @Nonnull TemplateManager manager, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull VillageConfig villageConfig) {
            BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
            JigsawManager.func_242837_a((DynamicRegistries)registries, (VillageConfig)villageConfig, AbstractVillagePiece::new, (ChunkGenerator)generator, (TemplateManager)manager, (BlockPos)pos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)true);
            Vector3i structureCenter = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f();
            for (StructurePiece piece : this.field_75075_a) {
                piece.func_181138_a(pos.func_177958_n() - structureCenter.func_177958_n(), 0, pos.func_177952_p() - structureCenter.func_177952_p());
            }
            this.func_202500_a();
            if (this.height != -1) {
                int offset = this.height - this.field_75074_b.field_78895_b;
                this.field_75074_b.func_78886_a(0, offset, 0);
                for (StructurePiece structurepiece : this.field_75075_a) {
                    structurepiece.func_181138_a(0, offset, 0);
                }
            }
        }
    }
}

