/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui.bestiary;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.client.StatCollector;
import com.github.alexthe666.iceandfire.client.gui.bestiary.ChangePageButton;
import com.github.alexthe666.iceandfire.client.gui.bestiary.IndexPageButton;
import com.github.alexthe666.iceandfire.enums.EnumBestiaryPages;
import com.github.alexthe666.iceandfire.enums.EnumDragonArmor;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class GuiBestiary
extends Screen {
    protected static final int X = 390;
    protected static final int Y = 245;
    private static final ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/gui/bestiary/bestiary.png");
    private static final ResourceLocation DRAWINGS_0 = new ResourceLocation("iceandfire:textures/gui/bestiary/drawings_0.png");
    private static final ResourceLocation DRAWINGS_1 = new ResourceLocation("iceandfire:textures/gui/bestiary/drawings_1.png");
    private static final ResourceLocation DRAWINGS_2 = new ResourceLocation("iceandfire:textures/gui/bestiary/drawings_2.png");
    private static final Map<String, ResourceLocation> PICTURE_LOCATION_CACHE = Maps.newHashMap();
    public List<EnumBestiaryPages> allPageTypes = new ArrayList<EnumBestiaryPages>();
    public EnumBestiaryPages pageType;
    public List<IndexPageButton> indexButtons = new ArrayList<IndexPageButton>();
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    public int bookPages;
    public int bookPagesTotal = 1;
    public int indexPages;
    public int indexPagesTotal = 1;
    protected ItemStack book;
    protected boolean index;
    protected FontRenderer field_230712_o_ = this.getFont();

    public GuiBestiary(ItemStack book) {
        super((ITextComponent)new TranslationTextComponent("bestiary_gui"));
        this.book = book;
        boolean indexPageTotal = false;
        if (!book.func_190926_b() && book.func_77973_b() != null && book.func_77973_b() == IafItemRegistry.BESTIARY && book.func_77978_p() != null) {
            List<EnumBestiaryPages> pages = EnumBestiaryPages.containedPages(EnumBestiaryPages.toList(book.func_77978_p().func_74759_k("Pages")));
            this.allPageTypes.addAll(pages);
            this.indexPagesTotal = (int)Math.ceil((double)pages.size() / 10.0);
        }
        this.index = true;
    }

    private FontRenderer getFont() {
        FontRenderer font = IafConfig.useVanillaFont || !Minecraft.func_71410_x().field_71474_y.field_74363_ab.equalsIgnoreCase("en_us") ? Minecraft.func_71410_x().field_71466_p : (FontRenderer)IceAndFire.PROXY.getFontRenderer();
        return font;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int centerX = (this.field_230708_k_ - 390) / 2;
        int centerY = (this.field_230709_l_ - 245) / 2;
        this.previousPage = new ChangePageButton(centerX + 15, centerY + 215, false, this.bookPages, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages > 0 : this.pageType != null) {
                if (this.index) {
                    --this.indexPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)IafSoundRegistry.BESTIARY_PAGE, (float)1.0f));
                } else if (this.bookPages > 0) {
                    --this.bookPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)IafSoundRegistry.BESTIARY_PAGE, (float)1.0f));
                } else {
                    this.index = true;
                }
            }
        });
        this.func_230480_a_((Widget)this.previousPage);
        this.nextPage = new ChangePageButton(centerX + 357, centerY + 215, true, this.bookPages, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages < this.indexPagesTotal - 1 : this.pageType != null && this.bookPages < this.pageType.pages) {
                if (this.index) {
                    ++this.indexPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)IafSoundRegistry.BESTIARY_PAGE, (float)1.0f));
                } else {
                    ++this.bookPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)IafSoundRegistry.BESTIARY_PAGE, (float)1.0f));
                }
            }
        });
        this.func_230480_a_((Widget)this.nextPage);
        if (!this.allPageTypes.isEmpty()) {
            for (int i = 0; i < this.allPageTypes.size(); ++i) {
                int xIndex = i % -2;
                int yIndex = i % 10;
                int id = 2 + i;
                IndexPageButton button = new IndexPageButton(id, centerX + 15 + xIndex * 200, centerY + 10 + yIndex * 20 - (xIndex == 1 ? 20 : 0), (ITextComponent)new TranslationTextComponent("bestiary." + EnumBestiaryPages.values()[this.allPageTypes.get(i).ordinal()].toString().toLowerCase()), p_214132_1_ -> {
                    if (this.indexButtons.get(id - 2) != null && this.allPageTypes.get(id - 2) != null) {
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)IafSoundRegistry.BESTIARY_PAGE, (float)1.0f));
                        this.index = false;
                        this.bookPages = 0;
                        this.pageType = this.allPageTypes.get(id - 2);
                    }
                });
                this.indexButtons.add(button);
                this.func_230480_a_((Widget)button);
            }
        }
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        for (Widget button : this.field_230710_m_) {
            if (!(button instanceof IndexPageButton)) continue;
            button.field_230693_o_ = this.index;
            button.field_230694_p_ = this.index;
        }
        for (int i = 0; i < this.indexButtons.size(); ++i) {
            this.indexButtons.get((int)i).field_230693_o_ = i < 10 * (this.indexPages + 1) && i >= 10 * this.indexPages && this.index;
        }
        this.func_230446_a_(ms);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        int cornerX = (this.field_230708_k_ - 390) / 2;
        int cornerY = (this.field_230709_l_ - 245) / 2;
        GuiBestiary.func_238463_a_((MatrixStack)ms, (int)cornerX, (int)cornerY, (float)0.0f, (float)0.0f, (int)390, (int)245, (int)390, (int)390);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        RenderHelper.func_227780_a_();
        ms.func_227860_a_();
        ms.func_227861_a_((double)cornerX, (double)cornerY, 0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        int centerX = (this.field_230708_k_ - 390) / 2;
        int centerY = (this.field_230709_l_ - 245) / 2;
        if (!this.index) {
            this.drawPerPage(ms, this.bookPages);
            int pageLeft = this.bookPages * 2 + 1;
            int pageRight = pageLeft + 1;
            this.field_230712_o_.func_238421_b_(ms, "" + pageLeft, (float)centerX, (float)(centerY - 31), 0x303030);
            this.field_230712_o_.func_238421_b_(ms, "" + pageRight, (float)centerX, (float)(centerY - 31), 0x303030);
        }
        GL11.glEnable((int)2896);
        ms.func_227865_b_();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_227780_a_();
    }

    public void drawPerPage(MatrixStack ms, int bookPages) {
        this.imageFromTxt(ms);
        switch (this.pageType) {
            case INTRODUCTION: {
                if (bookPages != 1) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafBlockRegistry.SAPPHIRE_ORE), 30, 20, 2.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SAPPHIRE_GEM), 40, 60, 2.0f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 0, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                boolean drawGold = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 20 < 10;
                this.drawItemStack(ms, new ItemStack((IItemProvider)(drawGold ? Items.field_151074_bl : IafItemRegistry.SILVER_NUGGET)), 144, 34, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)(drawGold ? Items.field_151074_bl : IafItemRegistry.SILVER_NUGGET)), 161, 34, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)(drawGold ? IafBlockRegistry.GOLD_PILE : IafBlockRegistry.SILVER_PILE)), 151, 7, 2.0f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 90, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196662_n), 161, 124, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196662_n), 161, 107, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MANUSCRIPT), 161, 91, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafBlockRegistry.LECTERN), 151, 78, 2.0f);
                break;
            }
            case FIREDRAGON: {
                break;
            }
            case FIREDRAGONEGG: {
                break;
            }
            case ICEDRAGON: {
                break;
            }
            case ICEDRAGONEGG: {
                break;
            }
            case TAMEDDRAGONS: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 144, 90, 389, 1, 50, 50, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151103_aS), 145, 124, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151147_al), 145, 107, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151103_aS), 145, 91, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151147_al), 161, 124, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151103_aS), 161, 107, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151147_al), 161, 91, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151103_aS), 177, 124, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151147_al), 177, 107, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151103_aS), 177, 91, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_MEAL), 151, 78, 2.0f);
                }
                if (bookPages == 1) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 144, 0, 389, 1, 50, 50, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_SKULL_FIRE), 161, 17, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151055_y), 161, 32, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_STAFF), 151, 10, 2.0f);
                }
                if (bookPages == 2) {
                    ms.func_227860_a_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafBlockRegistry.FIRE_LILY), 5, 14, 3.75f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafBlockRegistry.FROST_LILY), 30, 14, 3.75f);
                    ms.func_227865_b_();
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 144, 0, 389, 1, 50, 50, 512.0f);
                    ms.func_227865_b_();
                    boolean drawFire = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 40 < 20;
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(drawFire ? IafBlockRegistry.FIRE_LILY : IafBlockRegistry.FROST_LILY)), 161, 17, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151054_z), 161, 32, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(drawFire ? Items.field_151072_bj : Items.field_179563_cD)), 177, 17, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(drawFire ? IafItemRegistry.FIRE_STEW : IafItemRegistry.FROST_STEW)), 151, 10, 2.0f);
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 144, 65, 389, 1, 50, 50, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151055_y), 144, 97, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BONE), 180, 110, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BONE), 180, 92, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BONE), 198, 92, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BONE), 198, 74, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_HORN), 151, 60, 2.0f);
                }
                if (bookPages != 3) break;
                int j = 18;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONARMOR_IRON_0, 1), j += 16, 60, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONARMOR_IRON_1, 1), j += 16, 60, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONARMOR_IRON_2, 1), j += 16, 60, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONARMOR_IRON_3, 1), j += 16, 60, 1.5f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 10, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BONE), 160, 12, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BONE), 180, 31, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151042_j), 199, 50, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_FLUTE), 151, 18, 2.0f);
                break;
            }
            case MATERIALS: {
                int j;
                if (bookPages == 0) {
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONSCALES_RED), 18, 16, 3.75f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BONE), 70, 10, 3.75f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.WITHERBONE), 112, 70, 2.5f);
                    j = 18;
                    this.drawItemStack(ms, new ItemStack((IItemProvider)EnumDragonArmor.armor_red.helmet), j += 16, 115, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)EnumDragonArmor.armor_red.chestplate), j += 16, 115, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)EnumDragonArmor.armor_red.leggings), j += 16, 115, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)EnumDragonArmor.armor_red.boots), j += 16, 115, 1.5f);
                }
                if (bookPages == 1) {
                    j = 1;
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONBONE_SWORD), j += 16, 14, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONBONE_PICKAXE), j += 16, 14, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONBONE_AXE), j += 16, 14, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONBONE_SHOVEL), j += 16, 14, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONBONE_HOE), j += 16, 14, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BOW), j += 16, 14, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.FIRE_DRAGON_FLESH), 18, 24, 3.75f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.FIRE_DRAGON_HEART), 70, 14, 3.75f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_SKULL_FIRE), 70, 39, 3.75f);
                }
                if (bookPages != 2) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.FIRE_DRAGON_BLOOD), 18, 24, 3.75f);
                break;
            }
            case ALCHEMY: {
                if (bookPages != 0) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.FIRE_DRAGON_BLOOD), 10, 24, 3.75f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.ICE_DRAGON_BLOOD), 26, 24, 3.75f);
                boolean drawFire = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 40 < 20;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DRAGONBONE_SWORD), 161, 17, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)(drawFire ? IafItemRegistry.FIRE_DRAGON_BLOOD : IafItemRegistry.ICE_DRAGON_BLOOD)), 161, 32, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)(drawFire ? IafItemRegistry.DRAGONBONE_SWORD_FIRE : IafItemRegistry.DRAGONBONE_SWORD_ICE)), 151, 10, 2.0f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 0, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                break;
            }
            case HIPPOGRYPH: {
                int drawType;
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(0.8f, 0.8f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 29, 150, 303, 151, 61, 36, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 91, 150, 364, 151, 61, 36, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 151, 150, 425, 151, 61, 36, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 29, 190, 303, 187, 61, 36, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 91, 190, 364, 187, 61, 36, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 151, 190, 425, 187, 61, 36, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 90, 230, 425, 223, 61, 35, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_179556_br), 70, 20, 3.75f);
                }
                if (bookPages != 1) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151055_y), 16, 24, 3.75f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 10, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151008_G), 160, 31, 1.35f);
                int n = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 40 ? 2 : (drawType = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 20 ? 1 : 0);
                this.drawItemStack(ms, new ItemStack((IItemProvider)(drawType == 0 ? Items.field_151138_bX : (drawType == 1 ? Items.field_151136_bY : Items.field_151125_bZ))), 180, 31, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151008_G), 199, 31, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)(drawType == 0 ? IafItemRegistry.IRON_HIPPOGRYPH_ARMOR : (drawType == 1 ? IafItemRegistry.GOLD_HIPPOGRYPH_ARMOR : IafItemRegistry.DIAMOND_HIPPOGRYPH_ARMOR))), 151, 18, 2.0f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_179560_bq), 70, 23, 3.75f);
                break;
            }
            case GORGON: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 10, 89, 473, 117, 19, 34, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 50, 78, 399, 106, 28, 45, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 100, 89, 455, 117, 18, 34, 512.0f);
                    ms.func_227865_b_();
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 144, 70, 389, 1, 50, 50, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151007_F), 160, 97, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151116_aA), 180, 97, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151007_F), 199, 97, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.BLINDFOLD), 171, 65, 2.0f);
                }
                if (bookPages != 1) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.GORGON_HEAD), 16, 12, 3.75f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.7f, 1.7f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 37, 95, 473, 117, 19, 34, 512.0f);
                this.drawImage(ms, DRAWINGS_0, 60, 95, 455, 117, 18, 34, 512.0f);
                ms.func_227865_b_();
                break;
            }
            case PIXIE: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    this.drawImage(ms, DRAWINGS_0, 20, 60, 371, 258, 47, 35, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 42, 95, 416, 258, 45, 35, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 67, 60, 462, 258, 47, 35, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 88, 95, 370, 293, 47, 35, 512.0f);
                    this.drawImage(ms, DRAWINGS_0, 110, 60, 416, 293, 47, 35, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.PIXIE_DUST), 70, 10, 3.75f);
                    ms.func_227860_a_();
                    ms.func_227862_a_(0.9f, 0.9f, 1.0f);
                    ms.func_227861_a_(20.0, 24.0, 0.0);
                    ms.func_227860_a_();
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 150, 100, 389, 1, 50, 50, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_150359_w), 160, 113, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_150359_w), 199, 113, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196662_n), 180, 113, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_150359_w), 160, 131, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_150359_w), 199, 131, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_150359_w), 180, 150, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_150359_w), 160, 150, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_150359_w), 199, 150, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafBlockRegistry.JAR_EMPTY), 171, 85, 2.0f);
                    ms.func_227865_b_();
                    ms.func_227865_b_();
                }
                if (bookPages != 1) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.AMBROSIA), 14, 22, 3.75f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 144, 100, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.PIXIE_DUST), 180, 131, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151054_z), 180, 150, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.AMBROSIA), 171, 85, 2.0f);
                break;
            }
            case CYCLOPS: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.5f);
                    this.drawImage(ms, DRAWINGS_0, 185, 8, 399, 328, 24, 63, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages == 1) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.5f);
                    this.drawImage(ms, DRAWINGS_0, 50, 35, 423, 328, 24, 63, 512.0f);
                    ms.func_227865_b_();
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 144, 50, 389, 1, 50, 50, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151024_Q), 180, 76, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 160, 76, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 199, 76, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 160, 57, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 180, 57, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 199, 57, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SHEEP_HELMET), 165, 45, 2.0f);
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_0, 144, 95, 389, 1, 50, 50, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151027_R), 180, 126, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 160, 126, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 199, 126, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 160, 107, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 199, 107, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 160, 145, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 180, 145, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 199, 145, 1.35f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SHEEP_CHESTPLATE), 165, 95, 2.0f);
                }
                if (bookPages != 2) break;
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.5f);
                this.drawImage(ms, DRAWINGS_0, 185, 30, 447, 328, 24, 63, 512.0f);
                ms.func_227865_b_();
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 13, 24, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151026_S), 34, 46, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 14, 46, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 53, 46, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 14, 27, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 34, 27, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 53, 27, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 14, 65, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 53, 65, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SHEEP_LEGGINGS), 64, 27, 2.0f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 13, 84, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151021_T), 34, 94, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 14, 113, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 53, 113, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 14, 94, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Blocks.field_196556_aL), 53, 94, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SHEEP_BOOTS), 64, 73, 2.0f);
                break;
            }
            case SIREN: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.25f, 1.25f, 1.25f);
                    this.drawImage(ms, DRAWINGS_1, 190, 25, 0, 0, 25, 42, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 220, 15, 25, 0, 25, 42, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 255, 25, 50, 0, 25, 42, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 190, 135, 0, 42, 26, 28, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 220, 125, 26, 42, 26, 28, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 255, 135, 52, 42, 26, 28, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages != 1) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.EARPLUGS), 18, 40, 3.75f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 160, 0, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)Item.func_150898_a((Block)Blocks.field_196689_eF)), 180, 20, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Item.func_150898_a((Block)Blocks.field_196689_eF)), 215, 20, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.EARPLUGS), 170, 10, 2.0f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SHINY_SCALES), 123, 75, 2.25f);
                break;
            }
            case HIPPOCAMPUS: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    this.drawImage(ms, DRAWINGS_1, 210, 25, 0, 70, 57, 49, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 265, 25, 57, 70, 57, 49, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 320, 25, 0, 119, 57, 49, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 210, 80, 57, 119, 57, 49, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 265, 80, 0, 168, 57, 49, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 320, 80, 57, 168, 57, 49, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages == 1) {
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_222066_kO), 37, 33, 2.25f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_179563_cD), 37, 73, 2.25f);
                }
                if (bookPages != 2) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151055_y), 35, 25, 2.25f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SHINY_SCALES), 35, 75, 2.25f);
                break;
            }
            case DEATHWORM: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    this.drawImage(ms, DRAWINGS_1, 230, 25, 0, 217, 133, 16, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 230, 50, 0, 233, 133, 16, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 230, 75, 0, 249, 133, 16, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages == 1) {
                    ms.func_227860_a_();
                    this.drawImage(ms, DRAWINGS_1, 25, 95, 0, 265, 148, 44, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 250, 5, 0, 309, 81, 162, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages == 2) {
                    int drawType = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 40 ? 2 : (Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 20 ? 1 : 0);
                    Item chitin = IafItemRegistry.DEATH_WORM_CHITIN_YELLOW;
                    if (drawType == 2) {
                        chitin = IafItemRegistry.DEATH_WORM_CHITIN_RED;
                    }
                    if (drawType == 1) {
                        chitin = IafItemRegistry.DEATH_WORM_CHITIN_WHITE;
                    }
                    this.drawItemStack(ms, new ItemStack((IItemProvider)chitin, 1), 17, 30, 3.75f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(drawType == 2 ? IafItemRegistry.DEATHWORM_RED_HELMET : (drawType == 1 ? IafItemRegistry.DEATHWORM_WHITE_HELMET : IafItemRegistry.DEATHWORM_YELLOW_HELMET))), 92, 8, 2.25f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(drawType == 2 ? IafItemRegistry.DEATHWORM_RED_CHESTPLATE : (drawType == 1 ? IafItemRegistry.DEATHWORM_WHITE_CHESTPLATE : IafItemRegistry.DEATHWORM_YELLOW_CHESTPLATE))), 112, 8, 2.25f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(drawType == 2 ? IafItemRegistry.DEATHWORM_RED_LEGGINGS : (drawType == 1 ? IafItemRegistry.DEATHWORM_WHITE_LEGGINGS : IafItemRegistry.DEATHWORM_YELLOW_LEGGINGS))), 132, 8, 2.25f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(drawType == 2 ? IafItemRegistry.DEATHWORM_RED_BOOTS : (drawType == 1 ? IafItemRegistry.DEATHWORM_WHITE_BOOTS : IafItemRegistry.DEATHWORM_YELLOW_BOOTS))), 152, 8, 2.25f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DEATHWORM_EGG), 125, 42, 2.25f);
                }
                if (bookPages != 3) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.DEATHWORM_EGG_GIGANTIC, 1), 125, 4, 2.25f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151112_aM), 115, 55, 2.25f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151112_aM), 135, 55, 2.25f);
                break;
            }
            case COCKATRICE: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_1, 155, 10, 114, 0, 88, 36, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 155, 45, 114, 36, 88, 36, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages != 1) break;
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 18, 10, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151007_F), 20, 30, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151116_aA), 40, 30, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151007_F), 59, 30, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.BLINDFOLD), 60, 18, 2.0f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.WITHERBONE), 30, 58, 2.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.ROTTEN_EGG), 109, 18, 2.5f);
                break;
            }
            case STYMPHALIANBIRD: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_1, 34, 46, 114, 72, 59, 37, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 155, 35, 114, 109, 67, 35, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.STYMPHALIAN_BIRD_FEATHER), 109, 60, 2.5f);
                }
                if (bookPages != 1) break;
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 18, 10, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151145_ak), 40, 13, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151055_y), 40, 30, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.STYMPHALIAN_BIRD_FEATHER), 40, 49, 1.35f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.STYMPHALIAN_ARROW), 60, 18, 2.0f);
                break;
            }
            case TROLL: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                    this.drawImage(ms, DRAWINGS_1, 15, 60, 156, 211, 25, 58, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 50, 55, 181, 211, 25, 58, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 85, 60, 206, 211, 25, 58, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 155, 22, 114, 145, 24, 66, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 190, 19, 188, 142, 47, 69, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages == 1) {
                    int i = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumTroll.Weapon.values().length * 20) / 20;
                    this.drawItemStack(ms, new ItemStack((IItemProvider)EnumTroll.Weapon.values()[i].item), 30, 7, 2.5f);
                    int j = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumTroll.values().length * 20) / 20;
                    this.drawItemStack(ms, new ItemStack((IItemProvider)EnumTroll.values()[j].leather), 100, 30, 2.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.TROLL_TUSK), 120, 30, 2.5f);
                }
                if (bookPages != 2) break;
                int j = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumTroll.values().length * 20) / 20;
                this.drawItemStack(ms, new ItemStack((IItemProvider)EnumTroll.values()[j].helmet), 27, 15, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)EnumTroll.values()[j].chestplate), 47, 15, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)EnumTroll.values()[j].leggings), 67, 15, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)EnumTroll.values()[j].boots), 87, 15, 1.5f);
                break;
            }
            case MYRMEX: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.51f, 1.51f, 1.0f);
                    this.drawImage(ms, DRAWINGS_1, 137, 10, 202, 16, 57, 21, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 195, 10, 278, 16, 57, 21, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages == 1) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.51f, 1.51f, 1.0f);
                    this.drawImage(ms, DRAWINGS_1, 7, 17, 202, 37, 59, 21, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 65, 17, 278, 37, 59, 21, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 7, 77, 202, 58, 59, 21, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 65, 77, 278, 58, 59, 21, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 145, 20, 278, 103, 43, 45, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 195, 20, 321, 103, 43, 45, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages == 2) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(1.51f, 1.51f, 1.0f);
                    this.drawImage(ms, DRAWINGS_1, 25, 13, 202, 79, 76, 24, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 25, 40, 278, 79, 76, 24, 512.0f);
                    ms.func_227865_b_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_CHITIN), 125, 43, 2.0f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_CHITIN), 155, 43, 2.0f);
                    int i = 133;
                    boolean jungle = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 30;
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_SHOVEL : IafItemRegistry.MYRMEX_DESERT_SHOVEL)), i += 16, 100, 1.51f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_PICKAXE : IafItemRegistry.MYRMEX_DESERT_PICKAXE)), i += 16, 100, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_AXE : IafItemRegistry.MYRMEX_DESERT_AXE)), i += 16, 100, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_SWORD : IafItemRegistry.MYRMEX_DESERT_SWORD)), i += 16, 100, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_SWORD_VENOM : IafItemRegistry.MYRMEX_DESERT_SWORD_VENOM)), i += 16, 100, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_HOE : IafItemRegistry.MYRMEX_DESERT_HOE)), i += 16, 100, 1.5f);
                    int j = 148;
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_HELMET : IafItemRegistry.MYRMEX_DESERT_HELMET)), j += 16, 115, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_CHESTPLATE : IafItemRegistry.MYRMEX_DESERT_CHESTPLATE)), j += 16, 115, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_LEGGINGS : IafItemRegistry.MYRMEX_DESERT_LEGGINGS)), j += 16, 115, 1.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_BOOTS : IafItemRegistry.MYRMEX_DESERT_BOOTS)), j += 16, 115, 1.5f);
                }
                if (bookPages == 3) {
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_STINGER), 35, 22, 2.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_RESIN), 25, 64, 2.0f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_RESIN), 55, 64, 2.0f);
                }
                if (bookPages != 4) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_STAFF), 25, 73, 2.0f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_STAFF), 55, 73, 2.0f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_EGG), 125, 90, 2.0f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_EGG), 155, 90, 2.0f);
                break;
            }
            case AMPHITHERE: {
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(0.75f, 0.75f, 0.75f);
                    this.drawImage(ms, DRAWINGS_1, 70, 97, 257, 163, 136, 93, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 270, 50, 148, 267, 120, 51, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 380, 50, 148, 318, 120, 51, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 270, 100, 148, 369, 120, 51, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 380, 100, 148, 420, 120, 51, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 330, 150, 268, 267, 120, 51, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages != 2) break;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.AMPHITHERE_FEATHER), 30, 20, 2.5f);
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 19, 71, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151145_ak), 36, 73, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151055_y), 36, 89, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.AMPHITHERE_FEATHER), 36, 106, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.AMPHITHERE_ARROW), 60, 65, 2.0f);
                break;
            }
            case SEASERPENT: {
                int j;
                if (bookPages == 0) {
                    ms.func_227860_a_();
                    ms.func_227862_a_(0.75f, 0.75f, 0.75f);
                    this.drawImage(ms, DRAWINGS_1, 290, 5, 422, 0, 90, 64, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 380, 5, 422, 64, 90, 64, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 290, 70, 422, 128, 90, 64, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 380, 70, 422, 192, 90, 64, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 290, 140, 422, 256, 90, 64, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 380, 140, 422, 320, 90, 64, 512.0f);
                    this.drawImage(ms, DRAWINGS_1, 345, 210, 422, 384, 90, 64, 512.0f);
                    ms.func_227865_b_();
                }
                if (bookPages == 1) {
                    this.drawImage(ms, DRAWINGS_1, 60, 90, 337, 0, 70, 83, 512.0f);
                    j = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumSeaSerpent.values().length * 20) / 20;
                    this.drawItemStack(ms, new ItemStack((IItemProvider)EnumSeaSerpent.values()[j].scale), 130, 40, 2.5f);
                    this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SERPENT_FANG), 90, 40, 2.5f);
                }
                if (bookPages != 2) break;
                ms.func_227860_a_();
                ms.func_227862_a_(1.5f, 1.5f, 1.0f);
                this.drawImage(ms, DRAWINGS_0, 19, 31, 389, 1, 50, 50, 512.0f);
                ms.func_227865_b_();
                j = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumSeaSerpent.values().length * 20) / 20;
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SERPENT_FANG), 36, 32, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)Items.field_151055_y), 36, 48, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)EnumSeaSerpent.values()[j].scale), 36, 66, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)EnumSeaSerpent.values()[j].helmet), 34, 125, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)EnumSeaSerpent.values()[j].chestplate), 50, 125, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)EnumSeaSerpent.values()[j].leggings), 66, 125, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)EnumSeaSerpent.values()[j].boots), 82, 125, 1.5f);
                this.drawItemStack(ms, new ItemStack((IItemProvider)IafItemRegistry.SEA_SERPENT_ARROW), 60, 33, 2.0f);
            }
        }
        this.writeFromTxt(ms);
    }

    public void imageFromTxt(MatrixStack ms) {
        String fileName = this.pageType.toString().toLowerCase(Locale.ROOT) + "_" + this.bookPages + ".txt";
        String languageName = Minecraft.func_71410_x().field_71474_y.field_74363_ab.toLowerCase(Locale.ROOT);
        ResourceLocation fileLoc = new ResourceLocation("iceandfire:lang/bestiary/" + languageName + "_0/" + fileName);
        ResourceLocation backupLoc = new ResourceLocation("iceandfire:lang/bestiary/en_us_0/" + fileName);
        IResource resource = null;
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(fileLoc);
        }
        catch (IOException e) {
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(backupLoc);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.func_199027_b(), (String)"UTF-8").iterator();
            String line = null;
            boolean linenumber = false;
            int zLevelAdd = 0;
            while (iterator.hasNext()) {
                String[] split;
                line = ((String)iterator.next()).trim();
                if ((line.contains("<") || line.contains(">")) && line.contains("<image>")) {
                    line = line.substring(8, line.length() - 1);
                    split = line.split(" ");
                    String texture = "iceandfire:textures/gui/bestiary/" + split[0];
                    ResourceLocation resourcelocation = PICTURE_LOCATION_CACHE.get(texture);
                    if (resourcelocation == null) {
                        resourcelocation = new ResourceLocation(texture);
                        PICTURE_LOCATION_CACHE.put(texture, resourcelocation);
                    }
                    ms.func_227860_a_();
                    this.drawImage(ms, resourcelocation, Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Float.parseFloat(split[7]) * 512.0f);
                    ms.func_227865_b_();
                }
                if (line.contains("<item>")) {
                    line = line.substring(7, line.length() - 1);
                    split = line.split(" ");
                    RenderHelper.func_227780_a_();
                    this.drawItemStack(ms, new ItemStack((IItemProvider)this.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f);
                }
                if (line.contains("<block>")) {
                    line = line.substring(8, line.length() - 1);
                    split = line.split(" ");
                    RenderHelper.func_227780_a_();
                    this.drawBlockStack(ms, new ItemStack((IItemProvider)this.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f, ++zLevelAdd);
                }
                if (!line.contains("<recipe>")) continue;
                line = line.substring(9, line.length() - 1);
                split = line.split(" ");
                RenderHelper.func_227780_a_();
                float scale = Float.parseFloat(split[split.length - 1]);
                int x = Integer.parseInt(split[split.length - 3]);
                int y = Integer.parseInt(split[split.length - 2]);
                ItemStack result = new ItemStack((IItemProvider)this.getItemByRegistryName(split[0]), 1);
                ItemStack[] ingredients = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                int j = 8;
                for (int i = split.length - 5; i >= 2; i -= 2) {
                    ingredients[j] = new ItemStack((IItemProvider)this.getItemByRegistryName(split[i]), 1);
                    --j;
                }
                RenderHelper.func_227780_a_();
                ms.func_227860_a_();
                this.drawRecipe(ms, result, ingredients, x, y, scale);
                ms.func_227865_b_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Item getItemByRegistryName(String registryName) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
    }

    private void drawRecipe(MatrixStack ms, ItemStack result, ItemStack[] ingredients, int x, int y, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)0.0f);
        this.drawItemStack(ms, result, 62, 17, 2.0f);
        for (int i = 0; i < 9; ++i) {
            this.drawItemStack(ms, ingredients[i], i % 3 * 22 + 30, i / 3 * 22 + 10, 1.25f);
        }
        RenderSystem.popMatrix();
        ms.func_227860_a_();
        ms.func_227861_a_((double)x, (double)y, 0.0);
        ms.func_227862_a_(scale, scale, 0.0f);
        ms.func_227861_a_(37.0, 13.0, 1.0);
        ms.func_227862_a_(1.5f, 1.5f, 1.0f);
        this.drawImage(ms, DRAWINGS_0, 0, 0, 389, 1, 50, 50, 512.0f);
        ms.func_227865_b_();
    }

    public void writeFromTxt(MatrixStack ms) {
        String fileName = this.pageType.toString().toLowerCase(Locale.ROOT) + "_" + this.bookPages + ".txt";
        ResourceLocation fileLoc = new ResourceLocation("iceandfire:lang/bestiary/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "_0/" + fileName);
        ResourceLocation backupLoc = new ResourceLocation("iceandfire:lang/bestiary/en_us_0/" + fileName);
        IResource resource = null;
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(fileLoc);
        }
        catch (IOException e) {
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(backupLoc);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.func_199027_b(), (String)"UTF-8").iterator();
            String line = null;
            int linenumber = 0;
            while (iterator.hasNext()) {
                line = ((String)iterator.next()).trim();
                if (line.contains("<") || line.contains(">")) continue;
                ms.func_227860_a_();
                if (this.usingVanillaFont()) {
                    ms.func_227862_a_(0.945f, 0.945f, 0.945f);
                    ms.func_227861_a_(0.0, 5.5, 0.0);
                }
                if (linenumber <= 19) {
                    this.field_230712_o_.func_238421_b_(ms, line, 15.0f, (float)(20 + linenumber * 10), 0x303030);
                } else {
                    this.field_230712_o_.func_238421_b_(ms, line, 220.0f, (float)((linenumber - 19) * 10), 0x303030);
                }
                ++linenumber;
                ms.func_227865_b_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ms.func_227860_a_();
        String s = StatCollector.translateToLocal("bestiary." + this.pageType.toString().toLowerCase(Locale.ROOT));
        float scale = this.field_230712_o_.func_78256_a(s) <= 100 ? 2.0f : (float)this.field_230712_o_.func_78256_a(s) * 0.0125f;
        ms.func_227862_a_(scale, scale, scale);
        this.field_230712_o_.func_238421_b_(ms, s, 10.0f, 2.0f, 8025450);
        ms.func_227865_b_();
    }

    private boolean usingVanillaFont() {
        return this.field_230712_o_ == Minecraft.func_71410_x().field_71466_p;
    }

    public void drawImage(MatrixStack ms, ResourceLocation texture, int x, int y, int u, int v, int width, int height, float scale) {
        ms.func_227860_a_();
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        ms.func_227862_a_(scale / 512.0f, scale / 512.0f, scale / 512.0f);
        GuiBestiary.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)512, (int)512);
        ms.func_227865_b_();
    }

    private void drawItemStack(MatrixStack ms, ItemStack stack, int x, int y, float scale) {
        int cornerX = (this.field_230708_k_ - 390) / 2;
        int cornerY = (this.field_230709_l_ - 245) / 2;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)cornerX, (float)cornerY, (float)32.0f);
        float zLevel = 200.0f;
        this.field_230707_j_.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.getFont();
        }
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.field_230707_j_.field_77023_b = -100.0f;
        RenderSystem.depthMask((boolean)true);
        this.field_230707_j_.func_180450_b(stack, x, y);
        zLevel = 0.0f;
        this.field_230707_j_.field_77023_b = 0.0f;
        RenderSystem.popMatrix();
    }

    protected void renderItemModelIntoGUI(MatrixStack ms, ItemStack stack, int x, int y, IBakedModel bakedmodel, float scale) {
        boolean flag;
        int i = (this.field_230708_k_ - 390) / 2;
        int j = (this.field_230709_l_ - 245) / 2;
        RenderSystem.pushMatrix();
        this.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        this.getMinecraft().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.scalef((float)(16.0f * scale), (float)(16.0f * scale), (float)(16.0f * scale));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + this.field_230707_j_.field_77023_b));
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        this.field_230707_j_.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    private void drawBlockStack(MatrixStack ms, ItemStack stack, int x, int y, float scale, int zScale) {
        int cornerX = (this.field_230708_k_ - 390) / 2;
        int cornerY = (this.field_230709_l_ - 245) / 2;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)cornerX, (float)cornerY, (float)32.0f);
        float zLevel = 200.0f;
        this.field_230707_j_.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.getFont();
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_230707_j_.field_77023_b = -100 + zScale * 10;
        this.field_230707_j_.func_180450_b(stack, x, y);
        zLevel = 0.0f;
        this.field_230707_j_.field_77023_b = 0.0f;
        RenderSystem.popMatrix();
    }
}

