/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockEggInIce;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityEggInIce;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;

public class DragonType {
    public static final DragonType FIRE = new DragonType("fire");
    public static final DragonType ICE = new DragonType("ice").setPiscivore();
    public static final DragonType LIGHTNING = new DragonType("lightning");
    private String name;
    private boolean piscivore;

    public DragonType(String name) {
        this.name = name;
    }

    public static String getNameFromInt(int type) {
        if (type == 2) {
            return "lightning";
        }
        if (type == 1) {
            return "ice";
        }
        return "fire";
    }

    public static int getIntFromType(DragonType type) {
        if (type == LIGHTNING) {
            return 2;
        }
        if (type == ICE) {
            return 1;
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPiscivore() {
        return this.piscivore;
    }

    public DragonType setPiscivore() {
        this.piscivore = true;
        return this;
    }

    public void updateEggCondition(EntityDragonEgg egg) {
        BlockPos pos = new BlockPos(egg.func_213303_ch());
        if (this == FIRE) {
            if (egg.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151581_o) {
                egg.setDragonAge(egg.getDragonAge() + 1);
            }
            if (egg.getDragonAge() > IafConfig.dragonEggTime && egg.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151581_o) {
                egg.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                EntityFireDragon dragon = new EntityFireDragon(egg.field_70170_p);
                if (egg.func_145818_k_()) {
                    dragon.func_200203_b(egg.func_200201_e());
                }
                dragon.setVariant(egg.getEggType().ordinal());
                dragon.setGender(egg.func_70681_au().nextBoolean());
                dragon.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
                dragon.setHunger(50);
                if (!egg.field_70170_p.field_72995_K) {
                    egg.field_70170_p.func_217376_c((Entity)dragon);
                }
                if (egg.func_145818_k_()) {
                    dragon.func_200203_b(egg.func_200201_e());
                }
                dragon.func_70903_f(true);
                dragon.func_184754_b(egg.getOwnerId());
                egg.field_70170_p.func_184134_a(egg.func_226277_ct_(), egg.func_226278_cu_() + (double)egg.func_70047_e(), egg.func_226281_cx_(), SoundEvents.field_187646_bt, egg.func_184176_by(), 2.5f, 1.0f, false);
                egg.field_70170_p.func_184134_a(egg.func_226277_ct_(), egg.func_226278_cu_() + (double)egg.func_70047_e(), egg.func_226281_cx_(), IafSoundRegistry.EGG_HATCH, egg.func_184176_by(), 2.5f, 1.0f, false);
                egg.func_70106_y();
            }
        }
        if (this == ICE && egg.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h && egg.func_70681_au().nextInt(500) == 0) {
            egg.func_70106_y();
            egg.field_70170_p.func_175656_a(pos, IafBlockRegistry.EGG_IN_ICE.func_176223_P());
            egg.field_70170_p.func_184134_a(egg.func_226277_ct_(), egg.func_226278_cu_() + (double)egg.func_70047_e(), egg.func_226281_cx_(), SoundEvents.field_187561_bM, egg.func_184176_by(), 2.5f, 1.0f, false);
            if (egg.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockEggInIce) {
                ((TileEntityEggInIce)egg.field_70170_p.func_175625_s((BlockPos)pos)).field_200663_e = egg.getEggType();
                ((TileEntityEggInIce)egg.field_70170_p.func_175625_s((BlockPos)pos)).ownerUUID = egg.getOwnerId();
            }
        }
        if (this == LIGHTNING) {
            boolean flag;
            BlockPos.Mutable blockpos$pooledmutable = new BlockPos.Mutable(egg.func_226277_ct_(), egg.func_226278_cu_(), egg.func_226281_cx_());
            boolean bl = flag = egg.field_70170_p.func_175727_C((BlockPos)blockpos$pooledmutable) || egg.field_70170_p.func_175727_C((BlockPos)blockpos$pooledmutable.func_189532_c(egg.func_226277_ct_(), egg.func_226278_cu_() + (double)egg.field_213325_aI.field_220316_b, egg.func_226281_cx_()));
            if (egg.field_70170_p.func_226660_f_(egg.func_233580_cy_().func_177984_a()) && flag) {
                egg.setDragonAge(egg.getDragonAge() + 1);
            }
            if (egg.getDragonAge() > IafConfig.dragonEggTime) {
                EntityLightningDragon dragon = new EntityLightningDragon(egg.field_70170_p);
                if (egg.func_145818_k_()) {
                    dragon.func_200203_b(egg.func_200201_e());
                }
                dragon.setVariant(egg.getEggType().ordinal() - 8);
                dragon.setGender(egg.func_70681_au().nextBoolean());
                dragon.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
                dragon.setHunger(50);
                if (!egg.field_70170_p.field_72995_K) {
                    egg.field_70170_p.func_217376_c((Entity)dragon);
                }
                if (egg.func_145818_k_()) {
                    dragon.func_200203_b(egg.func_200201_e());
                }
                dragon.func_70903_f(true);
                dragon.func_184754_b(egg.getOwnerId());
                LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(egg.field_70170_p);
                lightningboltentity.func_70107_b(egg.func_226277_ct_(), egg.func_226278_cu_(), egg.func_226281_cx_());
                lightningboltentity.func_233623_a_(true);
                if (!egg.field_70170_p.field_72995_K) {
                    egg.field_70170_p.func_217376_c((Entity)lightningboltentity);
                }
                egg.field_70170_p.func_184134_a(egg.func_226277_ct_(), egg.func_226278_cu_() + (double)egg.func_70047_e(), egg.func_226281_cx_(), SoundEvents.field_187754_de, egg.func_184176_by(), 2.5f, 1.0f, false);
                egg.field_70170_p.func_184134_a(egg.func_226277_ct_(), egg.func_226278_cu_() + (double)egg.func_70047_e(), egg.func_226281_cx_(), IafSoundRegistry.EGG_HATCH, egg.func_184176_by(), 2.5f, 1.0f, false);
                egg.func_70106_y();
            }
        }
    }
}

