/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDeathWormEgg
extends ProjectileItemEntity
implements IEntityAdditionalSpawnData {
    private boolean giant;

    public EntityDeathWormEgg(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public EntityDeathWormEgg(EntityType type, LivingEntity throwerIn, World worldIn, boolean giant) {
        super(type, throwerIn, worldIn);
        this.giant = giant;
    }

    public EntityDeathWormEgg(EntityType type, double x, double y, double z, World worldIn, boolean giant) {
        super(type, x, y, z, worldIn);
        this.giant = giant;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeBoolean(this.giant);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.giant = additionalData.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184543_l()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        Entity thrower = this.func_234616_v_();
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            ((EntityRayTraceResult)result).func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)thrower), 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            float wormSize = 0.25f + (float)(Math.random() * (double)0.35f);
            EntityDeathWorm deathworm = new EntityDeathWorm(IafEntityRegistry.DEATH_WORM, this.field_70170_p);
            deathworm.setVariant(new Random().nextInt(3));
            deathworm.func_70903_f(true);
            deathworm.setWormHome(this.func_233580_cy_());
            deathworm.setWormAge(1);
            deathworm.setDeathWormScale(this.giant ? wormSize * 4.0f : wormSize);
            deathworm.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            if (thrower instanceof PlayerEntity) {
                deathworm.func_184754_b(thrower.func_110124_au());
            }
            this.field_70170_p.func_217376_c((Entity)deathworm);
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected Item func_213885_i() {
        return this.giant ? IafItemRegistry.DEATHWORM_EGG_GIGANTIC : IafItemRegistry.DEATHWORM_EGG;
    }
}

