/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.ai.StymphalianBirdAIAirTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class StymphalianBirdFlock {
    private EntityStymphalianBird leader;
    private ArrayList<EntityStymphalianBird> members = new ArrayList();
    private BlockPos leaderTarget;
    private BlockPos prevLeaderTarget;
    private Random random;
    private int distance = 15;

    private StymphalianBirdFlock() {
    }

    public static StymphalianBirdFlock createFlock(EntityStymphalianBird bird) {
        StymphalianBirdFlock flock = new StymphalianBirdFlock();
        flock.leader = bird;
        flock.members = new ArrayList();
        flock.members.add(bird);
        flock.leaderTarget = bird.airTarget;
        flock.random = bird.func_70681_au();
        return flock;
    }

    @Nullable
    public static StymphalianBirdFlock getNearbyFlock(EntityStymphalianBird bird) {
        float d0 = IafConfig.stymphalianBirdFlockLength;
        List list = bird.field_70170_p.func_175674_a((Entity)bird, new AxisAlignedBB(bird.func_226277_ct_(), bird.func_226278_cu_(), bird.func_226281_cx_(), bird.func_226277_ct_() + 1.0, bird.func_226278_cu_() + 1.0, bird.func_226281_cx_() + 1.0).func_72314_b((double)d0, 10.0, (double)d0), EntityStymphalianBird.STYMPHALIAN_PREDICATE);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityStymphalianBird)) continue;
                EntityStymphalianBird other = (EntityStymphalianBird)entity;
                if (other.flock == null) continue;
                return other.flock;
            }
        }
        return null;
    }

    public boolean isLeader(EntityStymphalianBird bird) {
        return this.leader != null && this.leader == bird;
    }

    public void addToFlock(EntityStymphalianBird bird) {
        this.members.add(bird);
    }

    public void update() {
        if (!(this.members.isEmpty() || this.leader != null && this.leader.func_70089_S())) {
            this.leader = this.members.get(this.random.nextInt(this.members.size()));
        }
        if (this.leader != null && this.leader.func_70089_S()) {
            this.prevLeaderTarget = this.leaderTarget;
            this.leaderTarget = this.leader.airTarget;
        }
    }

    public void onLeaderAttack(LivingEntity attackTarget) {
        for (EntityStymphalianBird bird : this.members) {
            if (bird.func_70638_az() != null || this.isLeader(bird)) continue;
            bird.func_70624_b(attackTarget);
        }
    }

    public EntityStymphalianBird getLeader() {
        return this.leader;
    }

    public void setTarget(BlockPos target) {
        this.leaderTarget = target;
        for (EntityStymphalianBird bird : this.members) {
            if (this.isLeader(bird)) continue;
            bird.airTarget = StymphalianBirdAIAirTarget.getNearbyAirTarget(bird);
        }
    }

    public void setFlying(boolean flying) {
        for (EntityStymphalianBird bird : this.members) {
            if (this.isLeader(bird)) continue;
            bird.setFlying(flying);
        }
    }

    public void setFearTarget(LivingEntity living) {
        for (EntityStymphalianBird bird : this.members) {
            bird.setVictor(living);
        }
    }
}

