/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.enums;

import com.github.alexthe666.iceandfire.item.ItemBestiary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public enum EnumBestiaryPages {
    INTRODUCTION(2),
    FIREDRAGON(4),
    FIREDRAGONEGG(1),
    ICEDRAGON(4),
    ICEDRAGONEGG(1),
    TAMEDDRAGONS(3),
    MATERIALS(2),
    ALCHEMY(1),
    DRAGONFORGE(3),
    HIPPOGRYPH(1),
    GORGON(1),
    PIXIE(1),
    CYCLOPS(2),
    SIREN(2),
    HIPPOCAMPUS(2),
    DEATHWORM(3),
    COCKATRICE(2),
    STYMPHALIANBIRD(1),
    TROLL(2),
    MYRMEX(4),
    AMPHITHERE(2),
    SEASERPENT(2),
    HYDRA(2),
    DREAD_MOBS(1),
    LIGHTNINGDRAGON(5),
    LIGHTNINGDRAGONEGG(1),
    GHOST(1);

    public int pages;

    private EnumBestiaryPages(int pages) {
        this.pages = pages;
    }

    public static List<Integer> toList(int[] containedpages) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int containedpage : containedpages) {
            if (containedpage < 0 || containedpage >= EnumBestiaryPages.values().length) continue;
            intList.add(containedpage);
        }
        return intList;
    }

    public static int[] fromList(List<Integer> containedpages) {
        int[] pages = new int[containedpages.size()];
        for (int i = 0; i < pages.length; ++i) {
            pages[i] = containedpages.get(i);
        }
        return pages;
    }

    public static List<EnumBestiaryPages> containedPages(List<Integer> pages) {
        Iterator<Integer> itr = pages.iterator();
        ArrayList<EnumBestiaryPages> list = new ArrayList<EnumBestiaryPages>();
        for (Integer page : pages) {
            if (page < 0 || page >= EnumBestiaryPages.values().length) continue;
            list.add(EnumBestiaryPages.values()[page]);
        }
        return list;
    }

    public static boolean hasAllPages(ItemStack book) {
        ArrayList<EnumBestiaryPages> allPages = new ArrayList<EnumBestiaryPages>();
        for (int i = 0; i < EnumBestiaryPages.values().length; ++i) {
            allPages.add(EnumBestiaryPages.values()[i]);
        }
        List<EnumBestiaryPages> pages = EnumBestiaryPages.containedPages(EnumBestiaryPages.toList(book.func_77978_p().func_74759_k("Pages")));
        Iterator iterator = allPages.iterator();
        if (iterator.hasNext()) {
            EnumBestiaryPages page = (EnumBestiaryPages)((Object)iterator.next());
            return !pages.contains((Object)page);
        }
        return false;
    }

    public static List<Integer> enumToInt(List<EnumBestiaryPages> pages) {
        Iterator<EnumBestiaryPages> itr = pages.iterator();
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (itr.hasNext()) {
            list.add(EnumBestiaryPages.values()[itr.next().ordinal()].ordinal());
        }
        return list;
    }

    public static EnumBestiaryPages getRand() {
        return EnumBestiaryPages.values()[new Random().nextInt(EnumBestiaryPages.values().length)];
    }

    public static void addRandomPage(ItemStack book) {
        List<EnumBestiaryPages> list;
        if (book.func_77973_b() instanceof ItemBestiary && (list = EnumBestiaryPages.possiblePages(book)) != null && !list.isEmpty()) {
            EnumBestiaryPages.addPage(list.get(new Random().nextInt(list.size())), book);
        }
    }

    public static List<EnumBestiaryPages> possiblePages(ItemStack book) {
        if (book.func_77973_b() instanceof ItemBestiary) {
            CompoundNBT tag = book.func_77978_p();
            ArrayList<EnumBestiaryPages> allPages = new ArrayList<EnumBestiaryPages>();
            for (EnumBestiaryPages page : EnumBestiaryPages.values()) {
                allPages.add(page);
            }
            List<EnumBestiaryPages> containedPages = EnumBestiaryPages.containedPages(EnumBestiaryPages.toList(tag.func_74759_k("Pages")));
            ArrayList<EnumBestiaryPages> possiblePages = new ArrayList<EnumBestiaryPages>();
            for (EnumBestiaryPages page : allPages) {
                if (containedPages.contains((Object)page)) continue;
                possiblePages.add(page);
            }
            return possiblePages;
        }
        return null;
    }

    public static boolean addPage(EnumBestiaryPages page, ItemStack book) {
        boolean flag = false;
        if (book.func_77973_b() instanceof ItemBestiary) {
            CompoundNBT tag = book.func_77978_p();
            List<EnumBestiaryPages> enumlist = EnumBestiaryPages.containedPages(EnumBestiaryPages.toList(tag.func_74759_k("Pages")));
            if (!enumlist.contains((Object)page)) {
                enumlist.add(page);
                flag = true;
            }
            tag.func_74783_a("Pages", EnumBestiaryPages.fromList(EnumBestiaryPages.enumToInt(enumlist)));
        }
        return flag;
    }

    @Nullable
    public static EnumBestiaryPages fromInt(int index) {
        if (index < 0) {
            return null;
        }
        int length = EnumBestiaryPages.values().length;
        return EnumBestiaryPages.values()[index % length];
    }
}

