/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageMultipartInteract {
    public int creatureID;
    public float dmg;

    public MessageMultipartInteract(int creatureID, float dmg) {
        this.creatureID = creatureID;
        this.dmg = dmg;
    }

    public MessageMultipartInteract() {
    }

    public static MessageMultipartInteract read(PacketBuffer buf) {
        return new MessageMultipartInteract(buf.readInt(), buf.readFloat());
    }

    public static void write(MessageMultipartInteract message, PacketBuffer buf) {
        buf.writeInt(message.creatureID);
        buf.writeFloat(message.dmg);
    }

    public static class Handler {
        public static void handle(MessageMultipartInteract message, Supplier<NetworkEvent.Context> context) {
            Entity entity;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.creatureID)) != null && entity instanceof LivingEntity) {
                double dist = player.func_70032_d(entity);
                LivingEntity mob = (LivingEntity)entity;
                if (dist < 100.0) {
                    if (message.dmg > 0.0f) {
                        mob.func_70097_a(DamageSource.func_76358_a((LivingEntity)player), message.dmg);
                    } else {
                        mob.func_184230_a((PlayerEntity)player, Hand.MAIN_HAND);
                    }
                }
            }
        }
    }
}

