/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateDragonforge {
    public long blockPos;
    public int cookTime;

    public MessageUpdateDragonforge(long blockPos, int houseType) {
        this.blockPos = blockPos;
        this.cookTime = houseType;
    }

    public MessageUpdateDragonforge() {
    }

    public static MessageUpdateDragonforge read(PacketBuffer buf) {
        return new MessageUpdateDragonforge(buf.readLong(), buf.readInt());
    }

    public static void write(MessageUpdateDragonforge message, PacketBuffer buf) {
        buf.writeLong(message.blockPos);
        buf.writeInt(message.cookTime);
    }

    public static class Handler {
        public static void handle(MessageUpdateDragonforge message, Supplier<NetworkEvent.Context> context) {
            BlockPos pos;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && player.field_70170_p.func_175625_s(pos = BlockPos.func_218283_e((long)message.blockPos)) != null && player.field_70170_p.func_175625_s(pos) instanceof TileEntityDragonforge) {
                TileEntityDragonforge house = (TileEntityDragonforge)player.field_70170_p.func_175625_s(pos);
                house.cookTime = message.cookTime;
                if (message.cookTime > 0) {
                    house.lastDragonFlameTimer = 40;
                }
            }
        }
    }
}

