/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPixieHouse;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdatePixieHouse {
    public long blockPos;
    public boolean hasPixie;
    public int pixieType;

    public MessageUpdatePixieHouse(long blockPos, boolean hasPixie, int pixieType) {
        this.blockPos = blockPos;
        this.hasPixie = hasPixie;
        this.pixieType = pixieType;
    }

    public MessageUpdatePixieHouse() {
    }

    public static MessageUpdatePixieHouse read(PacketBuffer buf) {
        return new MessageUpdatePixieHouse(buf.readLong(), buf.readBoolean(), buf.readInt());
    }

    public static void write(MessageUpdatePixieHouse message, PacketBuffer buf) {
        buf.writeLong(message.blockPos);
        buf.writeBoolean(message.hasPixie);
        buf.writeInt(message.pixieType);
    }

    public static class Handler {
        public static void handle(MessageUpdatePixieHouse message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null) {
                BlockPos pos = BlockPos.func_218283_e((long)message.blockPos);
                if (player.field_70170_p.func_175625_s(pos) != null && player.field_70170_p.func_175625_s(pos) instanceof TileEntityPixieHouse) {
                    TileEntityPixieHouse house = (TileEntityPixieHouse)player.field_70170_p.func_175625_s(pos);
                    house.hasPixie = message.hasPixie;
                    house.pixieType = message.pixieType;
                } else if (player.field_70170_p.func_175625_s(pos) != null && player.field_70170_p.func_175625_s(pos) instanceof TileEntityJar) {
                    TileEntityJar jar = (TileEntityJar)player.field_70170_p.func_175625_s(pos);
                    jar.hasPixie = message.hasPixie;
                    jar.pixieType = message.pixieType;
                }
            }
        }
    }
}

