/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Node;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.RandomPathResult;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.AbstractPathJob;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class PathJobRandomPos
extends AbstractPathJob {
    protected final BlockPos destination;
    protected final int distance;
    private static Random random = new Random();

    public PathJobRandomPos(World world, BlockPos start, int distance, int range, LivingEntity entity) {
        super(world, start, start, range, new RandomPathResult(), entity);
        this.distance = distance;
        Tuple<Direction, Direction> dir = this.getRandomDirectionTuple(random);
        this.destination = start.func_177967_a((Direction)dir.func_76341_a(), distance).func_177967_a((Direction)dir.func_76340_b(), distance);
    }

    private Tuple<Direction, Direction> getRandomDirectionTuple(Random random) {
        return new Tuple((Object)Direction.func_239631_a_((Random)random), (Object)Direction.func_239631_a_((Random)random));
    }

    @Override
    @Nullable
    protected Path search() {
        IceAndFire.LOGGER.info(String.format("Pathfinding from [%d,%d,%d] in the direction of [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.destination.func_177958_n(), this.destination.func_177956_o(), this.destination.func_177952_p()));
        return super.search();
    }

    @Override
    public RandomPathResult getResult() {
        return (RandomPathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        return Math.sqrt(this.destination.func_177951_i((Vector3i)new BlockPos(pos.func_177958_n(), this.destination.func_177956_o(), pos.func_177952_p())));
    }

    @Override
    protected boolean isAtDestination(Node n) {
        if (Math.sqrt(this.start.func_177951_i((Vector3i)n.pos)) > (double)this.distance && this.isWalkableSurface(this.world.func_180495_p(n.pos.func_177977_b()), n.pos.func_177977_b()) == AbstractPathJob.SurfaceType.WALKABLE) {
            this.getResult().randomPos = n.pos;
            return true;
        }
        return false;
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return this.destination.func_177951_i((Vector3i)n.pos);
    }
}

