/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCaveStalactites;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenIceDragonCave
extends Feature<NoFeatureConfig> {
    public static final ResourceLocation ICEDRAGON_CHEST = new ResourceLocation("iceandfire", "chest/ice_dragon_female_cave");
    public static final ResourceLocation ICEDRAGON_MALE_CHEST = new ResourceLocation("iceandfire", "chest/ice_dragon_male_cave");
    private static final WorldGenCaveStalactites CEILING_DECO = new WorldGenCaveStalactites(IafBlockRegistry.FROZEN_STONE, 3);
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static boolean isMale;

    public WorldGenIceDragonCave(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public static void setGoldPile(IWorld world, BlockPos pos, Random rand) {
        int chance = rand.nextInt(99) + 1;
        if (!(world.func_180495_p(pos).func_177230_c() instanceof ContainerBlock)) {
            if (chance < 60) {
                int goldRand = Math.max(1, IafConfig.dragonDenGoldAmount) * (isMale ? 1 : 2);
                boolean generateGold = rand.nextInt(goldRand) == 0;
                world.func_180501_a(pos, generateGold ? (BlockState)IafBlockRegistry.SILVER_PILE.func_176223_P().func_206870_a((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + rand.nextInt(7))) : Blocks.field_150350_a.func_176223_P(), 3);
            } else if (chance == 61) {
                TileEntity tileentity1;
                world.func_180501_a(pos, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)HORIZONTALS[rand.nextInt(3)]), 2);
                if (world.func_180495_p(pos).func_177230_c() instanceof ChestBlock && (tileentity1 = world.func_175625_s(pos)) instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity1).func_189404_a(isMale ? ICEDRAGON_MALE_CHEST : ICEDRAGON_CHEST, rand.nextLong());
                }
            }
        }
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator p_230362_3_, Random rand, BlockPos position, NoFeatureConfig p_230362_6_) {
        if (!IafWorldRegistry.isDimensionListedForDragons((IServerWorld)worldIn)) {
            return false;
        }
        if (!(IafConfig.generateDragonDens && rand.nextInt(IafConfig.generateDragonDenChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position) && IafWorldRegistry.isFarEnoughFromDangerousGen((IServerWorld)worldIn, position))) {
            return false;
        }
        ArrayList<SphereInfo> sphereList = new ArrayList<SphereInfo>();
        position = new BlockPos(position.func_177958_n(), 20 + rand.nextInt(20), position.func_177952_p());
        isMale = new Random().nextBoolean();
        int dragonAge = 75 + rand.nextInt(50);
        int radius = (int)((float)dragonAge * 0.2f) + rand.nextInt(8);
        this.createShell((IWorld)worldIn, rand, position, radius, sphereList);
        for (int i = 0; i < 3 + rand.nextInt(2); ++i) {
            Direction direction = HORIZONTALS[rand.nextInt(HORIZONTALS.length - 1)];
            this.createShell((IWorld)worldIn, rand, position.func_177967_a(direction, radius - 2), 2 * (int)((float)radius / 3.0f) + rand.nextInt(8), sphereList);
        }
        for (SphereInfo info : sphereList) {
            this.hollowOut((IWorld)worldIn, rand, info.pos, info.radius - 2);
            this.decorateCave((IWorld)worldIn, rand, info.pos, info.radius + 2);
        }
        sphereList.clear();
        EntityIceDragon dragon = new EntityIceDragon(IafEntityRegistry.ICE_DRAGON, (World)worldIn.func_201672_e());
        dragon.setGender(isMale);
        dragon.growDragon(dragonAge);
        dragon.setAgingDisabled(true);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(rand.nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.func_233686_v_(true);
        dragon.homePos = position;
        dragon.setHunger(50);
        worldIn.func_217376_c((Entity)dragon);
        return false;
    }

    private void decorateCave(IWorld worldIn, Random rand, BlockPos pos, int radius) {
        for (int i = 0; i < 15 + rand.nextInt(10); ++i) {
            CEILING_DECO.generate(worldIn, rand, this.offsetRandomlyByXZ(pos.func_177981_b(radius / 2 - 1), rand, rand.nextInt(radius) - radius / 2, rand.nextInt(radius) - radius / 2));
        }
        int j = radius;
        int k = radius / 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-j, -k, -l), (BlockPos)pos.func_177982_a(j, k / 2, l)).map(BlockPos::func_185334_h).forEach(blockPos -> {
            if (blockPos.func_177951_i((Vector3i)pos) <= (double)(f * f) && worldIn.func_180495_p(blockPos.func_177977_b()).func_185904_a() == Material.field_151576_e && worldIn.func_180495_p(blockPos).func_185904_a() != Material.field_151576_e) {
                WorldGenIceDragonCave.setGoldPile(worldIn, blockPos, rand);
            }
        });
    }

    private BlockPos offsetRandomlyBy(BlockPos in, Random rand, int offset1, int offset2) {
        return in.func_177967_a(Direction.values()[rand.nextInt(Direction.values().length - 1)], offset1).func_177967_a(Direction.values()[rand.nextInt(Direction.values().length - 1)], offset2);
    }

    private BlockPos offsetRandomlyByXZ(BlockPos in, Random rand, int offset1, int offset2) {
        return in.func_177982_a(offset1, 0, offset2);
    }

    private void createShell(IWorld worldIn, Random rand, BlockPos position, int radius, List<SphereInfo> sphereList) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).forEach(blockPos -> {
            if (blockPos.func_177951_i((Vector3i)position) <= (double)(f * f) && !(worldIn.func_180495_p(position).func_177230_c() instanceof ContainerBlock) && worldIn.func_180495_p(position).func_185887_b((IBlockReader)worldIn, position) >= 0.0f) {
                boolean doOres;
                boolean bl = doOres = rand.nextInt(IafConfig.oreToStoneRatioForDragonCaves + 1) == 0;
                if (doOres) {
                    int chance = rand.nextInt(199) + 1;
                    if (chance < 30) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150366_p.func_176223_P(), 3);
                    }
                    if (chance > 30 && chance < 40) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150352_o.func_176223_P(), 3);
                    }
                    if (chance > 40 && chance < 45) {
                        worldIn.func_180501_a(blockPos, IafConfig.generateCopperOre ? IafBlockRegistry.COPPER_ORE.func_176223_P() : IafBlockRegistry.FROZEN_STONE.func_176223_P(), 3);
                    }
                    if (chance > 45 && chance < 50) {
                        worldIn.func_180501_a(blockPos, IafConfig.generateSilverOre ? IafBlockRegistry.SILVER_ORE.func_176223_P() : IafBlockRegistry.FROZEN_STONE.func_176223_P(), 3);
                    }
                    if (chance > 50 && chance < 60) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150365_q.func_176223_P(), 3);
                    }
                    if (chance > 60 && chance < 70) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150450_ax.func_176223_P(), 3);
                    }
                    if (chance > 70 && chance < 80) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150369_x.func_176223_P(), 3);
                    }
                    if (chance > 80 && chance < 90) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150482_ag.func_176223_P(), 3);
                    }
                    if (chance > 90 && chance < 1000) {
                        worldIn.func_180501_a(blockPos, IafConfig.generateSapphireOre ? IafBlockRegistry.SAPPHIRE_ORE.func_176223_P() : Blocks.field_150412_bA.func_176223_P(), 3);
                    }
                } else {
                    worldIn.func_180501_a(blockPos, rand.nextBoolean() ? IafBlockRegistry.FROZEN_COBBLESTONE.func_176223_P() : IafBlockRegistry.FROZEN_STONE.func_176223_P(), 2);
                }
            }
        });
        sphereList.add(new SphereInfo(radius, position));
    }

    private void hollowOut(IWorld worldIn, Random rand, BlockPos position, int radius) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).forEach(blockPos -> {
            if (blockPos.func_177951_i((Vector3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f)) && !(worldIn.func_180495_p(position).func_177230_c() instanceof ContainerBlock)) {
                worldIn.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        });
    }

    private class SphereInfo {
        int radius;
        BlockPos pos;

        private SphereInfo(int radius, BlockPos pos) {
            this.radius = radius;
            this.pos = pos;
        }
    }
}

