/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.PlacementContext;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.decoration.IDungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

public class FloorDecoration
implements IDungeonDecoration {
    private final float chance;
    private final IBlockStateProvider blockStateProvider;

    public FloorDecoration(IBlockStateProvider blockStateProvider, float chance) {
        this.blockStateProvider = blockStateProvider;
        this.chance = chance;
    }

    @Override
    public void decorate(DungeonModel model, IWorld world, BlockPos origin, PlacementContext context, int width, int height, int length, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonPiece piece, int stage) {
        model.blocks.forEach(block -> {
            BlockPos pos = IDungeonDecoration.getRotatedBlockPos(block.position.func_177958_n(), block.position.func_177956_o() + 1, block.position.func_177952_p(), origin, model, piece.field_186169_c);
            if (!DungeonBuilder.isBlockProtected(world, origin, context) && block.type == DungeonModelBlockType.FLOOR && block.position.func_177956_o() < model.height - 1 && worldGenBounds.func_175898_b((Vector3i)pos) && structureBounds.func_175898_b((Vector3i)pos) && world.func_175623_d(origin.func_177971_a(block.position).func_177984_a()) && FloorDecoration.checkSolid(world, origin.func_177971_a(block.position), worldGenBounds, structureBounds) && DungeonBlocks.RANDOM.nextFloat() < this.chance) {
                world.func_180501_a(pos, this.blockStateProvider.get(world, pos), 2);
            }
        });
    }

    private static boolean checkSolid(IWorld world, BlockPos pos, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds) {
        return worldGenBounds.func_175898_b((Vector3i)pos) && structureBounds.func_175898_b((Vector3i)pos) && world.func_180495_p(pos).func_200132_m();
    }

    public static class NextToSolid
    implements IDungeonDecoration {
        private final float chance;
        private final IBlockStateProvider blockStateProvider;

        public NextToSolid(IBlockStateProvider blockStateProvider, float chance) {
            this.blockStateProvider = blockStateProvider;
            this.chance = chance;
        }

        @Override
        public void decorate(DungeonModel model, IWorld world, BlockPos origin, PlacementContext context, int width, int height, int length, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonPiece piece, int stage) {
            model.blocks.forEach(block -> {
                BlockPos pos;
                if (block.type == DungeonModelBlockType.FLOOR && block.position.func_177956_o() < model.height - 1 && worldGenBounds.func_175898_b((Vector3i)(pos = IDungeonDecoration.getRotatedBlockPos(block.position.func_177958_n(), block.position.func_177956_o() + 1, block.position.func_177952_p(), origin, model, piece.field_186169_c))) && structureBounds.func_175898_b((Vector3i)pos) && world.func_175623_d(pos) && world.func_180495_p(pos.func_177977_b()).func_200132_m() && !DungeonBuilder.isBlockProtected(world, pos, context) && (FloorDecoration.checkSolid(world, pos.func_177978_c(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.func_177974_f(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.func_177968_d(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.func_177976_e(), worldGenBounds, structureBounds)) && DungeonBlocks.RANDOM.nextFloat() < this.chance) {
                    world.func_180501_a(pos, this.blockStateProvider.get(world, pos), 2);
                }
            });
        }
    }
}

