/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.generator.layer;

import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.Tile;
import xiroc.dungeoncrawl.dungeon.generator.layer.LayerGeneratorSettings;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonNodeRoom;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonSideRoom;
import xiroc.dungeoncrawl.util.Position2D;

public abstract class LayerGenerator {
    public LayerGeneratorSettings settings;

    public static void createNodeRoom(Position2D center, DungeonLayer dungeonLayer) {
        LayerGenerator.placeNodeRoom(new DungeonNodeRoom(), center, dungeonLayer);
    }

    public static void placeNodeRoom(DungeonNodeRoom nodeRoom, Position2D center, DungeonLayer dungeonLayer) {
        nodeRoom.setGridPosition(center.x, center.z);
        Tile placeHolder = new Tile(nodeRoom).addFlag(Tile.Flag.PLACEHOLDER);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0 || !Position2D.isValid(center.x + x, center.z + z, dungeonLayer.width, dungeonLayer.length)) continue;
                dungeonLayer.grid[center.x + x][center.z + z] = placeHolder;
            }
        }
        dungeonLayer.grid[center.x][center.z] = new Tile(nodeRoom);
    }

    public static void createStarterRoom(DungeonLayer dungeonLayer, Random rand, int layer) {
        Tuple<Position2D, Rotation> sideRoomData = dungeonLayer.findStarterRoomData(dungeonLayer.start, rand);
        if (sideRoomData != null) {
            DungeonSideRoom room = new DungeonSideRoom();
            Direction dir = ((Rotation)sideRoomData.func_76340_b()).func_185831_a(Direction.WEST);
            room.openSide(dir);
            room.setGridPosition(((Position2D)sideRoomData.func_76341_a()).x, ((Position2D)sideRoomData.func_76341_a()).z);
            room.setRotation((Rotation)sideRoomData.func_76340_b());
            room.model = DungeonModels.KEY_TO_MODEL.get(DungeonModels.STARTER_ROOM);
            room.stage = layer;
            dungeonLayer.map.markPositionAsOccupied((Position2D)sideRoomData.func_76341_a());
            dungeonLayer.grid[((Position2D)sideRoomData.func_76341_a()).x][((Position2D)sideRoomData.func_76341_a()).z] = new Tile(room).addFlag(Tile.Flag.FIXED_MODEL);
            Position2D connectedSegment = ((Position2D)sideRoomData.func_76341_a()).shift(dir, 1);
            if (dungeonLayer.grid[connectedSegment.x][connectedSegment.z] != null) {
                dungeonLayer.grid[connectedSegment.x][connectedSegment.z].piece.openSide(dir.func_176734_d());
                dungeonLayer.rotatePiece(dungeonLayer.grid[connectedSegment.x][connectedSegment.z], rand);
            }
        }
    }

    public void initializeLayer(LayerGeneratorSettings settings, DungeonBuilder dungeonBuilder, Random rand, int layer, boolean isLastLayer) {
        this.settings = settings;
    }

    public abstract void generateLayer(DungeonBuilder var1, DungeonLayer var2, int var3, Random var4, Position2D var5);

    public void enableSecretRoom() {
    }
}

