/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.PlacementContext;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonEntrance
extends DungeonPiece {
    public DungeonEntrance() {
        super(StructurePieceTypes.ENTRANCE);
    }

    public DungeonEntrance(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.ENTRANCE, nbt);
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        int cursorHeight;
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return true;
        }
        Vector3i offset = this.model.getOffset(this.field_186169_c);
        int height = worldIn.func_201676_a(this.context.heightmapType, this.x + offset.func_177958_n() + 4, this.z + offset.func_177952_p() + 4);
        DungeonModel staircase = DungeonModels.KEY_TO_MODEL.get(DungeonModels.STAIRCASE);
        int maxBuried = Math.min(this.model.height / 4, 4);
        for (cursorHeight = this.y; cursorHeight < height && height - cursorHeight > maxBuried; cursorHeight += 8) {
            super.build(staircase, (IWorld)worldIn, structureBoundingBoxIn, new BlockPos(this.x + 2, cursorHeight, this.z + 2), this.theme, this.secondaryTheme, this.stage, this.context, true);
        }
        BlockPos pos = new BlockPos(this.x + 4, cursorHeight, this.z + 4).func_177971_a(offset);
        this.build(this.model, (IWorld)worldIn, structureBoundingBoxIn, pos, this.theme, this.secondaryTheme, this.stage, this.context, true);
        this.placeFeatures((IWorld)worldIn, this.context, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage);
        MutableBoundingBox populationBox = this.model.createBoundingBox(pos, this.field_186169_c);
        this.decorate((IWorld)worldIn, pos, this.context, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, populationBox, this.model);
        return true;
    }

    @Override
    public void setupBoundingBox() {
        if (this.model != null) {
            Vector3i offset = this.model.getOffset(this.field_186169_c);
            int x = this.x + 4 + offset.func_177958_n();
            int z = this.z + 4 + offset.func_177952_p();
            switch (this.field_186169_c) {
                case NONE: 
                case CLOCKWISE_180: {
                    this.field_74887_e = new MutableBoundingBox(x, 0, z, x + this.model.width - 1, 256, z + this.model.length - 1);
                    break;
                }
                case CLOCKWISE_90: 
                case COUNTERCLOCKWISE_90: {
                    this.field_74887_e = new MutableBoundingBox(x, 0, z, x + this.model.length - 1, 256, z + this.model.width - 1);
                    break;
                }
                default: {
                    DungeonCrawl.LOGGER.warn("Unknown entrance rotation: {}", (Object)this.field_186169_c);
                    this.field_74887_e = new MutableBoundingBox(x, 0, z, x + this.model.width - 1, 256, z + this.model.length - 1);
                }
            }
        }
    }

    @Override
    public int getDungeonPieceType() {
        return 6;
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
    }

    @Override
    public void build(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, PlacementContext context, boolean fillAir) {
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Building {} at ({} | {} | {})", (Object)model.getKey(), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
        model.blocks.forEach(block -> {
            BlockPos position = pos.func_177971_a(block.position);
            if (boundsIn.func_175898_b((Vector3i)position)) {
                BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, this.field_186169_c, world, position, theme, secondaryTheme, world.func_201674_k(), this.variation, this.stage);
                if (state == null) {
                    return;
                }
                this.placeBlock((DungeonModelBlock)block, world, context, theme, secondaryTheme, lootLevel, fillAir, position, state);
                if (block.type == DungeonModelBlockType.SOLID && block.position.func_177956_o() == 0 && world.func_175623_d(position.func_177977_b())) {
                    this.buildPillar(world, position.func_177977_b());
                }
            }
        });
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Finished building {} at ({} | {} | {})", (Object)model.getKey(), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }
}

